/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.wildfly.extras.patch.installer.IllegalStateAssertion;
import org.wildfly.extras.patch.installer.Support;

public abstract class AbstractInstaller {
    protected Path eapHome;
    protected boolean verbose;

    public abstract String getJarName();

    public void main(LinkedList<String> args) {
        while (!args.isEmpty()) {
            String arg = args.peekFirst();
            if ("--help".equals(arg)) {
                args.removeFirst();
                this.printHelp();
                System.exit(0);
                continue;
            }
            if (!"--verbose".equals(arg)) break;
            args.removeFirst();
            this.verbose = true;
        }
        if (!args.isEmpty()) {
            this.eapHome = Paths.get(args.removeFirst(), new String[0]);
        }
        try {
            this.run();
            System.exit(0);
        }
        catch (Throwable th) {
            if (this.verbose) {
                th.printStackTrace(System.err);
            } else {
                String message = th.getMessage();
                if (message != null) {
                    this.error("Error: " + message);
                } else {
                    this.error("Unexpected Error: " + th);
                }
            }
            System.exit(1);
        }
    }

    protected void printHelp() {
        this.error("NAME\n        " + this.getJarName() + " - Installs the distribution\n" + "\n" + "SYNOPSIS\n" + "        " + this.getJarName() + " [options] [<eap-home>]\n" + "\n" + "OPTIONS\n" + "        --help\n" + "            Shows this help screen.\n" + "        --verbose\n" + "            Show more detailed logging.\n" + "\n" + "ARGUMENTS\n" + "        <eap-home>\n" + "            The directory of the EAP installation. If not specified, the current\n" + "            working directory is used\n");
    }

    protected void error(String message) {
        System.err.println(message);
    }

    protected void warn(String message) {
        System.out.println(message);
    }

    protected void info(String message) {
        System.out.println(message);
    }

    protected void debug(String message) {
        if (this.verbose) {
            this.info(message);
        }
    }

    private void run() throws Exception {
        Object br;
        if (this.eapHome == null) {
            this.eapHome = new File(".").toPath().toAbsolutePath();
        }
        this.validateHomePath(this.eapHome);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path fusepatchPath = this.eapHome.resolve(Paths.get("modules/system/layers/fuse/org/wildfly/extras/patch", new String[0]));
        if (!fusepatchPath.toFile().exists()) {
            String resname = "META-INF/fuse-patch.version";
            InputStream resource = classLoader.getResourceAsStream(resname);
            IllegalStateAssertion.assertNotNull(resource, "Cannot obtain resource: " + resname);
            br = new BufferedReader(new InputStreamReader(resource));
            String fusepatchVersion = ((BufferedReader)br).readLine().trim();
            resname = "META-INF/repository/fuse-patch-distro-wildfly-" + fusepatchVersion + ".zip";
            resource = classLoader.getResourceAsStream(resname);
            IllegalStateAssertion.assertNotNull(resource, "Cannot obtain resource: " + resname);
            Properties installedFiles = new Properties();
            try (ZipInputStream distro = new ZipInputStream(resource);){
                this.unpack(resname, distro, installedFiles);
            }
        }
        Path jarPath = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        ZipInputStream zipstream = new ZipInputStream(new FileInputStream(jarPath.toFile()));
        br = null;
        try {
            Path repoPath = this.eapHome.resolve(Paths.get("fusepatch/repository", new String[0]));
            IllegalStateAssertion.assertTrue(repoPath.toFile().isDirectory(), "Not a valid repository path: " + repoPath);
            ZipEntry entry = zipstream.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.startsWith("META-INF/repository") && !entry.isDirectory()) {
                    Path path = Paths.get(name, new String[0]);
                    Path targetPath = repoPath.resolve(path.getFileName());
                    if (targetPath.toFile().exists()) {
                        this.warn("Skip already existing patch file: " + path.getFileName());
                    } else {
                        this.warn("Copy to repository: " + path.getFileName());
                        Files.copy(zipstream, targetPath, new CopyOption[0]);
                    }
                }
                entry = zipstream.getNextEntry();
            }
        }
        catch (Throwable repoPath) {
            br = repoPath;
            throw repoPath;
        }
        finally {
            if (zipstream != null) {
                if (br != null) {
                    try {
                        zipstream.close();
                    }
                    catch (Throwable repoPath) {
                        ((Throwable)br).addSuppressed(repoPath);
                    }
                } else {
                    zipstream.close();
                }
            }
        }
        String resname = "META-INF/fuse-install.commands";
        InputStream resource = classLoader.getResourceAsStream(resname);
        IllegalStateAssertion.assertNotNull(resource, "Cannot obtain resource: " + resname);
        BufferedReader br2 = new BufferedReader(new InputStreamReader(resource));
        String line = br2.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                this.info("Run command: " + line);
                Process proc = Support.exec(line.split("\\s"), this.eapHome.toFile());
                IllegalStateAssertion.assertEquals(0, proc.waitFor(), "Command did not terminate normally");
            }
            line = br2.readLine();
        }
    }

    private void validateHomePath(Path homePath) {
        Path versionPath = homePath.resolve(Paths.get("modules/system/layers/base/org/jboss/as/version/main/module.xml", new String[0]));
        IllegalStateAssertion.assertTrue(versionPath.toFile().isFile(), "The path '" + this.eapHome + "' is not a valid EAP installation location.");
    }

    private void unpack(String resname, ZipInputStream zipstream, Properties installedFiles) throws IOException {
        this.info("Installing " + Paths.get(resname, new String[0]).getFileName());
        ZipEntry entry = zipstream.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            Path targetPath = this.eapHome.resolve(entryName);
            if (entry.isDirectory()) {
                targetPath.toFile().mkdirs();
            } else if (targetPath.toFile().exists()) {
                if (Support.computeCRC32(targetPath.toFile()) != entry.getCrc()) {
                    this.info("WARN: Existing file found: not overwriting: " + targetPath);
                }
            } else {
                this.debug("extracting: " + entryName);
                Files.copy(zipstream, targetPath, new CopyOption[0]);
                if (targetPath.toString().endsWith(".sh") || targetPath.toString().endsWith(".bat")) {
                    targetPath.toFile().setExecutable(true);
                }
                installedFiles.setProperty(entry.getName(), "" + entry.getCrc());
            }
            entry = zipstream.getNextEntry();
        }
    }
}

