/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.rhino.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class PerformanceTracker {
    private final Node jsRoot;
    private final boolean trackGzippedSize;
    private final CodeChangeHandler.RecentChange codeChange = new CodeChangeHandler.RecentChange();
    private int curCodeSizeEstimate = -1;
    private int curZippedCodeSizeEstimate = -1;
    private Deque<String> currentRunningPass = new ArrayDeque<String>();
    private final Map<String, Long> runtimeRecord = Maps.newHashMap();
    private final Map<String, Integer> codeSizeRecord = Maps.newHashMap();
    private final Map<String, Integer> zippedCodeSizeRecord = Maps.newHashMap();

    PerformanceTracker(Node jsRoot, boolean trackGzippedSize) {
        this.jsRoot = jsRoot;
        this.trackGzippedSize = trackGzippedSize;
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String passName) {
        this.currentRunningPass.push(passName);
        this.codeChange.reset();
    }

    void recordPassStop(String passName, long result) {
        String currentPassName = this.currentRunningPass.pop();
        if (!passName.equals(currentPassName)) {
            throw new RuntimeException(passName + " is not running.");
        }
        Long total = this.runtimeRecord.get(passName);
        if (total == null) {
            total = 0L;
        }
        total = total + result;
        this.runtimeRecord.put(passName, total);
        if (this.codeChange.hasCodeChanged()) {
            CodeSizeEstimatePrinter printer = this.estimateCodeSize(this.jsRoot);
            this.curCodeSizeEstimate = PerformanceTracker.recordSizeChange(this.curCodeSizeEstimate, printer.calcSize(), passName, this.codeSizeRecord);
            this.curZippedCodeSizeEstimate = PerformanceTracker.recordSizeChange(this.curZippedCodeSizeEstimate, printer.calcZippedSize(), passName, this.zippedCodeSizeRecord);
        }
    }

    private static int recordSizeChange(int oldSize, int newSize, String passName, Map<String, Integer> record) {
        if (oldSize != -1) {
            int delta = oldSize - newSize;
            Integer reduction = record.get(passName);
            if (delta > 0) {
                reduction = reduction == null ? Integer.valueOf(delta) : Integer.valueOf(reduction + delta);
                record.put(passName, reduction);
            }
        }
        return newSize;
    }

    public ImmutableMap<String, Long> getRuntimeRecord() {
        return ImmutableMap.copyOf(this.runtimeRecord);
    }

    public ImmutableMap<String, Integer> getCodeSizeRecord() {
        return ImmutableMap.copyOf(this.codeSizeRecord);
    }

    public ImmutableMap<String, Integer> getZippedCodeSizeRecord() {
        return ImmutableMap.copyOf(this.zippedCodeSizeRecord);
    }

    private final CodeSizeEstimatePrinter estimateCodeSize(Node root) {
        CodeSizeEstimatePrinter cp = new CodeSizeEstimatePrinter(this.trackGzippedSize);
        CodeGenerator cg = new CodeGenerator(cp);
        cg.add(root);
        return cp;
    }

    private static final class CodeSizeEstimatePrinter
    extends CodeConsumer {
        private final boolean trackGzippedSize;
        private int size = 0;
        private char lastChar = '\u0000';
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final GZIPOutputStream stream;

        private CodeSizeEstimatePrinter(boolean trackGzippedSize) {
            this.trackGzippedSize = trackGzippedSize;
            try {
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void append(String str) {
            int len = str.length();
            if (len > 0) {
                this.size += len;
                this.lastChar = str.charAt(len - 1);
                if (this.trackGzippedSize) {
                    try {
                        this.stream.write(str.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        char getLastChar() {
            return this.lastChar;
        }

        private int calcSize() {
            return this.size;
        }

        private int calcZippedSize() {
            if (this.trackGzippedSize) {
                try {
                    this.stream.finish();
                    this.stream.flush();
                    this.stream.close();
                    return this.output.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return -1;
        }
    }
}

