/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticScope;
import java.io.Serializable;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node root, String sourceName) {
        this.root = root;
        this.sourceName = sourceName;
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression expr) {
        if (expr.isOptionalArg() || expr.isVarArgs()) {
            return expr;
        }
        return new JSTypeExpression(new Node(307, expr.root), expr.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getType() == 307;
    }

    public boolean isVarArgs() {
        return this.root.getType() == 305;
    }

    public JSType evaluate(StaticScope<JSType> scope, JSTypeRegistry registry) {
        JSType type = registry.createFromTypeNodes(this.root, this.sourceName, scope);
        this.root.setJSType(type);
        return type;
    }

    public boolean equals(Object other) {
        return other instanceof JSTypeExpression && ((JSTypeExpression)other).root.isEquivalentTo(this.root);
    }

    public int hashCode() {
        return this.root.toStringTree().hashCode();
    }

    public Node getRoot() {
        return this.root;
    }
}

