/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmLocalTransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.internal.executor.api.Executor;
import org.kie.internal.executor.api.ExecutorAdminService;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorService;

public class ExecutorServiceFactory {
    private static ExecutorService service = new ExecutorServiceImpl();
    private static JbpmServicesPersistenceManager pm = new JbpmServicesPersistenceManagerImpl();
    private static EntityManagerFactory emf;
    private static JbpmServicesTransactionManager jbpmTransactionManager;
    private static ExecutorQueryService queryService;
    private static Executor executor;
    private static ExecutorAdminService adminService;

    public static ExecutorService newExecutorService() {
        ExecutorServiceFactory.configure();
        return service;
    }

    private static void configure() {
        ExecutorServiceFactory.configurePersistenceManager();
        ((ExecutorQueryServiceImpl)queryService).setPm(pm);
        ((ExecutorServiceImpl)service).setQueryService(queryService);
        ExecutorServiceFactory.configureExecutorImpl();
        ((ExecutorServiceImpl)service).setExecutor(executor);
        ((ExecutorRequestAdminServiceImpl)adminService).setPm(pm);
        ((ExecutorServiceImpl)service).setAdminService(adminService);
    }

    public static void setEmf(EntityManagerFactory emf) {
        ExecutorServiceFactory.emf = emf;
    }

    public static void setJbpmTransactionManager(JbpmServicesTransactionManager jbpmTransactionManager) {
        ExecutorServiceFactory.jbpmTransactionManager = jbpmTransactionManager;
    }

    public static void configurePersistenceManager() {
        EntityManager em = emf.createEntityManager();
        ((JbpmServicesPersistenceManagerImpl)pm).setEm(em);
        ((JbpmServicesPersistenceManagerImpl)pm).setTransactionManager(jbpmTransactionManager);
    }

    public static void configureExecutorImpl() {
        ClassCacheManager classCacheManager = new ClassCacheManager();
        ExecutorRunnable runnable = new ExecutorRunnable();
        runnable.setClassCacheManager(classCacheManager);
        runnable.setPm(pm);
        runnable.setQueryService(queryService);
        ((ExecutorImpl)executor).setPm(pm);
        ((ExecutorImpl)executor).setExecutorRunnable(runnable);
        ((ExecutorImpl)executor).setQueryService(queryService);
        ((ExecutorImpl)executor).setClassCacheManager(classCacheManager);
    }

    static {
        jbpmTransactionManager = new JbpmLocalTransactionManager();
        queryService = new ExecutorQueryServiceImpl();
        executor = new ExecutorImpl();
        adminService = new ExecutorRequestAdminServiceImpl();
    }
}

