/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskNominatedEvent;
import org.jbpm.services.task.events.BeforeTaskNominatedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.impl.model.xml.adapter.OrganizationalEntityXmlAdapter;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NominateTaskCommand
extends TaskCommand<Void> {
    @XmlElement(name="potential-owner")
    @XmlJavaTypeAdapter(value=OrganizationalEntityXmlAdapter.class)
    private List<OrganizationalEntity> potentialOwners;

    public NominateTaskCommand() {
    }

    public NominateTaskCommand(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.taskId = taskId;
        this.userId = userId;
        this.potentialOwners = potentialOwners;
    }

    public void setPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (context.getTaskService() != null) {
            context.getTaskService().nominate(this.taskId, this.userId, this.potentialOwners);
            return null;
        }
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskNominatedEvent>(){}}).fire((Object)task);
        if (CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators())) {
            ((InternalTaskData)task.getTaskData()).assignOwnerAndStatus(this.potentialOwners);
            if (task.getTaskData().getStatus() == Status.Ready) {
                ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(this.potentialOwners);
            }
        } else {
            throw new PermissionDeniedException("User " + this.userId + " is not allowed to perform Nominate on Task " + this.taskId);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskNominatedEvent>(){}}).fire((Object)task);
        return null;
    }

    public List<OrganizationalEntity> getPotentialOwners() {
        return this.potentialOwners;
    }
}

