/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.query.DeadlineSummaryImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.cdi.BootOnLoad;
import org.jbpm.shared.services.impl.JbpmJTATransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.NotificationEvent;
import org.kie.internal.task.api.model.NotificationType;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
@BootOnLoad
@Singleton
public class TaskDeadlinesServiceImpl
implements TaskDeadlinesService {
    private static final Logger logger = LoggerFactory.getLogger(TaskDeadlinesServiceImpl.class);
    protected static volatile TaskDeadlinesService instance;
    private static ScheduledThreadPoolExecutor scheduler;
    private Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> startScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
    private Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> endScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
    private Map<String, JobHandle> jobHandles = new ConcurrentHashMap<String, JobHandle>();
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private TaskContentService taskContentService;
    @Inject
    private TaskQueryService taskQueryService;
    @Inject
    private Event<NotificationEvent> notificationEvents;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void setNotificationEvents(Event<NotificationEvent> notificationEvents) {
        this.notificationEvents = notificationEvents;
    }

    public void setTaskContentService(TaskContentService taskContentService) {
        this.taskContentService = taskContentService;
    }

    @PreDestroy
    public void dispose() {
        TaskDeadlinesServiceImpl.setInstance(null);
        try {
            if (scheduler != null) {
                scheduler.shutdownNow();
            }
            this.startScheduledTaskDeadlines.clear();
            this.endScheduledTaskDeadlines.clear();
            this.jobHandles.clear();
        }
        catch (Exception e) {
            logger.error("Error encountered when disposing TaskDeadlineService", (Throwable)e);
        }
    }

    @PostConstruct
    public void init() {
        TaskDeadlinesServiceImpl.setInstance(this);
        if (!((JbpmServicesPersistenceManagerImpl)this.pm).hasTransactionManager()) {
            ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager((JbpmServicesTransactionManager)new JbpmJTATransactionManager());
        }
        boolean txowner = this.pm.beginTransaction();
        try {
            long delay;
            long now = System.currentTimeMillis();
            List resultList = (List)this.pm.queryInTransaction("UnescalatedStartDeadlines");
            for (DeadlineSummaryImpl summary : resultList) {
                delay = summary.getDate().getTime() - now;
                this.schedule(summary.getTaskId(), summary.getDeadlineId(), delay, TaskDeadlinesService.DeadlineType.START);
            }
            resultList = (List)this.pm.queryInTransaction("UnescalatedEndDeadlines");
            for (DeadlineSummaryImpl summary : resultList) {
                delay = summary.getDate().getTime() - now;
                this.schedule(summary.getTaskId(), summary.getDeadlineId(), delay, TaskDeadlinesService.DeadlineType.END);
            }
            this.pm.endTransaction(txowner);
        }
        catch (Exception e) {
            this.pm.rollBackTransaction(txowner);
            logger.error("Error when executing deadlines", (Throwable)e);
        }
    }

    private void executeEscalatedDeadline(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
        if (!((JbpmServicesPersistenceManagerImpl)this.pm).hasTransactionManager()) {
            ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager((JbpmServicesTransactionManager)new JbpmJTATransactionManager());
        }
        boolean txowner = this.pm.beginTransaction();
        try {
            TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
            DeadlineImpl deadline = (DeadlineImpl)this.pm.find(DeadlineImpl.class, (Object)deadlineId);
            TaskData taskData = task.getTaskData();
            if (taskData != null && type.isValidStatus(taskData.getStatus())) {
                HashMap<String, Object> variables = null;
                ContentImpl content = (ContentImpl)this.pm.find(ContentImpl.class, (Object)taskData.getDocumentContentId());
                if (content != null) {
                    ContentMarshallerContext context = this.taskContentService.getMarshallerContext((Task)task);
                    Object objectFromBytes = ContentMarshallerHelper.unmarshall(content.getContent(), context.getEnvironment(), context.getClassloader());
                    if (objectFromBytes instanceof Map) {
                        variables = (HashMap<String, Object>)objectFromBytes;
                    } else {
                        variables = new HashMap<String, Object>();
                        variables.put("content", objectFromBytes);
                    }
                } else {
                    variables = Collections.emptyMap();
                }
                if (deadline == null || deadline.getEscalations() == null) {
                    return;
                }
                for (Escalation escalation : deadline.getEscalations()) {
                    if (!escalation.getReassignments().isEmpty()) {
                        Reassignment reassignment = (Reassignment)escalation.getReassignments().get(0);
                        logger.debug("Reassigning to {}", (Object)reassignment.getPotentialOwners());
                        ((InternalTaskData)task.getTaskData()).setStatus(Status.Ready);
                        ArrayList potentialOwners = new ArrayList(reassignment.getPotentialOwners());
                        ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
                        ((InternalTaskData)task.getTaskData()).setActualOwner(null);
                    }
                    for (Notification notification : escalation.getNotifications()) {
                        if (notification.getNotificationType() != NotificationType.Email) continue;
                        logger.debug("Sending an Email");
                        this.notificationEvents.fire((Object)new NotificationEvent(notification, (Task)task, variables));
                    }
                }
            }
            deadline.setEscalated(true);
            this.pm.endTransaction(txowner);
        }
        catch (Exception e) {
            this.pm.rollBackTransaction(txowner);
            logger.error("Error when executing deadlines", (Throwable)e);
        }
    }

    public void schedule(long taskId, long deadlineId, long delay, TaskDeadlinesService.DeadlineType type) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        String deploymentId = task.getTaskData().getDeploymentId();
        TimerService timerService = TimerServiceRegistry.getInstance().get(deploymentId + "-timerServiceId");
        if (timerService != null && timerService instanceof GlobalTimerService) {
            TaskDeadlineJob deadlineJob = new TaskDeadlineJob(taskId, deadlineId, type);
            IntervalTrigger trigger = new IntervalTrigger(timerService.getCurrentTime(), null, null, -1, delay, 0L, null, null);
            JobHandle handle = timerService.scheduleJob((Job)deadlineJob, (JobContext)new TaskDeadlineJobContext(deadlineJob.getId()), (Trigger)trigger);
            logger.debug("scheduling timer job for deadline {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), taskId, timerService});
            this.jobHandles.put(deadlineJob.getId(), handle);
        } else {
            ScheduledFuture<ScheduledTaskDeadline> scheduled = scheduler.schedule(new ScheduledTaskDeadline(taskId, deadlineId, type), delay, TimeUnit.MILLISECONDS);
            List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
            if (type == TaskDeadlinesService.DeadlineType.START) {
                knownFutures = this.startScheduledTaskDeadlines.get(taskId);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                knownFutures = this.endScheduledTaskDeadlines.get(taskId);
            }
            if (knownFutures == null) {
                knownFutures = new CopyOnWriteArrayList<ScheduledFuture<ScheduledTaskDeadline>>();
            }
            knownFutures.add(scheduled);
            if (type == TaskDeadlinesService.DeadlineType.START) {
                this.startScheduledTaskDeadlines.put(taskId, knownFutures);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                this.endScheduledTaskDeadlines.put(taskId, knownFutures);
            }
        }
    }

    public void unschedule(long taskId, TaskDeadlinesService.DeadlineType type) {
        block15: {
            block13: {
                TimerService timerService;
                Deadlines deadlines;
                block14: {
                    TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
                    String deploymentId = task.getTaskData().getDeploymentId();
                    deadlines = task.getDeadlines();
                    timerService = TimerServiceRegistry.getInstance().get(deploymentId + "-timerServiceId");
                    if (timerService == null || !(timerService instanceof GlobalTimerService)) break block13;
                    if (type != TaskDeadlinesService.DeadlineType.START) break block14;
                    List startDeadlines = deadlines.getStartDeadlines();
                    List resultList = (List)this.pm.queryInTransaction("UnescalatedStartDeadlines");
                    for (DeadlineSummaryImpl summary : resultList) {
                        TaskDeadlineJob deadlineJob = new TaskDeadlineJob(summary.getTaskId(), summary.getDeadlineId(), TaskDeadlinesService.DeadlineType.START);
                        logger.debug("unscheduling timer job for deadline {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), taskId, timerService});
                        JobHandle jobHandle = this.jobHandles.remove(deadlineJob.getId());
                        if (jobHandle == null) {
                            jobHandle = ((GlobalTimerService)timerService).buildJobHandleForContext((NamedJobContext)new TaskDeadlineJobContext(deadlineJob.getId()));
                        }
                        timerService.removeJob(jobHandle);
                        for (Deadline deadline : startDeadlines) {
                            if (deadline.getId() != summary.getDeadlineId()) continue;
                            deadline.setEscalated(Boolean.valueOf(true));
                        }
                    }
                    break block15;
                }
                if (type != TaskDeadlinesService.DeadlineType.END) break block15;
                List endDeadlines = deadlines.getStartDeadlines();
                List resultList = (List)this.pm.queryInTransaction("UnescalatedEndDeadlines");
                for (DeadlineSummaryImpl summary : resultList) {
                    TaskDeadlineJob deadlineJob = new TaskDeadlineJob(summary.getTaskId(), summary.getDeadlineId(), TaskDeadlinesService.DeadlineType.END);
                    logger.debug("unscheduling timer job for deadline {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), taskId, timerService});
                    JobHandle jobHandle = this.jobHandles.remove(deadlineJob.getId());
                    if (jobHandle == null) {
                        jobHandle = ((GlobalTimerService)timerService).buildJobHandleForContext((NamedJobContext)new TaskDeadlineJobContext(deadlineJob.getId()));
                    }
                    timerService.removeJob(jobHandle);
                    for (Deadline deadline : endDeadlines) {
                        if (deadline.getId() != summary.getDeadlineId()) continue;
                        deadline.setEscalated(Boolean.valueOf(true));
                    }
                }
                break block15;
            }
            List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
            if (type == TaskDeadlinesService.DeadlineType.START) {
                knownFutures = this.startScheduledTaskDeadlines.get(taskId);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                knownFutures = this.endScheduledTaskDeadlines.get(taskId);
            }
            if (knownFutures == null) {
                return;
            }
            for (ScheduledFuture<ScheduledTaskDeadline> scheduled : knownFutures) {
                try {
                    if (scheduled.isDone() || scheduled.isCancelled()) continue;
                    scheduled.cancel(true);
                }
                catch (Exception e) {
                    logger.error("Error while cancelling scheduled deadline task for Task with id {} -> {}", (Object)taskId, (Object)e);
                }
            }
        }
    }

    public void setTaskQueryService(TaskQueryService taskQueryService) {
        this.taskQueryService = taskQueryService;
    }

    public static TaskDeadlinesService getInstance() {
        return instance;
    }

    public static void setInstance(TaskDeadlinesService instance) {
        TaskDeadlinesServiceImpl.instance = instance;
    }

    static {
        scheduler = new ScheduledThreadPoolExecutor(3);
    }

    private static class TaskDeadlineJobContext
    implements NamedJobContext {
        private static final long serialVersionUID = -6838102884655249845L;
        private JobHandle jobHandle;
        private String jobName;

        public TaskDeadlineJobContext(String jobName) {
            this.jobName = jobName;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public String getJobName() {
            return this.jobName;
        }
    }

    private static class TaskDeadlineJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = -2453658968872574615L;
        private long taskId;
        private long deadlineId;
        private TaskDeadlinesService.DeadlineType type;

        public TaskDeadlineJob(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.type = type;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public TaskDeadlinesService.DeadlineType getType() {
            return this.type;
        }

        public void execute(JobContext ctx) {
            TaskDeadlinesService service = TaskDeadlinesServiceImpl.getInstance();
            if (service != null) {
                ((TaskDeadlinesServiceImpl)service).executeEscalatedDeadline(this.taskId, this.deadlineId, this.type);
            } else {
                logger.error("TaskDeadlineService instance is not available, most likely was not properly initialized - Job did not run!");
            }
        }

        public String getId() {
            return this.taskId + "_" + this.deadlineId + "_" + this.type;
        }
    }

    public static class ScheduledTaskDeadline
    implements Callable<ScheduledTaskDeadline>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long taskId;
        private long deadlineId;
        private TaskDeadlinesService.DeadlineType type;

        public ScheduledTaskDeadline(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.type = type;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public TaskDeadlinesService.DeadlineType getType() {
            return this.type;
        }

        @Override
        public ScheduledTaskDeadline call() throws Exception {
            TaskDeadlinesService service = TaskDeadlinesServiceImpl.getInstance();
            if (service != null) {
                ((TaskDeadlinesServiceImpl)service).executeEscalatedDeadline(this.taskId, this.deadlineId, this.type);
            } else {
                logger.error("TaskDeadlineService instance is not available, most likely was not properly initialized - Job did not run!");
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            if (this.taskId != other.taskId) {
                return false;
            }
            return !(this.type == null ? other.getType() != null : this.type.equals((Object)other.getType()));
        }
    }
}

