/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.kie.services.client.api.command.RemoteConfiguration;

public class RestRequestHelper {
    private ClientRequestFactory requestFactory;
    private static int DEFAULT_TIMEOUT = 5;

    private URL addRestToPath(URL origUrl) {
        StringBuilder urlString = new StringBuilder(origUrl.toExternalForm());
        if (!urlString.toString().endsWith("/")) {
            urlString.append("/");
        }
        urlString.append("rest/");
        URL origPlusRestUrl = RestRequestHelper.convertStringToUrl(urlString.toString());
        return origPlusRestUrl;
    }

    private static URL convertStringToUrl(String urlString) {
        URL realUrl;
        try {
            realUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + urlString + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return realUrl;
    }

    public RestRequestHelper(URL serverPortUrl, String username, String password, int timeout) {
        URL serverPlusRestUrl = this.addRestToPath(serverPortUrl);
        this.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout);
    }

    public RestRequestHelper(URL serverPortUrl, String username, String password) {
        URL serverPlusRestUrl = this.addRestToPath(serverPortUrl);
        this.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, DEFAULT_TIMEOUT);
    }

    public ClientRequest createRestRequest(String restOperationUrl) {
        if (restOperationUrl.startsWith("/")) {
            restOperationUrl = restOperationUrl.substring(1);
        }
        return this.requestFactory.createRelativeRequest(restOperationUrl);
    }

    public static ClientRequestFactory createRestRequestFactory(String restBaseUrlString, String username, String password, int timeout) {
        URL url = RestRequestHelper.convertStringToUrl(restBaseUrlString);
        return RemoteConfiguration.createAuthenticatingRequestFactory(url, username, password, timeout);
    }

    public static ClientRequestFactory createRestRequestFactory(String restBaseUrlString, String username, String password) {
        URL url = RestRequestHelper.convertStringToUrl(restBaseUrlString);
        return RemoteConfiguration.createAuthenticatingRequestFactory(url, username, password, DEFAULT_TIMEOUT);
    }

    public static ClientRequestFactory createRestRequestFactory(URL restBaseUrl, String username, String password) {
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, DEFAULT_TIMEOUT);
    }
}

