/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;

public class JaxbSerializationProvider
implements SerializationProvider {
    public static final int JMS_SERIALIZATION_TYPE = 0;
    private static Class<?>[] kieJaxbClasses = new Class[]{JaxbCommandsRequest.class, JaxbCommandsResponse.class, JaxbGenericResponse.class, JaxbProcessInstanceWithVariablesResponse.class};
    private Set<Class<?>> jaxbClasses = new HashSet(Arrays.asList(kieJaxbClasses));
    private Set<Class<?>> extraJaxbClasses = new HashSet();
    private JAXBContext jaxbContext;

    public JaxbSerializationProvider() {
        this.initializeJaxbContext();
    }

    public JaxbSerializationProvider(Set<Class<?>> extraJaxbClassList) {
        extraJaxbClassList.addAll(extraJaxbClassList);
        this.jaxbClasses.addAll(extraJaxbClassList);
        this.initializeJaxbContext();
    }

    private void initializeJaxbContext() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])this.jaxbClasses.toArray(new Class[this.jaxbClasses.size()]));
        }
        catch (JAXBException jaxbe) {
            throw new UnsupportedOperationException("Unsupported JAXB Class during initialization: " + jaxbe.getMessage(), jaxbe);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    @Override
    public String serialize(Object object) {
        Marshaller marshaller = null;
        try {
            marshaller = this.jaxbContext.createMarshaller();
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to create JAXB marshaller.", jaxbe);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            marshaller.marshal(object, (Writer)stringWriter);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to marshall " + object.getClass().getSimpleName() + " instance.", jaxbe);
        }
        String output = stringWriter.toString();
        return output;
    }

    @Override
    public Object deserialize(Object xmlStrObject) {
        if (!(xmlStrObject instanceof String)) {
            throw new UnsupportedOperationException(JaxbSerializationProvider.class.getSimpleName() + " can only deserialize Strings");
        }
        String xmlStr = (String)xmlStrObject;
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to create unmarshaller.", jaxbe);
        }
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlStr.getBytes(Charset.forName("UTF-8")));
        Object jaxbObj = null;
        try {
            jaxbObj = unmarshaller.unmarshal((InputStream)xmlStrInputStream);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to unmarshal string.", jaxbe);
        }
        return jaxbObj;
    }

    public void addJaxbClasses(Class<?> ... jaxbClass) {
        for (int i = 0; i < jaxbClass.length; ++i) {
            this.jaxbClasses.add(jaxbClass[i]);
            this.extraJaxbClasses.add(jaxbClass[i]);
        }
        this.initializeJaxbContext();
    }

    public void addJaxbClasses(List<Class<?>> jaxbClassList) {
        for (Class<?> jaxbClass : jaxbClassList) {
            this.jaxbClasses.add(jaxbClass);
            this.extraJaxbClasses.add(jaxbClass);
        }
        this.initializeJaxbContext();
    }

    public Set<Class<?>> getExtraJaxbClasses() {
        return new HashSet(this.extraJaxbClasses);
    }

    public static Set<Class<?>> commaSeperatedStringToClassSet(String extraClassNames) throws SerializationException {
        HashSet classList = new HashSet();
        if ((extraClassNames = extraClassNames.trim()).isEmpty() || !extraClassNames.contains(",")) {
            return classList;
        }
        String[] extraClassNameList = JaxbSerializationProvider.split(extraClassNames);
        if (extraClassNameList.length == 0) {
            return classList;
        }
        ClassLoader classLoader = JaxbSerializationProvider.class.getClassLoader();
        for (String extraClassName : extraClassNameList) {
            if (extraClassName.endsWith("[]")) continue;
            try {
                classList.add(classLoader.loadClass(extraClassName));
            }
            catch (ClassNotFoundException cnfe) {
                throw new SerializationException("Unable to load JAXB class '" + extraClassName, cnfe);
            }
        }
        return classList;
    }

    public static String classSetToCommaSeperatedString(Set<Class<?>> extraClassList) throws SerializationException {
        StringBuilder out = new StringBuilder("");
        for (Class<?> extraClass : extraClassList) {
            String extraClassName;
            if (out.length() > 0) {
                out.append(",");
            }
            if ((extraClassName = extraClass.getCanonicalName()) == null) {
                throw new SerializationException("Only classes with canonical names can be used for serialization");
            }
            out.append(extraClassName);
        }
        return out.toString();
    }

    public static String[] split(String in) {
        String[] splitIn = in.split(",");
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < splitIn.length; ++i) {
            splitIn[i] = splitIn[i].trim();
            if (splitIn[i].isEmpty()) continue;
            outList.add(splitIn[i]);
        }
        return outList.toArray(new String[outList.size()]);
    }
}

