/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.rest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jboss.resteasy.spi.BadRequestException;
import org.kie.services.client.serialization.jaxb.rest.AbstractJaxbResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;

@XmlRootElement(name="response")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbGenericResponse
extends AbstractJaxbResponse {
    @XmlElement
    @XmlSchemaType(name="string")
    private String error;
    @XmlElement
    @XmlSchemaType(name="string")
    private String stackTrace;

    public JaxbGenericResponse() {
    }

    public JaxbGenericResponse(HttpServletRequest request) {
        super(request);
    }

    public JaxbGenericResponse(HttpServletRequest request, Exception e) {
        super(request);
        this.setException(e);
    }

    public static String convertStackTraceToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public void setException(Exception e) {
        this.error = e.getMessage();
        if (!(e instanceof BadRequestException)) {
            this.status = JaxbRequestStatus.FAILURE;
            this.stackTrace = JaxbGenericResponse.convertStackTraceToString(e);
        } else {
            this.status = JaxbRequestStatus.BAD_REQUEST;
        }
    }

    @Override
    public String prettyPrint() throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    @Override
    public JaxbRequestStatus getStatus() {
        return this.status;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Override
    public void setStatus(JaxbRequestStatus status) {
        this.status = status;
    }
}

