/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class $Finalizer
implements Runnable {
    private static final Logger logger = Logger.getLogger($Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "com.google.inject.internal.util.$FinalizableReference";
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static ReferenceQueue<Object> startFinalizer(Class<?> finalizableReferenceClass, Object frq, String executorClassName) throws Exception {
        if (!finalizableReferenceClass.getName().equals(FINALIZABLE_REFERENCE)) {
            throw new IllegalArgumentException("Expected com.google.inject.internal.util.FinalizableReference.");
        }
        if ("NONE".equalsIgnoreCase(executorClassName)) {
            return null;
        }
        $Finalizer finalizer = new $Finalizer(finalizableReferenceClass, frq);
        if (executorClassName == null || executorClassName.length() == 0) {
            Thread thread = new Thread((Runnable)finalizer, $Finalizer.class.getName());
            thread.setDaemon(true);
            thread.start();
        } else {
            Class<?> executorClass;
            try {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                executorClass = tccl.loadClass(executorClassName);
            }
            catch (Throwable ignore) {
                executorClass = Class.forName(executorClassName);
            }
            ((Executor)executorClass.newInstance()).execute(finalizer);
        }
        return finalizer.queue;
    }

    public static ReferenceQueue<Object> startFinalizer(Class<?> finalizableReferenceClass, Object frq) throws Exception {
        String executorClassName = null;
        try {
            executorClassName = System.getProperty("guice.executor.class");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return $Finalizer.startFinalizer(finalizableReferenceClass, frq, executorClassName);
    }

    private $Finalizer(Class<?> finalizableReferenceClass, Object frq) {
        this.finalizableReferenceClassReference = new WeakReference(finalizableReferenceClass);
        this.frqReference = new PhantomReference<Object>(frq, this.queue);
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        this.cleanUp(this.queue.remove());
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (CancellationException cancellationException) {
            return;
        }
    }

    private void cleanUp(Reference<?> reference) {
        Method finalizeReferentMethod = this.getFinalizeReferentMethod();
        do {
            reference.clear();
            if (reference == this.frqReference) {
                throw new CancellationException();
            }
            try {
                finalizeReferentMethod.invoke(reference, new Object[0]);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", t);
            }
        } while ((reference = this.queue.poll()) != null);
    }

    private Method getFinalizeReferentMethod() {
        Class finalizableReferenceClass = (Class)this.finalizableReferenceClassReference.get();
        if (finalizableReferenceClass == null) {
            throw new CancellationException();
        }
        try {
            return finalizableReferenceClass.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

