/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.util.BytesRef;

class TypePromoter {
    private static final Map<Integer, DocValues.Type> FLAGS_MAP = new HashMap<Integer, DocValues.Type>();
    private static final TypePromoter IDENTITY_PROMOTER = new IdentityTypePromoter();
    public static final int VAR_TYPE_VALUE_SIZE = -1;
    private static final int IS_INT = 5;
    private static final int IS_BYTE = 2;
    private static final int IS_FLOAT = 4;
    private static final int IS_VAR = 8;
    private static final int IS_FIXED = 24;
    private static final int PROMOTE_TO_VAR_SIZE_MASK = -9;
    private static final int IS_STRAIGHT = 32;
    private static final int IS_DEREF = 96;
    private static final int IS_SORTED = 128;
    private static final int IS_8_BIT = 16128;
    private static final int IS_16_BIT = 15872;
    private static final int IS_32_BIT = 11264;
    private static final int IS_64_BIT = 2048;
    private static final int IS_32_BIT_FLOAT = 12288;
    private static final int IS_64_BIT_FLOAT = 8192;
    private DocValues.Type type;
    private int flags;
    private int valueSize;

    public int getValueSize() {
        return this.valueSize;
    }

    protected TypePromoter() {
    }

    protected TypePromoter(DocValues.Type type, int flags, int valueSize) {
        this.type = type;
        this.flags = flags;
        this.valueSize = valueSize;
    }

    protected TypePromoter set(DocValues.Type type, int flags, int valueSize) {
        this.type = type;
        this.flags = flags;
        this.valueSize = valueSize;
        return this;
    }

    public TypePromoter promote(TypePromoter promoter) {
        return this.promote(promoter, TypePromoter.newPromoter());
    }

    private TypePromoter promote(TypePromoter promoter, TypePromoter spare) {
        int promotedFlags = promoter.flags & this.flags;
        TypePromoter promoted = TypePromoter.reset(FLAGS_MAP.get(promotedFlags), this.valueSize, spare);
        if (promoted == null) {
            return TypePromoter.create(DocValues.Type.BYTES_VAR_STRAIGHT, -1);
        }
        if ((promoted.flags & 2) != 0 && (promoted.flags & 0x18) == 24) {
            if (this.valueSize == promoter.valueSize) {
                return promoted;
            }
            return TypePromoter.reset(FLAGS_MAP.get(promoted.flags & 0xFFFFFFF7), -1, spare);
        }
        return promoted;
    }

    public DocValues.Type type() {
        return this.type;
    }

    private boolean isTypeCompatible(TypePromoter promoter) {
        int promotedFlags = promoter.flags & this.flags;
        return (promotedFlags & 7) > 0;
    }

    private boolean isBytesCompatible(TypePromoter promoter) {
        int promotedFlags = promoter.flags & this.flags;
        return (promotedFlags & 2) > 0 && (promotedFlags & 0x18) > 0;
    }

    private boolean isNumericSizeCompatible(TypePromoter promoter) {
        int promotedFlags = promoter.flags & this.flags;
        return (promotedFlags & 2) == 0 && ((promotedFlags & 0x18) > 0 && (promotedFlags & 0x3F00) > 0 || (promotedFlags & 8) > 0);
    }

    public String toString() {
        return "TypePromoter [type=" + (Object)((Object)this.type) + ", sizeInBytes=" + this.valueSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.valueSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypePromoter other = (TypePromoter)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.valueSize == other.valueSize;
    }

    public static TypePromoter create(DocValues.Type type, int valueSize) {
        return TypePromoter.reset(type, valueSize, new TypePromoter());
    }

    private static TypePromoter reset(DocValues.Type type, int valueSize, TypePromoter promoter) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case BYTES_FIXED_DEREF: {
                return promoter.set(type, 122, valueSize);
            }
            case BYTES_FIXED_SORTED: {
                return promoter.set(type, 154, valueSize);
            }
            case BYTES_FIXED_STRAIGHT: {
                return promoter.set(type, 58, valueSize);
            }
            case BYTES_VAR_DEREF: {
                return promoter.set(type, 106, -1);
            }
            case BYTES_VAR_SORTED: {
                return promoter.set(type, 138, -1);
            }
            case BYTES_VAR_STRAIGHT: {
                return promoter.set(type, 42, -1);
            }
            case FIXED_INTS_16: {
                return promoter.set(type, 15933, valueSize);
            }
            case FIXED_INTS_32: {
                return promoter.set(type, 11325, valueSize);
            }
            case FIXED_INTS_64: {
                return promoter.set(type, 2109, valueSize);
            }
            case FIXED_INTS_8: {
                return promoter.set(type, 16189, valueSize);
            }
            case FLOAT_32: {
                return promoter.set(type, 12348, valueSize);
            }
            case FLOAT_64: {
                return promoter.set(type, 8252, valueSize);
            }
            case VAR_INTS: {
                return promoter.set(type, 45, -1);
            }
        }
        throw new IllegalStateException();
    }

    public static int getValueSize(DocValues.Type type, BytesRef ref) {
        switch (type) {
            case BYTES_VAR_DEREF: 
            case BYTES_VAR_SORTED: 
            case BYTES_VAR_STRAIGHT: 
            case VAR_INTS: {
                return -1;
            }
            case BYTES_FIXED_DEREF: 
            case BYTES_FIXED_SORTED: 
            case BYTES_FIXED_STRAIGHT: {
                assert (ref != null);
                return ref.length;
            }
            case FIXED_INTS_16: {
                return 2;
            }
            case FIXED_INTS_32: 
            case FLOAT_32: {
                return 4;
            }
            case FIXED_INTS_64: 
            case FLOAT_64: {
                return 8;
            }
            case FIXED_INTS_8: {
                return 1;
            }
        }
        throw new IllegalArgumentException("unknonw docvalues type: " + type.name());
    }

    public static TypePromoter getIdentityPromoter() {
        return IDENTITY_PROMOTER;
    }

    private static TypePromoter newPromoter() {
        return new TypePromoter(null, 0, -1);
    }

    static {
        for (DocValues.Type type : DocValues.Type.values()) {
            TypePromoter create = TypePromoter.create(type, -1);
            FLAGS_MAP.put(create.flags, type);
        }
    }

    static class TypeCompatibility {
        private final TypePromoter base;
        private final TypePromoter spare;

        TypeCompatibility(DocValues.Type type, int valueSize) {
            this.base = TypePromoter.create(type, valueSize);
            this.spare = TypePromoter.newPromoter();
        }

        boolean isCompatible(DocValues.Type type, int valueSize) {
            TypePromoter reset = TypePromoter.reset(type, valueSize, this.spare);
            if (this.base.isTypeCompatible(reset)) {
                if (this.base.isBytesCompatible(reset)) {
                    return this.base.valueSize == -1 || this.base.valueSize == valueSize;
                }
                if (this.base.flags == reset.flags) {
                    return true;
                }
                if (this.base.isNumericSizeCompatible(reset)) {
                    return this.base.valueSize == -1 || this.base.valueSize > valueSize && valueSize > 0;
                }
            }
            return false;
        }

        DocValues.Type getBaseType() {
            return this.base.type();
        }

        int getBaseSize() {
            return this.base.valueSize;
        }
    }

    private static class IdentityTypePromoter
    extends TypePromoter {
        public IdentityTypePromoter() {
            super(null, 0, -1);
        }

        @Override
        protected TypePromoter set(DocValues.Type type, int flags, int valueSize) {
            throw new UnsupportedOperationException("can not reset IdendityPromotoer");
        }

        @Override
        public TypePromoter promote(TypePromoter promoter) {
            return promoter;
        }
    }
}

