/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HealthStateChangeListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.MessageListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.pipeline.PipelineRegistry;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CompatibilityCheckStage;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ExternalViewComputeStage;
import org.apache.helix.controller.stages.MessageGenerationPhase;
import org.apache.helix.controller.stages.MessageSelectionStage;
import org.apache.helix.controller.stages.MessageThrottleStage;
import org.apache.helix.controller.stages.ReadClusterDataStage;
import org.apache.helix.controller.stages.RebalanceIdealStateStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.controller.stages.TaskAssignmentStage;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.log4j.Logger;

public class GenericHelixController
implements ConfigChangeListener,
IdealStateChangeListener,
LiveInstanceChangeListener,
MessageListener,
CurrentStateChangeListener,
ExternalViewChangeListener,
ControllerChangeListener,
HealthStateChangeListener {
    private static final Logger logger = Logger.getLogger((String)GenericHelixController.class.getName());
    volatile boolean init = false;
    private final PipelineRegistry _registry;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenInstances;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenSessions;
    ClusterStatusMonitor _clusterStatusMonitor;
    private boolean _paused = false;
    Timer _rebalanceTimer = null;
    int _timerPeriod = Integer.MAX_VALUE;

    public GenericHelixController() {
        this(GenericHelixController.createDefaultRegistry());
    }

    void startRebalancingTimer(int period, HelixManager manager) {
        logger.info((Object)("Controller starting timer at period " + period));
        if (period < this._timerPeriod) {
            if (this._rebalanceTimer != null) {
                this._rebalanceTimer.cancel();
            }
            this._rebalanceTimer = new Timer(true);
            this._timerPeriod = period;
            this._rebalanceTimer.scheduleAtFixedRate((TimerTask)new RebalanceTask(manager), this._timerPeriod, (long)this._timerPeriod);
        } else {
            logger.info((Object)("Controller already has timer at period " + this._timerPeriod));
        }
    }

    void stopRebalancingTimer() {
        if (this._rebalanceTimer != null) {
            this._rebalanceTimer.cancel();
            this._rebalanceTimer = null;
        }
        this._timerPeriod = Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineRegistry createDefaultRegistry() {
        logger.info((Object)"createDefaultRegistry");
        Class<GenericHelixController> clazz = GenericHelixController.class;
        synchronized (GenericHelixController.class) {
            PipelineRegistry registry = new PipelineRegistry();
            Pipeline dataRefresh = new Pipeline();
            dataRefresh.addStage(new ReadClusterDataStage());
            Pipeline rebalancePipeline = new Pipeline();
            rebalancePipeline.addStage(new ResourceComputationStage());
            rebalancePipeline.addStage(new CurrentStateComputationStage());
            rebalancePipeline.addStage(new RebalanceIdealStateStage());
            rebalancePipeline.addStage(new BestPossibleStateCalcStage());
            rebalancePipeline.addStage(new MessageGenerationPhase());
            rebalancePipeline.addStage(new MessageSelectionStage());
            rebalancePipeline.addStage(new MessageThrottleStage());
            rebalancePipeline.addStage(new TaskAssignmentStage());
            Pipeline externalViewPipeline = new Pipeline();
            externalViewPipeline.addStage(new ExternalViewComputeStage());
            Pipeline liveInstancePipeline = new Pipeline();
            liveInstancePipeline.addStage(new CompatibilityCheckStage());
            registry.register("idealStateChange", dataRefresh, rebalancePipeline);
            registry.register("currentStateChange", dataRefresh, rebalancePipeline, externalViewPipeline);
            registry.register("configChange", dataRefresh, rebalancePipeline);
            registry.register("liveInstanceChange", dataRefresh, liveInstancePipeline, rebalancePipeline, externalViewPipeline);
            registry.register("messageChange", dataRefresh, rebalancePipeline);
            registry.register("externalView", dataRefresh);
            registry.register("resume", dataRefresh, rebalancePipeline, externalViewPipeline);
            registry.register("periodicalRebalance", dataRefresh, rebalancePipeline, externalViewPipeline);
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public GenericHelixController(PipelineRegistry registry) {
        this._registry = registry;
        this._lastSeenInstances = new AtomicReference();
        this._lastSeenSessions = new AtomicReference();
    }

    protected synchronized void handleEvent(ClusterEvent event) {
        List<Pipeline> pipelines;
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        if (manager == null) {
            logger.error((Object)("No cluster manager in event:" + event.getName()));
            return;
        }
        if (!manager.isLeader()) {
            logger.error((Object)("Cluster manager: " + manager.getInstanceName() + " is not leader. Pipeline will not be invoked"));
            return;
        }
        if (this._paused) {
            logger.info((Object)("Cluster is paused. Ignoring the event:" + event.getName()));
            return;
        }
        NotificationContext context = null;
        if (event.getAttribute("changeContext") != null) {
            context = (NotificationContext)event.getAttribute("changeContext");
        }
        if (context != null) {
            if (context.getType() == NotificationContext.Type.FINALIZE) {
                if (this._clusterStatusMonitor != null) {
                    this._clusterStatusMonitor.reset();
                    this._clusterStatusMonitor = null;
                }
                this.stopRebalancingTimer();
                logger.info((Object)("Get FINALIZE notification, skip the pipeline. Event :" + event.getName()));
                return;
            }
            if (this._clusterStatusMonitor == null) {
                this._clusterStatusMonitor = new ClusterStatusMonitor(manager.getClusterName());
            }
            event.addAttribute("clusterStatusMonitor", this._clusterStatusMonitor);
        }
        if ((pipelines = this._registry.getPipelinesForEvent(event.getName())) == null || pipelines.size() == 0) {
            logger.info((Object)("No pipeline to run for event:" + event.getName()));
            return;
        }
        for (Pipeline pipeline : pipelines) {
            try {
                pipeline.handle(event);
                pipeline.finish();
            }
            catch (Exception e) {
                logger.error((Object)("Exception while executing pipeline: " + pipeline + ". Will not continue to next pipeline"), (Throwable)e);
                break;
            }
        }
    }

    @Override
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
    }

    @Override
    public void onStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        logger.info((Object)"START: GenericClusterController.onStateChange()");
        ClusterEvent event = new ClusterEvent("currentStateChange");
        event.addAttribute("helixmanager", changeContext.getManager());
        event.addAttribute("instanceName", instanceName);
        event.addAttribute("changeContext", changeContext);
        event.addAttribute("eventData", statesInfo);
        this.handleEvent(event);
        logger.info((Object)"END: GenericClusterController.onStateChange()");
    }

    @Override
    public void onHealthChange(String instanceName, List<HealthStat> reports, NotificationContext changeContext) {
    }

    @Override
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        logger.info((Object)"START: GenericClusterController.onMessage()");
        ClusterEvent event = new ClusterEvent("messageChange");
        event.addAttribute("helixmanager", changeContext.getManager());
        event.addAttribute("instanceName", instanceName);
        event.addAttribute("changeContext", changeContext);
        event.addAttribute("eventData", messages);
        this.handleEvent(event);
        if (this._clusterStatusMonitor != null && messages != null) {
            this._clusterStatusMonitor.addMessageQueueSize(instanceName, messages.size());
        }
        logger.info((Object)"END: GenericClusterController.onMessage()");
    }

    @Override
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        logger.info((Object)"START: Generic GenericClusterController.onLiveInstanceChange()");
        if (liveInstances == null) {
            liveInstances = Collections.emptyList();
        }
        if (changeContext.getType() == NotificationContext.Type.INIT || changeContext.getType() == NotificationContext.Type.CALLBACK) {
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        } else if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info((Object)("remove message/current-state listeners. lastSeenInstances: " + this._lastSeenInstances + ", lastSeenSessions: " + this._lastSeenSessions));
            liveInstances = Collections.emptyList();
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        }
        ClusterEvent event = new ClusterEvent("liveInstanceChange");
        event.addAttribute("helixmanager", changeContext.getManager());
        event.addAttribute("changeContext", changeContext);
        event.addAttribute("eventData", liveInstances);
        this.handleEvent(event);
        logger.info((Object)"END: Generic GenericClusterController.onLiveInstanceChange()");
    }

    void checkRebalancingTimer(HelixManager manager, List<IdealState> idealStates) {
        if (manager.getConfigAccessor() == null) {
            logger.warn((Object)(manager.getInstanceName() + " config accessor doesn't exist. should be in file-based mode."));
            return;
        }
        for (IdealState idealState : idealStates) {
            int period = idealState.getRebalanceTimerPeriod();
            if (period <= 0) continue;
            this.startRebalancingTimer(period, manager);
        }
    }

    @Override
    public void onIdealStateChange(List<IdealState> idealStates, NotificationContext changeContext) {
        logger.info((Object)"START: Generic GenericClusterController.onIdealStateChange()");
        ClusterEvent event = new ClusterEvent("idealStateChange");
        event.addAttribute("helixmanager", changeContext.getManager());
        event.addAttribute("changeContext", changeContext);
        event.addAttribute("eventData", idealStates);
        this.handleEvent(event);
        if (changeContext.getType() != NotificationContext.Type.FINALIZE) {
            this.checkRebalancingTimer(changeContext.getManager(), idealStates);
        }
        logger.info((Object)"END: Generic GenericClusterController.onIdealStateChange()");
    }

    @Override
    public void onConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        logger.info((Object)"START: GenericClusterController.onConfigChange()");
        ClusterEvent event = new ClusterEvent("configChange");
        event.addAttribute("changeContext", changeContext);
        event.addAttribute("helixmanager", changeContext.getManager());
        event.addAttribute("eventData", configs);
        this.handleEvent(event);
        logger.info((Object)"END: GenericClusterController.onConfigChange()");
    }

    @Override
    public void onControllerChange(NotificationContext changeContext) {
        PropertyKey.Builder keyBuilder;
        logger.info((Object)"START: GenericClusterController.onControllerChange()");
        if (changeContext != null && changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info((Object)"GenericClusterController.onControllerChange() FINALIZE");
            return;
        }
        HelixDataAccessor accessor = changeContext.getManager().getHelixDataAccessor();
        LiveInstance leader = (LiveInstance)accessor.getProperty((keyBuilder = accessor.keyBuilder()).controllerLeader());
        if (leader == null) {
            logger.warn((Object)("No controller exists for cluster:" + changeContext.getManager().getClusterName()));
            return;
        }
        String leaderName = leader.getInstanceName();
        String instanceName = changeContext.getManager().getInstanceName();
        if (leaderName == null || !leaderName.equals(instanceName)) {
            logger.warn((Object)("leader name does NOT match, my name: " + instanceName + ", leader: " + leader));
            return;
        }
        PauseSignal pauseSignal = (PauseSignal)accessor.getProperty(keyBuilder.pause());
        if (pauseSignal != null) {
            this._paused = true;
            logger.info((Object)"controller is now paused");
        } else if (this._paused) {
            logger.info((Object)"controller is now resumed");
            this._paused = false;
            ClusterEvent event = new ClusterEvent("resume");
            event.addAttribute("changeContext", changeContext);
            event.addAttribute("helixmanager", changeContext.getManager());
            event.addAttribute("eventData", pauseSignal);
            this.handleEvent(event);
        } else {
            this._paused = false;
        }
        logger.info((Object)"END: GenericClusterController.onControllerChange()");
    }

    protected void checkLiveInstancesObservation(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        String instanceName;
        HashMap<String, LiveInstance> curInstances = new HashMap<String, LiveInstance>();
        HashMap<String, LiveInstance> curSessions = new HashMap<String, LiveInstance>();
        for (LiveInstance liveInstance : liveInstances) {
            curInstances.put(liveInstance.getInstanceName(), liveInstance);
            curSessions.put(liveInstance.getSessionId(), liveInstance);
        }
        Map<String, LiveInstance> lastInstances = this._lastSeenInstances.get();
        Map<String, LiveInstance> lastSessions = this._lastSeenSessions.get();
        HelixManager manager = changeContext.getManager();
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        if (lastSessions != null) {
            for (String session : lastSessions.keySet()) {
                if (curSessions.containsKey(session)) continue;
                instanceName = lastSessions.get(session).getInstanceName();
                manager.removeListener(keyBuilder.currentStates(instanceName, session), this);
            }
        }
        if (lastInstances != null) {
            for (String instance : lastInstances.keySet()) {
                if (curInstances.containsKey(instance)) continue;
                manager.removeListener(keyBuilder.messages(instance), this);
            }
        }
        for (String session : curSessions.keySet()) {
            if (lastSessions != null && lastSessions.containsKey(session)) continue;
            instanceName = ((LiveInstance)curSessions.get(session)).getInstanceName();
            try {
                manager.addCurrentStateChangeListener(this, instanceName, session);
                logger.info((Object)(manager.getInstanceName() + " added current-state listener for instance: " + instanceName + ", session: " + session + ", listener: " + this));
            }
            catch (Exception e) {
                logger.error((Object)("Fail to add current state listener for instance: " + instanceName + " with session: " + session), (Throwable)e);
            }
        }
        for (String instance : curInstances.keySet()) {
            if (lastInstances != null && lastInstances.containsKey(instance)) continue;
            try {
                manager.addMessageListener(this, instance);
                logger.info((Object)(manager.getInstanceName() + " added message listener for " + instance + ", listener: " + this));
            }
            catch (Exception e) {
                logger.error((Object)("Fail to add message listener for instance: " + instance), (Throwable)e);
            }
        }
        this._lastSeenInstances.set(curInstances);
        this._lastSeenSessions.set(curSessions);
    }

    class RebalanceTask
    extends TimerTask {
        HelixManager _manager;

        public RebalanceTask(HelixManager manager) {
            this._manager = manager;
        }

        @Override
        public void run() {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.CALLBACK);
            ClusterEvent event = new ClusterEvent("periodicalRebalance");
            event.addAttribute("helixmanager", changeContext.getManager());
            event.addAttribute("changeContext", changeContext);
            ArrayList dummy = new ArrayList();
            event.addAttribute("eventData", dummy);
            GenericHelixController.this.handleEvent(event);
        }
    }
}

