/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;

public class RebalanceIdealStateStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger((String)RebalanceIdealStateStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        Map<String, IdealState> idealStateMap = cache.getIdealStates();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        HashMap<String, IdealState> updatedIdealStates = new HashMap<String, IdealState>();
        for (String resourceName : idealStateMap.keySet()) {
            IdealState currentIdealState = idealStateMap.get(resourceName);
            if (currentIdealState.getRebalanceMode() != IdealState.RebalanceMode.USER_DEFINED || currentIdealState.getRebalancerClassName() == null) continue;
            String rebalancerClassName = currentIdealState.getRebalancerClassName();
            LOG.info((Object)("resource " + resourceName + " use idealStateRebalancer " + rebalancerClassName));
            try {
                Rebalancer balancer = (Rebalancer)HelixUtil.loadClass(this.getClass(), rebalancerClassName).newInstance();
                balancer.init(manager);
                IdealState newIdealState = balancer.computeNewIdealState(resourceName, idealStateMap.get(resourceName), currentStateOutput, cache);
                updatedIdealStates.put(resourceName, newIdealState);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while invoking custom rebalancer class:" + rebalancerClassName), (Throwable)e);
            }
        }
        if (updatedIdealStates.size() > 0) {
            cache.getIdealStates().putAll(updatedIdealStates);
        }
    }
}

