/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import java.util.List;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.Message;
import org.apache.helix.participant.CustomCodeCallbackHandler;
import org.apache.helix.participant.CustomCodeInvoker;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.log4j.Logger;

@StateModelInfo(initialState="OFFLINE", states={"LEADER", "STANDBY"})
public class GenericLeaderStandbyModel
extends StateModel {
    private static Logger LOG = Logger.getLogger(GenericLeaderStandbyModel.class);
    private final CustomCodeInvoker _particHolder;
    private final List<HelixConstants.ChangeType> _notificationTypes;

    public GenericLeaderStandbyModel(CustomCodeCallbackHandler callback, List<HelixConstants.ChangeType> notificationTypes, String partitionKey) {
        this._particHolder = new CustomCodeInvoker(callback, partitionKey);
        this._notificationTypes = notificationTypes;
    }

    @Transition(to="STANDBY", from="OFFLINE")
    public void onBecomeStandbyFromOffline(Message message, NotificationContext context) {
        LOG.info((Object)"Become STANDBY from OFFLINE");
    }

    @Transition(to="LEADER", from="STANDBY")
    public void onBecomeLeaderFromStandby(Message message, NotificationContext context) throws Exception {
        LOG.info((Object)"Become LEADER from STANDBY");
        HelixManager manager = context.getManager();
        if (manager == null) {
            throw new IllegalArgumentException("Require HelixManager in notification conext");
        }
        for (HelixConstants.ChangeType notificationType : this._notificationTypes) {
            if (notificationType == HelixConstants.ChangeType.LIVE_INSTANCE) {
                manager.addLiveInstanceChangeListener(this._particHolder);
                continue;
            }
            if (notificationType == HelixConstants.ChangeType.CONFIG) {
                manager.addConfigChangeListener(this._particHolder);
                continue;
            }
            if (notificationType == HelixConstants.ChangeType.EXTERNAL_VIEW) {
                manager.addExternalViewChangeListener(this._particHolder);
                continue;
            }
            LOG.error((Object)("Unsupport notificationType:" + notificationType.toString()));
        }
    }

    @Transition(to="STANDBY", from="LEADER")
    public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
        LOG.info((Object)"Become STANDBY from LEADER");
        HelixManager manager = context.getManager();
        if (manager == null) {
            throw new IllegalArgumentException("Require HelixManager in notification conext");
        }
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        for (HelixConstants.ChangeType notificationType : this._notificationTypes) {
            if (notificationType == HelixConstants.ChangeType.LIVE_INSTANCE) {
                manager.removeListener(keyBuilder.liveInstances(), this._particHolder);
                continue;
            }
            if (notificationType == HelixConstants.ChangeType.CONFIG) {
                manager.removeListener(keyBuilder.instanceConfigs(), this._particHolder);
                continue;
            }
            if (notificationType == HelixConstants.ChangeType.EXTERNAL_VIEW) {
                manager.removeListener(keyBuilder.externalViews(), this._particHolder);
                continue;
            }
            LOG.error((Object)("Unsupport notificationType:" + notificationType.toString()));
        }
    }

    @Transition(to="OFFLINE", from="STANDBY")
    public void onBecomeOfflineFromStandby(Message message, NotificationContext context) {
        LOG.info((Object)"Become OFFLINE from STANDBY");
    }
}

