/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.drools.scorecards.ScorecardError;
import org.drools.scorecards.drl.DeclaredTypesDRLEmitter;
import org.drools.scorecards.drl.ExternalModelDRLEmitter;
import org.drools.scorecards.parser.AbstractScorecardParser;
import org.drools.scorecards.parser.ScorecardParseException;
import org.drools.scorecards.parser.xls.XLSScorecardParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScorecardCompiler {
    private PMML pmmlDocument = null;
    public static final String DEFAULT_SHEET_NAME = "scorecards";
    private List<ScorecardError> scorecardErrors;
    private DrlType drlType;
    private static final Logger logger = LoggerFactory.getLogger(ScorecardCompiler.class);

    public ScorecardCompiler(DrlType drlType) {
        this.drlType = drlType;
    }

    public ScorecardCompiler() {
        this(DrlType.INTERNAL_DECLARED_TYPES);
    }

    public DrlType getDrlType() {
        return this.drlType;
    }

    public void setDrlType(DrlType drlType) {
        this.drlType = drlType;
    }

    protected void setPMMLDocument(PMML pmmlDocument) {
        this.pmmlDocument = pmmlDocument;
    }

    public boolean compileFromExcel(String pathToFile) {
        return this.compileFromExcel(pathToFile, DEFAULT_SHEET_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileFromExcel(String pathToFile, String worksheetName) {
        FileInputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            inputStream = new FileInputStream(pathToFile);
            bufferedInputStream = new BufferedInputStream(inputStream);
            boolean bl = this.compileFromExcel(bufferedInputStream, worksheetName);
            this.closeStream(bufferedInputStream);
            this.closeStream(inputStream);
            return bl;
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                this.closeStream(bufferedInputStream);
                this.closeStream(inputStream);
            }
            catch (Throwable throwable) {
                this.closeStream(bufferedInputStream);
                this.closeStream(inputStream);
                throw throwable;
            }
        }
        return false;
    }

    public boolean compileFromExcel(InputStream stream) {
        return this.compileFromExcel(stream, DEFAULT_SHEET_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileFromExcel(InputStream stream, String worksheetName) {
        try {
            XLSScorecardParser parser = new XLSScorecardParser();
            this.scorecardErrors = ((AbstractScorecardParser)parser).parseFile(stream, worksheetName);
            if (this.scorecardErrors.isEmpty()) {
                this.pmmlDocument = ((AbstractScorecardParser)parser).getPMMLDocument();
                boolean bl = true;
                return bl;
            }
        }
        catch (ScorecardParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeStream(stream);
        }
        return false;
    }

    public boolean compileFromPMML(InputStream stream) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{PMML.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            this.pmmlDocument = (PMML)unmarshaller.unmarshal(stream);
            if (this.pmmlDocument == null) {
                return false;
            }
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public PMML getPMMLDocument() {
        return this.pmmlDocument;
    }

    public String getPMML() {
        if (this.pmmlDocument == null) {
            return null;
        }
        JAXBContext ctx = null;
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{PMML.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)this.pmmlDocument, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getDRL() {
        if (this.pmmlDocument != null) {
            if (this.drlType == DrlType.INTERNAL_DECLARED_TYPES) {
                return new DeclaredTypesDRLEmitter().emitDRL(this.pmmlDocument);
            }
            if (this.drlType == DrlType.EXTERNAL_OBJECT_MODEL) {
                return new ExternalModelDRLEmitter().emitDRL(this.pmmlDocument);
            }
        }
        return null;
    }

    public static String convertToDRL(PMML pmml, DrlType drlType) {
        if (pmml != null) {
            ScorecardCompiler scorecardCompiler = new ScorecardCompiler(drlType);
            scorecardCompiler.setPMMLDocument(pmml);
            return scorecardCompiler.getDRL();
        }
        return null;
    }

    public List<ScorecardError> getScorecardParseErrors() {
        return this.scorecardErrors;
    }

    private void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static enum DrlType {
        INTERNAL_DECLARED_TYPES,
        EXTERNAL_OBJECT_MODEL;

    }
}

