/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.drools.scorecards.ScorecardError;
import org.drools.scorecards.parser.AbstractScorecardParser;
import org.drools.scorecards.parser.ScorecardParseException;
import org.drools.scorecards.parser.xls.MergedCellRange;
import org.drools.scorecards.parser.xls.XLSEventDataCollector;
import org.drools.scorecards.pmml.PMMLGenerator;

public class XLSScorecardParser
extends AbstractScorecardParser {
    protected XLSEventDataCollector excelDataCollector;
    private Scorecard scorecard;
    private PMML pmmlDocument = null;
    List<ScorecardError> parseErrors = new ArrayList<ScorecardError>();
    private HSSFSheet currentWorksheet;

    @Override
    public List<ScorecardError> parseFile(InputStream inStream, String worksheetName) throws ScorecardParseException {
        try {
            this.excelDataCollector = new XLSEventDataCollector();
            this.excelDataCollector.setParser(this);
            HSSFWorkbook workbook = new HSSFWorkbook(inStream);
            HSSFSheet worksheet = workbook.getSheet(worksheetName);
            if (worksheet == null) {
                throw new ScorecardParseException("No worksheet found with name '" + worksheetName + "'.");
            }
            this.currentWorksheet = worksheet;
            this.excelDataCollector.sheetStart(worksheetName);
            this.excelDataCollector.setMergedRegionsInSheet(this.getMergedCellRangeList(worksheet));
            this.processSheet(worksheet);
            this.excelDataCollector.sheetComplete();
            this.parseErrors = this.excelDataCollector.getParseErrors();
            this.scorecard = this.excelDataCollector.getScorecard();
        }
        catch (IOException e) {
            throw new ScorecardParseException(e);
        }
        return this.parseErrors;
    }

    @Override
    public PMML getPMMLDocument() {
        if (this.pmmlDocument == null) {
            this.pmmlDocument = new PMMLGenerator().generateDocument(this.scorecard);
        }
        return this.pmmlDocument;
    }

    private void processSheet(HSSFSheet worksheet) throws ScorecardParseException {
        for (Row row : worksheet) {
            int currentRowCtr = row.getRowNum();
            this.excelDataCollector.newRow(currentRowCtr);
            for (Cell cell : row) {
                int currentColCtr = cell.getColumnIndex();
                switch (cell.getCellType()) {
                    case 1: {
                        this.excelDataCollector.newCell(currentRowCtr, currentColCtr, cell.getStringCellValue());
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            this.excelDataCollector.newCell(currentRowCtr, currentColCtr, cell.getDateCellValue());
                            break;
                        }
                        this.excelDataCollector.newCell(currentRowCtr, currentColCtr, cell.getNumericCellValue());
                        break;
                    }
                    case 4: {
                        this.excelDataCollector.newCell(currentRowCtr, currentColCtr, Boolean.valueOf(cell.getBooleanCellValue()).toString());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.excelDataCollector.newCell(currentRowCtr, currentColCtr, "");
                    }
                }
            }
        }
    }

    public String peekValueAt(int row, int col) {
        HSSFRow hssfRow;
        if (this.currentWorksheet != null && row >= 0 && row < this.currentWorksheet.getLastRowNum() && (hssfRow = this.currentWorksheet.getRow(row)) != null && col >= 0 && col < hssfRow.getLastCellNum()) {
            return hssfRow.getCell(col).getStringCellValue();
        }
        return null;
    }

    private List<MergedCellRange> getMergedCellRangeList(HSSFSheet worksheet) {
        ArrayList<MergedCellRange> mergedCellRanges = new ArrayList<MergedCellRange>();
        int mergedRegionsCount = worksheet.getNumMergedRegions();
        for (int ctr = 0; ctr < mergedRegionsCount; ++ctr) {
            CellRangeAddress rangeAddress = worksheet.getMergedRegion(ctr);
            mergedCellRanges.add(new MergedCellRange(rangeAddress.getFirstRow(), rangeAddress.getFirstColumn(), rangeAddress.getLastRow(), rangeAddress.getLastColumn()));
        }
        return mergedCellRanges;
    }
}

