/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.drools.persistence.TransactionManager;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(JPAAuditLogService.class);
    private Environment env;
    private EntityManagerFactory emf;
    private String persistenceUnitName = "org.jbpm.persistence.jpa";

    public JPAAuditLogService() {
    }

    public JPAAuditLogService(Environment env) {
        this.env = env;
    }

    public JPAAuditLogService(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
        if (this.emf != null) {
            this.emf.close();
        }
        this.emf = null;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog").getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        try {
            ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
            return processInstanceLog;
        }
        catch (NoResultException e) {
            ProcessInstanceLog processInstanceLog = null;
            return processInstanceLog;
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    @Override
    public List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.parentProcessInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByName(String variableId, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND p.end is null ORDER BY v.date");
        List result = query.setParameter("variableId", (Object)variableId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByNameAndValue(String variableId, String value, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value = :value ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND v.value = :value AND p.end is null ORDER BY v.date");
        List result = query.setParameter("variableId", (Object)variableId).setParameter("value", (Object)value).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public void clear() {
        EntityManager em = this.getEntityManager();
        boolean newTx = this.joinTransaction(em);
        List processInstances = em.createQuery("FROM ProcessInstanceLog").getResultList();
        for (ProcessInstanceLog processInstance : processInstances) {
            em.remove((Object)processInstance);
        }
        List nodeInstances = em.createQuery("FROM NodeInstanceLog").getResultList();
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            em.remove((Object)nodeInstance);
        }
        List variableInstances = em.createQuery("FROM VariableInstanceLog").getResultList();
        for (VariableInstanceLog variableInstance : variableInstances) {
            em.remove((Object)variableInstance);
        }
        this.closeEntityManager(em, newTx);
    }

    @Override
    public void dispose() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    protected void finalize() throws Throwable {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    private boolean joinTransaction(EntityManager em) {
        Object txmObj;
        Boolean bool;
        boolean isJTA = true;
        if (this.env != null && (bool = (Boolean)this.env.get("IS_JTA_TRANSACTION")) != null) {
            isJTA = bool;
        }
        boolean newTx = false;
        TransactionManager transactionManager = null;
        if (this.env != null && (txmObj = this.env.get("org.kie.transaction.TransactionManager")) instanceof TransactionManager) {
            transactionManager = (TransactionManager)txmObj;
        }
        if (transactionManager != null) {
            newTx = transactionManager.begin();
        } else {
            UserTransaction ut = null;
            try {
                ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (ut.getStatus() == 6) {
                    ut.begin();
                    newTx = true;
                }
            }
            catch (Exception e) {
                logger.error("Unable to find or open a transaction: " + e.getMessage(), (Throwable)e);
            }
        }
        if (isJTA) {
            em.joinTransaction();
        }
        return newTx;
    }

    private void closeEntityManager(EntityManager em, boolean newTx) {
        Boolean bool;
        boolean sharedEM = false;
        if (this.env != null && (bool = (Boolean)this.env.get("IS_SHARED_ENTITY_MANAGER")) != null) {
            sharedEM = bool;
        }
        if (!sharedEM) {
            Object txmObj;
            em.flush();
            em.clear();
            em.close();
            TransactionManager transactionManager = null;
            if (this.env != null && (txmObj = this.env.get("org.kie.transaction.TransactionManager")) instanceof TransactionManager) {
                transactionManager = (TransactionManager)txmObj;
            }
            if (transactionManager != null) {
                transactionManager.commit(newTx);
            } else if (newTx) {
                try {
                    UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    ut.commit();
                }
                catch (Exception e) {
                    logger.error("Unable to commit transaction: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private EntityManager getEntityManager() {
        EntityManager em = null;
        if (this.env == null) {
            if (this.emf == null) {
                try {
                    this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate " + this.emf.getClass().getSimpleName() + " for the '" + this.persistenceUnitName + "' persistence unit. Consider using " + this.getClass().getSimpleName() + ".setEnvironment(env)", e);
                }
            }
            em = this.emf.createEntityManager();
        } else {
            boolean sharedEM = false;
            Boolean bool = (Boolean)this.env.get("IS_SHARED_ENTITY_MANAGER");
            if (bool != null) {
                sharedEM = bool;
            }
            if (sharedEM) {
                em = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            } else {
                EntityManagerFactory emf = (EntityManagerFactory)this.env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
                em = emf.createEntityManager();
            }
        }
        return em;
    }
}

