/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.metadata.backend.lucene.FieldFactory;
import org.uberfire.metadata.backend.lucene.LuceneSetup;
import org.uberfire.metadata.engine.MetaIndexEngine;
import org.uberfire.metadata.engine.MetaModelStore;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;
import org.uberfire.metadata.model.KProperty;
import org.uberfire.metadata.model.schema.MetaObject;
import org.uberfire.metadata.model.schema.MetaProperty;
import org.uberfire.metadata.model.schema.MetaType;

public class LuceneIndexEngine
implements MetaIndexEngine {
    private final LuceneSetup lucene;
    private final FieldFactory fieldFactory;
    private final MetaModelStore metaModelStore;
    private int batchMode = 0;

    public LuceneIndexEngine(MetaModelStore metaModelStore, LuceneSetup lucene, FieldFactory fieldFactory) {
        this.metaModelStore = (MetaModelStore)Preconditions.checkNotNull((String)"metaModelStore", (Object)metaModelStore);
        this.lucene = (LuceneSetup)Preconditions.checkNotNull((String)"lucene", (Object)lucene);
        this.fieldFactory = (FieldFactory)Preconditions.checkNotNull((String)"fieldFactory", (Object)fieldFactory);
    }

    public boolean freshIndex() {
        return this.lucene.freshIndex();
    }

    public synchronized void startBatchMode() {
        this.batchMode = this.batchMode < 0 ? 1 : ++this.batchMode;
    }

    public void index(KObject object) {
        this.updateMetaModel(object);
        this.lucene.indexDocument(object.getId(), this.newDocument(object));
        this.commitIfNotBatchMode();
    }

    private Document newDocument(KObject object) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", object.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("type", object.getType().getName(), Field.Store.YES));
        doc.add((IndexableField)new TextField("key", object.getKey(), Field.Store.YES));
        doc.add((IndexableField)new StringField("cluster.id", object.getClusterId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("segment.id", object.getSegmentId(), Field.Store.YES));
        StringBuilder allText = new StringBuilder(object.getKey()).append('\n');
        for (KProperty property : object.getProperties()) {
            IndexableField[] fields;
            for (IndexableField field : fields = this.fieldFactory.build(property)) {
                doc.add(field);
                if (!(field instanceof TextField) || property.getValue() instanceof Boolean) continue;
                allText.append(field.stringValue()).append('\n');
            }
        }
        doc.add((IndexableField)new TextField("fullText", allText.toString().toLowerCase(), Field.Store.NO));
        return doc;
    }

    public void index(KObject ... objects) {
        for (KObject object : objects) {
            this.index(object);
        }
    }

    public void rename(KObjectKey from, KObjectKey to) {
        this.lucene.rename(from.getId(), to.getId());
        this.commitIfNotBatchMode();
    }

    public void delete(KObjectKey objectKey) {
        this.lucene.deleteIfExists(objectKey.getId());
    }

    public void delete(KObjectKey ... objectsKey) {
        String[] ids = new String[objectsKey.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = objectsKey[i].getId();
        }
        this.lucene.deleteIfExists(ids);
    }

    private synchronized void commitIfNotBatchMode() {
        if (this.batchMode <= 0) {
            this.commit();
        }
    }

    public synchronized void commit() {
        --this.batchMode;
        if (this.batchMode <= 0) {
            this.lucene.commit();
        }
    }

    public void dispose() {
        this.metaModelStore.dispose();
        this.lucene.dispose();
    }

    private void updateMetaModel(KObject object) {
        MetaObject metaObject = this.metaModelStore.getMetaObject(object.getType().getName());
        if (metaObject == null) {
            this.metaModelStore.add(this.newMetaObect(object));
        } else {
            for (KProperty property : object.getProperties()) {
                MetaProperty metaProperty = metaObject.getProperty(property.getName());
                if (metaProperty == null) {
                    metaObject.addProperty(this.newMetaProperty(property));
                    continue;
                }
                metaProperty.addType(property.getValue().getClass());
                if (!property.isSearchable()) continue;
                metaProperty.setAsSearchable();
            }
            this.metaModelStore.update(metaObject);
        }
    }

    private MetaObject newMetaObect(final KObject object) {
        final HashSet<MetaProperty> properties = new HashSet<MetaProperty>();
        for (KProperty property : object.getProperties()) {
            properties.add(this.newMetaProperty(property));
        }
        return new MetaObject(){
            private final Map<String, MetaProperty> propertyMap = new ConcurrentHashMap<String, MetaProperty>(){
                {
                    for (MetaProperty property : properties) {
                        this.put(property.getName(), property);
                    }
                }
            };

            public MetaType getType() {
                return object.getType();
            }

            public Collection<MetaProperty> getProperties() {
                return this.propertyMap.values();
            }

            public MetaProperty getProperty(String name) {
                return this.propertyMap.get(name);
            }

            public void addProperty(MetaProperty metaProperty) {
                if (!this.propertyMap.containsKey(metaProperty.getName())) {
                    this.propertyMap.put(metaProperty.getName(), metaProperty);
                }
            }
        };
    }

    private MetaProperty newMetaProperty(final KProperty<?> property) {
        return new MetaProperty(){
            private boolean isSearchable;
            private Set<Class<?>> types;
            {
                this.isSearchable = property.isSearchable();
                this.types = new CopyOnWriteArraySet<Class<?>>(){
                    {
                        this.add(property.getValue().getClass());
                    }
                };
            }

            public String getName() {
                return property.getName();
            }

            public Set<Class<?>> getTypes() {
                return this.types;
            }

            public boolean isSearchable() {
                return this.isSearchable;
            }

            public void setAsSearchable() {
                this.isSearchable = true;
            }

            public void addType(Class<?> type) {
                this.types.add(type);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof MetaProperty)) {
                    return false;
                }
                return ((MetaProperty)obj).getName().equals(this.getName());
            }

            public int hashCode() {
                return this.getName().hashCode();
            }
        };
    }
}

