/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Date;
import java.util.Map;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ValueType;
import org.drools.core.base.extractors.BaseBooleanClassFieldReader;
import org.drools.core.base.extractors.BaseBooleanClassFieldWriter;
import org.drools.core.base.extractors.BaseByteClassFieldReader;
import org.drools.core.base.extractors.BaseByteClassFieldWriter;
import org.drools.core.base.extractors.BaseCharClassFieldReader;
import org.drools.core.base.extractors.BaseCharClassFieldWriter;
import org.drools.core.base.extractors.BaseDateClassFieldReader;
import org.drools.core.base.extractors.BaseDoubleClassFieldReader;
import org.drools.core.base.extractors.BaseDoubleClassFieldWriter;
import org.drools.core.base.extractors.BaseFloatClassFieldReader;
import org.drools.core.base.extractors.BaseFloatClassFieldWriter;
import org.drools.core.base.extractors.BaseIntClassFieldReader;
import org.drools.core.base.extractors.BaseIntClassFieldWriter;
import org.drools.core.base.extractors.BaseLongClassFieldReader;
import org.drools.core.base.extractors.BaseLongClassFieldWriter;
import org.drools.core.base.extractors.BaseNumberClassFieldReader;
import org.drools.core.base.extractors.BaseObjectClassFieldReader;
import org.drools.core.base.extractors.BaseObjectClassFieldWriter;
import org.drools.core.base.extractors.BaseShortClassFieldReader;
import org.drools.core.base.extractors.BaseShortClassFieldWriter;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.util.asm.ClassFieldInspector;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class ClassFieldAccessorFactory {
    private static final String BASE_PACKAGE = "org/drools/base";
    private static final String SELF_REFERENCE_FIELD = "this";
    private static final ProtectionDomain PROTECTION_DOMAIN = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return ClassFieldAccessorFactory.class.getProtectionDomain();
        }
    });
    private static ClassFieldAccessorFactory instance = new ClassFieldAccessorFactory();

    public static ClassFieldAccessorFactory getInstance() {
        return instance;
    }

    public BaseClassFieldReader getClassFieldReader(Class<?> clazz, String fieldName, ClassFieldAccessorCache.CacheEntry cache) {
        ClassFieldAccessorCache.ByteArrayClassLoader byteArrayClassLoader = cache.getByteArrayClassLoader();
        Map<Class<?>, ClassFieldInspector> inspectors = cache.getInspectors();
        try {
            if (SELF_REFERENCE_FIELD.equals(fieldName)) {
                return new SelfReferenceClassFieldReader(clazz, fieldName);
            }
            ClassFieldInspector inspector = inspectors.get(clazz);
            if (inspector == null) {
                inspector = new ClassFieldInspector(clazz);
                inspectors.put(clazz, inspector);
            }
            Class<?> fieldType = inspector.getFieldTypes().get(fieldName);
            Method getterMethod = inspector.getGetterMethods().get(fieldName);
            Integer index = inspector.getFieldNames().get(fieldName);
            if (fieldType == null && fieldName.length() > 1 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
                String altFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                fieldType = inspector.getFieldTypes().get(altFieldName);
                if (fieldType != null) {
                    getterMethod = inspector.getGetterMethods().get(altFieldName);
                    index = inspector.getFieldNames().get(altFieldName);
                }
            }
            if (fieldType != null && getterMethod != null) {
                String className = "org/drools/base/" + Type.getInternalName(clazz) + Math.abs(System.identityHashCode(clazz)) + "$" + getterMethod.getName();
                byte[] bytes = this.dumpReader(clazz, className, getterMethod, fieldType, clazz.isInterface());
                Class<?> newClass = byteArrayClassLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
                ValueType valueType = ValueType.determineValueType(fieldType);
                Object[] params = new Object[]{index, fieldType, valueType};
                return (BaseClassFieldReader)newClass.getConstructors()[0].newInstance(params);
            }
            if (fieldType != null) {
                return null;
            }
            throw new RuntimeDroolsException("Field/method '" + fieldName + "' not found for class '" + clazz.getName() + "'\n");
        }
        catch (RuntimeDroolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public BaseClassFieldWriter getClassFieldWriter(Class<?> clazz, String fieldName, ClassFieldAccessorCache.CacheEntry cache) {
        ClassFieldAccessorCache.ByteArrayClassLoader byteArrayClassLoader = cache.getByteArrayClassLoader();
        Map<Class<?>, ClassFieldInspector> inspectors = cache.getInspectors();
        try {
            ClassFieldInspector inspector = inspectors.get(clazz);
            if (inspector == null) {
                inspector = new ClassFieldInspector(clazz);
                inspectors.put(clazz, inspector);
            }
            Method setterMethod = inspector.getSetterMethods().get(fieldName);
            Integer index = inspector.getFieldNames().get(fieldName);
            if (setterMethod == null && fieldName.length() > 1 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
                String altFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                setterMethod = inspector.getSetterMethods().get(altFieldName);
                index = inspector.getFieldNames().get(altFieldName);
            }
            if (setterMethod != null) {
                Class<?> fieldType = setterMethod.getParameterTypes()[0];
                String className = "org/drools/base/" + Type.getInternalName(clazz) + Math.abs(System.identityHashCode(clazz)) + "$" + setterMethod.getName();
                byte[] bytes = this.dumpWriter(clazz, className, setterMethod, fieldType, clazz.isInterface());
                Class<?> newClass = byteArrayClassLoader.defineClass(className.replace('/', '.'), bytes, PROTECTION_DOMAIN);
                ValueType valueType = ValueType.determineValueType(fieldType);
                Object[] params = new Object[]{index, fieldType, valueType};
                return (BaseClassFieldWriter)newClass.getConstructors()[0].newInstance(params);
            }
            if (inspector.getFieldNames().containsKey(fieldName)) {
                if (inspector.getGetterMethods().get(fieldName) != null) {
                    return null;
                }
                return null;
            }
            throw new RuntimeDroolsException("Field/method '" + fieldName + "' not found for class '" + clazz.getName() + "'");
        }
        catch (RuntimeDroolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    private byte[] dumpReader(Class<?> originalClass, String className, Method getterMethod, Class<?> fieldType, boolean isInterface) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> superClass = this.getReaderSuperClassFor(fieldType);
        this.buildClassHeader(superClass, className, cw);
        this.build3ArgConstructor(superClass, className, cw);
        this.buildGetMethod(originalClass, className, superClass, getterMethod, cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private byte[] dumpWriter(Class<?> originalClass, String className, Method getterMethod, Class<?> fieldType, boolean isInterface) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class<?> superClass = this.getWriterSuperClassFor(fieldType);
        this.buildClassHeader(superClass, className, cw);
        this.build3ArgConstructor(superClass, className, cw);
        this.buildSetMethod(originalClass, className, superClass, getterMethod, fieldType, cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void buildClassHeader(Class<?> superClass, String className, ClassWriter cw) {
        cw.visit(50, 33, className, null, Type.getInternalName(superClass), null);
        cw.visitSource(null, null);
    }

    private void build3ArgConstructor(Class<?> superClazz, String className, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(superClazz), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Integer.TYPE), Type.getType(Class.class), Type.getType(ValueType.class)}));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l2, 0);
        mv.visitLocalVariable("index", Type.getDescriptor(Integer.TYPE), null, l0, l2, 1);
        mv.visitLocalVariable("fieldType", Type.getDescriptor(Class.class), null, l0, l2, 2);
        mv.visitLocalVariable("valueType", Type.getDescriptor(ValueType.class), null, l0, l2, 3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildGetMethod(Class<?> originalClass, String className, Class<?> superClass, Method getterMethod, ClassWriter cw) {
        Method overridingMethod;
        Class<?> fieldType = getterMethod.getReturnType();
        try {
            overridingMethod = superClass.getMethod(this.getOverridingGetMethodName(fieldType), InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report back to JBoss Rules team.", e);
        }
        MethodVisitor mv = cw.visitMethod(1, overridingMethod.getName(), Type.getMethodDescriptor((Method)overridingMethod), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, Type.getInternalName(originalClass));
        if (originalClass.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor((Method)getterMethod));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(originalClass), getterMethod.getName(), Type.getMethodDescriptor((Method)getterMethod));
        }
        mv.visitInsn(Type.getType(fieldType).getOpcode(172));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("workingMemory", Type.getDescriptor(InternalWorkingMemory.class), null, l0, l1, 1);
        mv.visitLocalVariable("object", Type.getDescriptor(Object.class), null, l0, l1, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSetMethod(Class<?> originalClass, String className, Class<?> superClass, Method setterMethod, Class<?> fieldType, ClassWriter cw) {
        Method overridingMethod;
        try {
            overridingMethod = superClass.getMethod(this.getOverridingSetMethodName(fieldType), Object.class, fieldType.isPrimitive() ? fieldType : Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report back to JBoss Rules team.", e);
        }
        MethodVisitor mv = cw.visitMethod(1, overridingMethod.getName(), Type.getMethodDescriptor((Method)overridingMethod), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(originalClass));
        mv.visitVarInsn(Type.getType(fieldType).getOpcode(21), 2);
        if (!fieldType.isPrimitive()) {
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
        }
        if (originalClass.isInterface()) {
            mv.visitMethodInsn(185, Type.getInternalName(originalClass), setterMethod.getName(), Type.getMethodDescriptor((Method)setterMethod));
        } else {
            mv.visitMethodInsn(182, Type.getInternalName(originalClass), setterMethod.getName(), Type.getMethodDescriptor((Method)setterMethod));
        }
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable(SELF_REFERENCE_FIELD, "L" + className + ";", null, l0, l1, 0);
        mv.visitLocalVariable("bean", Type.getDescriptor(Object.class), null, l0, l1, 1);
        mv.visitLocalVariable("value", Type.getDescriptor(fieldType), null, l0, l1, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String getOverridingGetMethodName(Class<?> fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = "getCharValue";
            } else if (fieldType == Byte.TYPE) {
                ret = "getByteValue";
            } else if (fieldType == Short.TYPE) {
                ret = "getShortValue";
            } else if (fieldType == Integer.TYPE) {
                ret = "getIntValue";
            } else if (fieldType == Long.TYPE) {
                ret = "getLongValue";
            } else if (fieldType == Float.TYPE) {
                ret = "getFloatValue";
            } else if (fieldType == Double.TYPE) {
                ret = "getDoubleValue";
            } else if (fieldType == Boolean.TYPE) {
                ret = "getBooleanValue";
            }
        } else {
            ret = "getValue";
        }
        return ret;
    }

    private String getOverridingSetMethodName(Class<?> fieldType) {
        String ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = "setCharValue";
            } else if (fieldType == Byte.TYPE) {
                ret = "setByteValue";
            } else if (fieldType == Short.TYPE) {
                ret = "setShortValue";
            } else if (fieldType == Integer.TYPE) {
                ret = "setIntValue";
            } else if (fieldType == Long.TYPE) {
                ret = "setLongValue";
            } else if (fieldType == Float.TYPE) {
                ret = "setFloatValue";
            } else if (fieldType == Double.TYPE) {
                ret = "setDoubleValue";
            } else if (fieldType == Boolean.TYPE) {
                ret = "setBooleanValue";
            }
        } else {
            ret = "setValue";
        }
        return ret;
    }

    private Class<?> getReaderSuperClassFor(Class<?> fieldType) {
        Class ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = BaseCharClassFieldReader.class;
            } else if (fieldType == Byte.TYPE) {
                ret = BaseByteClassFieldReader.class;
            } else if (fieldType == Short.TYPE) {
                ret = BaseShortClassFieldReader.class;
            } else if (fieldType == Integer.TYPE) {
                ret = BaseIntClassFieldReader.class;
            } else if (fieldType == Long.TYPE) {
                ret = BaseLongClassFieldReader.class;
            } else if (fieldType == Float.TYPE) {
                ret = BaseFloatClassFieldReader.class;
            } else if (fieldType == Double.TYPE) {
                ret = BaseDoubleClassFieldReader.class;
            } else if (fieldType == Boolean.TYPE) {
                ret = BaseBooleanClassFieldReader.class;
            }
        } else {
            ret = Number.class.isAssignableFrom(fieldType) ? BaseNumberClassFieldReader.class : (Date.class.isAssignableFrom(fieldType) ? BaseDateClassFieldReader.class : BaseObjectClassFieldReader.class);
        }
        return ret;
    }

    private Class<?> getWriterSuperClassFor(Class<?> fieldType) {
        Class ret = null;
        if (fieldType.isPrimitive()) {
            if (fieldType == Character.TYPE) {
                ret = BaseCharClassFieldWriter.class;
            } else if (fieldType == Byte.TYPE) {
                ret = BaseByteClassFieldWriter.class;
            } else if (fieldType == Short.TYPE) {
                ret = BaseShortClassFieldWriter.class;
            } else if (fieldType == Integer.TYPE) {
                ret = BaseIntClassFieldWriter.class;
            } else if (fieldType == Long.TYPE) {
                ret = BaseLongClassFieldWriter.class;
            } else if (fieldType == Float.TYPE) {
                ret = BaseFloatClassFieldWriter.class;
            } else if (fieldType == Double.TYPE) {
                ret = BaseDoubleClassFieldWriter.class;
            } else if (fieldType == Boolean.TYPE) {
                ret = BaseBooleanClassFieldWriter.class;
            }
        } else {
            ret = BaseObjectClassFieldWriter.class;
        }
        return ret;
    }
}

