/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.internal.executor.api.ExecutorService;

public class ExecutorServiceFactory {
    public static ExecutorService newExecutorService(EntityManagerFactory emf) {
        return ExecutorServiceFactory.configure(emf);
    }

    private static ExecutorService configure(EntityManagerFactory emf) {
        ExecutorServiceImpl service = new ExecutorServiceImpl();
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl();
        ExecutorImpl executor = new ExecutorImpl();
        ExecutorRunnable runnable = new ExecutorRunnable();
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        ClassCacheManager classCacheManager = new ClassCacheManager();
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        queryService.setCommandService(commandService);
        executor.setCommandService(commandService);
        adminService.setCommandService(commandService);
        runnable.setCommandService(commandService);
        service.setQueryService(queryService);
        service.setExecutor(executor);
        service.setAdminService(adminService);
        runnable.setClassCacheManager(classCacheManager);
        runnable.setQueryService(queryService);
        executor.setExecutorRunnable(runnable);
        executor.setQueryService(queryService);
        return service;
    }
}

