/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.shared.services.cdi.BootOnLoad;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.Executor;
import org.kie.internal.executor.api.ExecutorAdminService;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;

@BootOnLoad
@ApplicationScoped
public class ExecutorServiceImpl
implements ExecutorService {
    @Inject
    private Executor executor;
    private boolean executorStarted = false;
    @Inject
    private ExecutorQueryService queryService;
    @Inject
    private ExecutorAdminService adminService;

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public ExecutorQueryService getQueryService() {
        return this.queryService;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public ExecutorAdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(ExecutorAdminService adminService) {
        this.adminService = adminService;
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return this.queryService.getFutureQueuedRequests();
    }

    public List<RequestInfo> getQueuedRequests() {
        return this.queryService.getQueuedRequests();
    }

    public List<RequestInfo> getCompletedRequests() {
        return this.queryService.getCompletedRequests();
    }

    public List<RequestInfo> getInErrorRequests() {
        return this.queryService.getInErrorRequests();
    }

    public List<RequestInfo> getCancelledRequests() {
        return this.queryService.getCancelledRequests();
    }

    public List<ErrorInfo> getAllErrors() {
        return this.queryService.getAllErrors();
    }

    public List<RequestInfo> getAllRequests() {
        return this.queryService.getAllRequests();
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return this.queryService.getRequestsByStatus(statuses);
    }

    public int clearAllRequests() {
        return this.adminService.clearAllRequests();
    }

    public int clearAllErrors() {
        return this.adminService.clearAllErrors();
    }

    public Long scheduleRequest(String commandName, CommandContext ctx) {
        return this.executor.scheduleRequest(commandName, ctx);
    }

    public void cancelRequest(Long requestId) {
        this.executor.cancelRequest(requestId);
    }

    @PostConstruct
    public void init() {
        this.executor.init();
        this.executorStarted = true;
    }

    @PreDestroy
    public void destroy() {
        this.executorStarted = false;
        this.executor.destroy();
    }

    public boolean isActive() {
        return this.executorStarted;
    }

    public int getInterval() {
        return this.executor.getInterval();
    }

    public void setInterval(int waitTime) {
        this.executor.setInterval(waitTime);
    }

    public int getRetries() {
        return this.executor.getRetries();
    }

    public void setRetries(int defaultNroOfRetries) {
        this.executor.setRetries(defaultNroOfRetries);
    }

    public int getThreadPoolSize() {
        return this.executor.getThreadPoolSize();
    }

    public void setThreadPoolSize(int nroOfThreads) {
        this.executor.setThreadPoolSize(nroOfThreads);
    }

    public List<RequestInfo> getPendingRequests() {
        return this.queryService.getPendingRequests();
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        return this.queryService.getPendingRequestById(id);
    }

    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        return this.executor.scheduleRequest(commandId, date, ctx);
    }

    public List<RequestInfo> getRunningRequests() {
        return this.queryService.getRunningRequests();
    }

    public RequestInfo getRequestById(Long requestId) {
        return this.queryService.getRequestById(requestId);
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        return this.queryService.getErrorsByRequestId(requestId);
    }

    public List<RequestInfo> getRequestsByBusinessKey(String businessKey) {
        return this.queryService.getRequestByBusinessKey(businessKey);
    }
}

