/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentSkipListSet;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Function;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Package;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.Query;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.Wireable;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.KeyStoreHelper;
import org.drools.core.util.StringUtils;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.kie.internal.utils.FastClassLoader;

public class JavaDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final long serialVersionUID = 510L;
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JavaDialectRuntimeData.class.getProtectionDomain();
        }
    });
    private Map<String, Object> invokerLookups;
    private Map<String, byte[]> classLookups;
    private Map<String, byte[]> store;
    private transient PackageClassLoader classLoader;
    private transient ClassLoader rootClassLoader;
    private boolean dirty = false;
    private List<String> wireList = Collections.emptyList();

    public JavaDialectRuntimeData() {
        this.invokerLookups = new HashMap<String, Object>();
        this.classLookups = new HashMap<String, byte[]>();
        this.store = new HashMap<String, byte[]>();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        KeyStoreHelper helper = new KeyStoreHelper();
        stream.writeBoolean(helper.isSigned());
        if (helper.isSigned()) {
            stream.writeObject(helper.getPvtKeyAlias());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeInt(this.store.size());
        Iterator<Map.Entry<String, byte[]>> i$ = this.store.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, byte[]> stringEntry;
            Map.Entry<String, byte[]> entry = stringEntry = i$.next();
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.flush();
        out.close();
        byte[] buff = bos.toByteArray();
        stream.writeObject(buff);
        if (helper.isSigned()) {
            this.sign(stream, helper, buff);
        }
        stream.writeInt(this.invokerLookups.size());
        Iterator<Map.Entry<String, Object>> i$2 = this.invokerLookups.entrySet().iterator();
        while (i$2.hasNext()) {
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = i$2.next();
            stream.writeObject(entry2.getKey());
            stream.writeObject(entry2.getValue());
        }
        stream.writeInt(this.classLookups.size());
        for (Map.Entry<String, Object> entry : this.classLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private void sign(ObjectOutput stream, KeyStoreHelper helper, byte[] buff) {
        try {
            stream.writeObject(helper.signDataWithPrivateKey(buff));
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Error signing object store: " + e.getMessage(), e);
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i;
        KeyStoreHelper helper = new KeyStoreHelper();
        boolean signed = stream.readBoolean();
        if (helper.isSigned() != signed) {
            throw new RuntimeDroolsException("This environment is configured to work with " + (helper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (signed ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        String pubKeyAlias = null;
        if (signed) {
            pubKeyAlias = (String)stream.readObject();
            if (helper.getPubKeyStore() == null) {
                throw new RuntimeDroolsException("The package was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
        }
        byte[] bytes = (byte[])stream.readObject();
        if (signed) {
            this.checkSignature(stream, helper, bytes, pubKeyAlias);
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        int length = in.readInt();
        for (i = 0; i < length; ++i) {
            this.store.put((String)in.readObject(), (byte[])in.readObject());
        }
        in.close();
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.invokerLookups.put((String)stream.readObject(), stream.readObject());
        }
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.classLookups.put((String)stream.readObject(), (byte[])stream.readObject());
        }
        this.dirty = true;
    }

    private void checkSignature(ObjectInput stream, KeyStoreHelper helper, byte[] bytes, String pubKeyAlias) throws ClassNotFoundException, IOException {
        byte[] signature = (byte[])stream.readObject();
        try {
            if (!helper.checkDataWithPublicKey(pubKeyAlias, bytes, signature)) {
                throw new RuntimeDroolsException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeDroolsException("Invalid key checking signature: " + e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeDroolsException("Error accessing Key Store: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeDroolsException("No algorithm available: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new RuntimeDroolsException("Signature Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public void onAdd(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void onBeforeExecute() {
        if (this.isDirty()) {
            this.reload();
        } else if (!this.wireList.isEmpty()) {
            try {
                int wireListSize = this.wireList.size();
                if (wireListSize < 100) {
                    JavaDialectRuntimeData.wireAll(this.classLoader, this.getInvokers(), this.wireList);
                } else {
                    this.wireInParallel(wireListSize);
                }
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Unable to wire up JavaDialect", e);
            }
        }
        this.wireList.clear();
    }

    private void wireInParallel(int wireListSize) throws Exception {
        int i;
        int parallelThread = Runtime.getRuntime().availableProcessors();
        CompletionService ecs = ExecutorProviderFactory.getExecutorProvider().getCompletionService();
        int size = wireListSize / parallelThread;
        for (i = 1; i <= parallelThread; ++i) {
            List<String> subList = this.wireList.subList((i - 1) * size, i == parallelThread ? wireListSize : i * size);
            ecs.submit(new WiringExecutor(this.classLoader, this.getInvokers(), subList));
        }
        for (i = 1; i <= parallelThread; ++i) {
            ecs.take().get();
        }
    }

    private static void wireAll(PackageClassLoader classLoader, Map<String, Object> invokerLookups, List<String> wireList) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (String resourceName : wireList) {
            JavaDialectRuntimeData.wire(classLoader, invokerLookups, ClassUtils.convertResourceToClassName(resourceName));
        }
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        return this.clone(registry, rootClassLoader, false);
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader, boolean excludeClasses) {
        JavaDialectRuntimeData cloneOne = new JavaDialectRuntimeData();
        cloneOne.merge(registry, this, excludeClasses);
        cloneOne.onAdd(registry, rootClassLoader);
        return cloneOne;
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.merge(registry, newData, false);
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData, boolean excludeClasses) {
        JavaDialectRuntimeData newJavaData = (JavaDialectRuntimeData)newData;
        for (String resourceName : newJavaData.list()) {
            if (excludeClasses && newJavaData.getClassDefinitions().containsKey(resourceName)) continue;
            this.write(resourceName, newJavaData.read(resourceName));
        }
        this.putAllInvokers(newJavaData.getInvokers());
        if (!excludeClasses) {
            this.putAllClassDefinitions(newJavaData.getClassDefinitions());
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Map<String, byte[]> getStore() {
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        return this.store;
    }

    public byte[] getBytecode(String resourceName) {
        byte[] bytecode = null;
        if (this.store != null) {
            bytecode = this.store.get(resourceName);
        }
        if (bytecode == null && this.rootClassLoader instanceof ProjectClassLoader) {
            bytecode = ((ProjectClassLoader)this.rootClassLoader).getBytecode(resourceName);
            this.store.put(resourceName, bytecode);
        }
        return bytecode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void removeRule(Package pkg, Rule rule) {
        String consequenceName;
        if (!(rule instanceof Query) && this.remove(consequenceName = rule.getConsequence().getClass().getName())) {
            this.removeClasses(rule.getLhs());
            String sufix = StringUtils.ucFirst(rule.getConsequence().getName()) + "ConsequenceInvoker";
            this.remove(consequenceName.substring(0, consequenceName.indexOf(sufix)));
        }
    }

    @Override
    public void removeFunction(Package pkg, Function function) {
        this.remove(pkg.getName() + "." + StringUtils.ucFirst(function.getName()));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            for (RuleConditionElement object : group.getChildren()) {
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        for (Constraint object : pattern.getConstraints()) {
            if (!(object instanceof PredicateConstraint)) continue;
            this.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
        }
    }

    public byte[] read(String resourceName) {
        byte[] bytes = null;
        if (!this.getStore().isEmpty()) {
            bytes = this.getStore().get(resourceName);
        }
        return bytes;
    }

    public void write(String resourceName, byte[] clazzData) throws RuntimeDroolsException {
        if (this.getStore().put(resourceName, clazzData) != null) {
            this.dirty = true;
            if (!this.wireList.isEmpty()) {
                this.wireList.clear();
            }
        } else if (!this.dirty) {
            try {
                if (this.wireList == Collections.emptyList()) {
                    this.wireList = new ArrayList<String>();
                }
                this.wireList.add(resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeDroolsException(e);
            }
        }
    }

    public void wire(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.wire(className, this.getInvokers().get(className));
    }

    private static void wire(PackageClassLoader classLoader, Map<String, Object> invokerLookups, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        JavaDialectRuntimeData.wire(classLoader, className, invokerLookups.get(className));
    }

    public void wire(String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        JavaDialectRuntimeData.wire(this.classLoader, className, invoker);
    }

    private static void wire(PackageClassLoader classLoader, String className, Object invoker) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = classLoader.loadClass(className);
        if (clazz != null) {
            if (invoker instanceof Wireable) {
                ((Wireable)invoker).wire(clazz.newInstance());
            }
        } else {
            throw new ClassNotFoundException(className);
        }
    }

    public boolean remove(String resourceName) throws RuntimeDroolsException {
        this.getInvokers().remove(resourceName);
        if (this.getStore().remove(ClassUtils.convertClassToResourcePath(resourceName)) != null) {
            this.wireList.remove(resourceName);
            this.dirty = true;
            return true;
        }
        return false;
    }

    public String[] list() {
        String[] names = new String[this.getStore().size()];
        int i = 0;
        for (String string : this.getStore().keySet()) {
            names[i++] = string;
        }
        return names;
    }

    @Override
    public void reload() throws RuntimeDroolsException {
        this.classLoader = new PackageClassLoader(this, this.rootClassLoader);
        try {
            Iterator<Map.Entry<String, Object>> i$ = this.getInvokers().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Object> object;
                Map.Entry<String, Object> entry = object = i$.next();
                this.wire(entry.getKey(), entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeDroolsException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException(e);
        }
        this.dirty = false;
    }

    public void clear() {
        this.getStore().clear();
        this.getInvokers().clear();
        this.reload();
    }

    public String toString() {
        return this.getClass().getName() + this.getStore().toString();
    }

    public void putInvoker(String className, Object invoker) {
        this.getInvokers().put(className, invoker);
    }

    public void putAllInvokers(Map<String, Object> invokers) {
        this.getInvokers().putAll(invokers);
    }

    public Map<String, Object> getInvokers() {
        if (this.invokerLookups == null) {
            this.invokerLookups = new HashMap<String, Object>();
        }
        return this.invokerLookups;
    }

    public void removeInvoker(String className) {
        this.getInvokers().remove(className);
    }

    public void putClassDefinition(String className, byte[] classDef) {
        this.getClassDefinitions().put(className, classDef);
    }

    public void putAllClassDefinitions(Map classDefinitions) {
        this.getClassDefinitions().putAll(classDefinitions);
    }

    public Map<String, byte[]> getClassDefinitions() {
        if (this.classLookups == null) {
            this.classLookups = new HashMap<String, byte[]>();
        }
        return this.classLookups;
    }

    public byte[] getClassDefinition(String className) {
        byte[] classDef;
        if (this.classLookups == null) {
            this.classLookups = new HashMap<String, byte[]>();
        }
        if ((classDef = this.classLookups.get(className)) == null && this.rootClassLoader instanceof ProjectClassLoader) {
            classDef = ((ProjectClassLoader)this.rootClassLoader).getBytecode(className);
            this.classLookups.put(className, classDef);
        }
        return classDef;
    }

    public void removeClassDefinition(String className) {
        this.getClassDefinitions().remove(className);
    }

    public static class PackageClassLoader
    extends ClassLoader
    implements FastClassLoader {
        protected JavaDialectRuntimeData store;
        private Set<String> existingPackages = new ConcurrentSkipListSet<String>();

        public PackageClassLoader(JavaDialectRuntimeData store, ClassLoader rootClassLoader) {
            super(rootClassLoader);
            this.store = store;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cls = this.fastFindClass(name);
            if (cls == null) {
                ClassLoader parent = this.getParent();
                cls = parent.loadClass(name);
            }
            if (cls == null) {
                throw new ClassNotFoundException("Unable to load class: " + name);
            }
            return cls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> fastFindClass(String name) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                byte[] clazzBytes = this.store.read(ClassUtils.convertClassToResourcePath(name));
                if (clazzBytes != null) {
                    String pkgName = name.substring(0, name.lastIndexOf(46));
                    if (!this.existingPackages.contains(pkgName)) {
                        PackageClassLoader packageClassLoader = this;
                        synchronized (packageClassLoader) {
                            if (this.getPackage(pkgName) == null) {
                                this.definePackage(pkgName, "", "", "", "", "", "", null);
                            }
                            this.existingPackages.add(pkgName);
                        }
                    }
                    cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
                }
                if (cls != null) {
                    this.resolveClass(cls);
                }
            }
            return cls;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            byte[] clsBytes = this.store.read(name);
            if (clsBytes != null) {
                return new ByteArrayInputStream(clsBytes);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public URL nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private static class WiringExecutor
    implements Callable<Boolean> {
        private final PackageClassLoader classLoader;
        private final Map<String, Object> invokerLookups;
        private final List<String> wireList;

        private WiringExecutor(PackageClassLoader classLoader, Map<String, Object> invokerLookups, List<String> wireList) {
            this.classLoader = classLoader;
            this.invokerLookups = invokerLookups;
            this.wireList = wireList;
        }

        @Override
        public Boolean call() throws Exception {
            JavaDialectRuntimeData.wireAll(this.classLoader, this.invokerLookups, this.wireList);
            return true;
        }
    }
}

