/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class ExpressionIntervalTimer
extends BaseTimer
implements Timer,
Externalizable {
    private MVELObjectExpression startTime;
    private MVELObjectExpression endTime;
    private int repeatLimit;
    private MVELObjectExpression delay;
    private MVELObjectExpression period;

    public ExpressionIntervalTimer() {
    }

    public ExpressionIntervalTimer(MVELObjectExpression startTime, MVELObjectExpression endTime, int repeatLimit, MVELObjectExpression delay, MVELObjectExpression period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.delay);
        out.writeObject(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (MVELObjectExpression)in.readObject();
        this.endTime = (MVELObjectExpression)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = (MVELObjectExpression)in.readObject();
        this.period = (MVELObjectExpression)in.readObject();
    }

    public Declaration[] getStartDeclarations() {
        return this.startTime != null ? this.startTime.getMVELCompilationUnit().getPreviousDeclarations() : null;
    }

    public Declaration[] getEndDeclarations() {
        return this.endTime != null ? this.endTime.getMVELCompilationUnit().getPreviousDeclarations() : null;
    }

    public Declaration[] getDelayDeclarations() {
        return this.delay.getMVELCompilationUnit().getPreviousDeclarations();
    }

    public Declaration[] getPeriodDeclarations() {
        return this.period.getMVELCompilationUnit().getPreviousDeclarations();
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{this.sortDeclarations(outerDeclrs, this.getDelayDeclarations()), this.sortDeclarations(outerDeclrs, this.getPeriodDeclarations()), this.sortDeclarations(outerDeclrs, this.getStartDeclarations()), this.sortDeclarations(outerDeclrs, this.getEndDeclarations())};
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        Declaration[][] timerDeclrs = ((AgendaItem)item).getTerminalNode().getTimerDeclarations();
        ScheduledAgendaItem schItem = (ScheduledAgendaItem)item;
        DefaultJobHandle jh = null;
        if (schItem.getJobHandle() != null) {
            jh = (DefaultJobHandle)schItem.getJobHandle();
        }
        return this.createTrigger(timestamp, item.getTuple(), jh, calendarNames, calendars, timerDeclrs, wm);
    }

    @Override
    public Trigger createTrigger(long timestamp, LeftTuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        long newDelay;
        IntervalTrigger preTrig;
        long timeSinceLastFire = 0L;
        Declaration[] delayDeclarations = declrs[0];
        Declaration[] periodDeclarations = declrs[1];
        Declaration[] startDeclarations = declrs[2];
        Declaration[] endDeclarations = declrs[3];
        if (jh != null && (preTrig = (IntervalTrigger)jh.getTimerJobInstance().getTrigger()).getLastFireTime() != null) {
            timeSinceLastFire = timestamp - preTrig.getLastFireTime().getTime();
        }
        if ((newDelay = (this.delay != null ? TimeUtils.evalTimeExpression(this.delay, leftTuple, delayDeclarations, wm) : 0L) - timeSinceLastFire) < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, TimeUtils.evalDateExpression(this.startTime, leftTuple, startDeclarations, wm), TimeUtils.evalDateExpression(this.endTime, leftTuple, startDeclarations, wm), this.repeatLimit, newDelay, this.period != null ? TimeUtils.evalTimeExpression(this.period, leftTuple, periodDeclarations, wm) : 0L, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, null, null, this.repeatLimit, 0L, 0L, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delay.hashCode();
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + this.period.hashCode();
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionIntervalTimer other = (ExpressionIntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new ExpressionIntervalTimer(this.startTime, this.endTime, this.repeatLimit, this.delay, this.period);
    }
}

