/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.healthcheck.HealthStatsAggregator;
import org.apache.log4j.Logger;

public class HealthStatsAggregationTask
extends HelixTimerTask {
    private static final Logger LOG = Logger.getLogger(HealthStatsAggregationTask.class);
    public static final int DEFAULT_HEALTH_CHECK_LATENCY = 30000;
    final HealthStatsAggregator _healthStatsAggregator;
    private Timer _timer;
    private final int _delay;
    private final int _period;

    public HealthStatsAggregationTask(HealthStatsAggregator healthStatsAggregator, int delay, int period) {
        this._healthStatsAggregator = healthStatsAggregator;
        this._delay = delay;
        this._period = period;
    }

    public HealthStatsAggregationTask(HealthStatsAggregator healthStatsAggregator) {
        this(healthStatsAggregator, 30000, 30000);
    }

    @Override
    public void start() {
        if (this._timer == null) {
            LOG.info((Object)"START HealthStatsAggregationTimerTask");
            this._healthStatsAggregator.init();
            this._timer = new Timer("HealthStatsAggregationTimerTask", true);
            this._timer.scheduleAtFixedRate((TimerTask)new HealthStatsAggregationTaskTimer(), new Random().nextInt(this._delay), (long)this._period);
        } else {
            LOG.warn((Object)"HealthStatsAggregationTimerTask already started");
        }
    }

    @Override
    public synchronized void stop() {
        if (this._timer != null) {
            LOG.info((Object)"Stop HealthStatsAggregationTimerTask");
            this._timer.cancel();
            this._healthStatsAggregator.reset();
            this._timer = null;
        } else {
            LOG.warn((Object)"HealthStatsAggregationTimerTask already stopped");
        }
    }

    class HealthStatsAggregationTaskTimer
    extends TimerTask {
        HealthStatsAggregationTaskTimer() {
        }

        @Override
        public void run() {
            HealthStatsAggregationTask.this._healthStatsAggregator.aggregate();
        }
    }
}

