/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.NotificationContext;
import org.apache.helix.ZNRecord;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.ScheduledTaskStateModelFactory;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.log4j.Logger;

public class ScheduledTaskStateModel
extends StateModel {
    static final String DEFAULT_INITIAL_STATE = "OFFLINE";
    Logger logger = Logger.getLogger(ScheduledTaskStateModel.class);
    protected String _currentState = "OFFLINE";
    final ScheduledTaskStateModelFactory _factory;
    final String _partitionName;
    final HelixTaskExecutor _executor;

    public ScheduledTaskStateModel(ScheduledTaskStateModelFactory factory, HelixTaskExecutor executor, String partitionName) {
        this._factory = factory;
        this._partitionName = partitionName;
        this._executor = executor;
    }

    @Transition(to="COMPLETED", from="OFFLINE")
    public void onBecomeCompletedFromOffline(Message message, NotificationContext context) throws InterruptedException {
        MessageHandler handler;
        this.logger.info((Object)(this._partitionName + " onBecomeCompletedFromOffline"));
        Map<String, String> messageInfo = message.getRecord().getMapField(Message.Attributes.INNER_MESSAGE.toString());
        ZNRecord record = new ZNRecord(this._partitionName);
        record.getSimpleFields().putAll(messageInfo);
        Message taskMessage = new Message(record);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(taskMessage.getRecord().getSimpleFields());
        }
        if ((handler = this._executor.createMessageHandler(taskMessage, new NotificationContext(null))) == null) {
            throw new HelixException("Task message " + taskMessage.getMsgType() + " handler not found, task id " + this._partitionName);
        }
        handler.handleMessage();
        this.logger.info((Object)(this._partitionName + " onBecomeCompletedFromOffline completed"));
    }

    @Transition(to="OFFLINE", from="COMPLETED")
    public void onBecomeOfflineFromCompleted(Message message, NotificationContext context) {
        this.logger.info((Object)(this._partitionName + " onBecomeOfflineFromCompleted"));
    }

    @Transition(to="DROPPED", from="COMPLETED")
    public void onBecomeDroppedFromCompleted(Message message, NotificationContext context) {
        this.logger.info((Object)(this._partitionName + " onBecomeDroppedFromCompleted"));
        this.removeFromStatemodelFactory();
    }

    @Transition(to="DROPPED", from="OFFLINE")
    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) throws InterruptedException {
        this.logger.info((Object)(this._partitionName + " onBecomeDroppedFromScheduled"));
        this.removeFromStatemodelFactory();
    }

    @Transition(to="OFFLINE", from="ERROR")
    public void onBecomeOfflineFromError(Message message, NotificationContext context) throws InterruptedException {
        this.logger.info((Object)(this._partitionName + " onBecomeOfflineFromError"));
    }

    @Override
    public void reset() {
        this.logger.info((Object)(this._partitionName + " ScheduledTask reset"));
        this.removeFromStatemodelFactory();
    }

    private void removeFromStatemodelFactory() {
        if (this._factory.getStateModel(this._partitionName) != null) {
            this._factory.removeStateModel(this._partitionName);
        } else {
            this.logger.warn((Object)(this._partitionName + " not found in ScheduledTaskStateModelFactory"));
        }
    }
}

