/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.internals.lifecycle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.internals.lifecycle.Allowed;
import org.jbpm.services.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.services.task.internals.lifecycle.OperationCommand;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Operation;
import org.kie.internal.task.exception.TaskException;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELLifeCycleManager
implements LifeCycleManager {
    private static final Logger logger = LoggerFactory.getLogger(MVELLifeCycleManager.class);
    private TaskPersistenceContext persistenceContext;
    private TaskContentService taskContentService;
    private TaskEventSupport taskEventSupport;
    private static Map<Operation, List<OperationCommand>> operations = MVELLifeCycleManager.initMVELOperations();

    public MVELLifeCycleManager() {
    }

    public MVELLifeCycleManager(TaskPersistenceContext persistenceContext, TaskContentService contentService, TaskEventSupport taskEventSupport) {
        this.persistenceContext = persistenceContext;
        this.taskContentService = contentService;
        this.taskEventSupport = taskEventSupport;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setTaskEventSupport(TaskEventSupport taskEventSupport) {
        this.taskEventSupport = taskEventSupport;
    }

    public void setTaskContentService(TaskContentService taskContentService) {
        this.taskContentService = taskContentService;
    }

    void evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity, List<String> groupIds) throws PermissionDeniedException {
        boolean statusMatched = false;
        TaskData taskData = task.getTaskData();
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (task.getTaskData().getStatus() == status) {
                        statusMatched = true;
                        if (!this.isAllowed(command, task, user, groupIds)) {
                            String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + operation + "' on task id " + task.getId();
                            throw new PermissionDeniedException(errorMessage);
                        }
                        this.commands(command, task, user, targetEntity);
                        continue;
                    }
                    logger.debug("No match on status for task {} :status {}  != {}", new Object[]{task.getId(), task.getTaskData().getStatus(), status});
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() == status) {
                    statusMatched = true;
                    if (!this.isAllowed(command, task, user, groupIds)) {
                        String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + operation + "' on task id " + task.getId();
                        throw new PermissionDeniedException(errorMessage);
                    }
                    this.commands(command, task, user, targetEntity);
                    continue;
                }
                logger.debug("No match on previous status for task {} :status {}  != {}", new Object[]{task.getId(), task.getTaskData().getStatus(), status});
            }
        }
        if (!statusMatched) {
            String errorMessage = "User '" + user + "' was unable to execution operation '" + operation + "' on task id " + task.getId() + " due to a no 'current status' match";
            throw new PermissionDeniedException(errorMessage);
        }
    }

    private boolean isAllowed(OperationCommand command, Task task, User user, List<String> groupIds) {
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
                    break;
                }
                case Initiator: {
                    operationAllowed = task.getTaskData().getCreatedBy() != null && task.getTaskData().getCreatedBy().equals(user) || groupIds != null && groupIds.contains(task.getTaskData().getCreatedBy().getId());
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = this.isAllowed(user, groupIds, task.getPeopleAssignments().getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = this.isAllowed(user, groupIds, task.getPeopleAssignments().getBusinessAdministrators());
                    break;
                }
                case Anyone: {
                    operationAllowed = true;
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = task.getPeopleAssignments().getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkipable()) {
            operationAllowed = task.getTaskData().isSkipable();
        }
        return operationAllowed;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        InternalTaskData taskData = (InternalTaskData)task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                }
            }
        }
    }

    @Override
    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, Map<String, Object> data, List<String> groupIds) throws TaskException {
        List<OperationCommand> commands = operations.get(operation);
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        User user = this.persistenceContext.findUser(userId);
        OrganizationalEntity targetEntity = null;
        if (targetEntityId != null && !targetEntityId.equals("")) {
            targetEntity = this.persistenceContext.findOrgEntity(targetEntityId);
        }
        switch (operation) {
            case Activate: {
                this.taskEventSupport.fireBeforeTaskActivated(task, this.persistenceContext);
                break;
            }
            case Claim: {
                this.taskEventSupport.fireBeforeTaskClaimed(task, this.persistenceContext);
                break;
            }
            case Complete: {
                this.taskEventSupport.fireBeforeTaskCompleted(task, this.persistenceContext);
                break;
            }
            case Delegate: {
                this.taskEventSupport.fireBeforeTaskDelegated(task, this.persistenceContext);
                break;
            }
            case Exit: {
                this.taskEventSupport.fireBeforeTaskExited(task, this.persistenceContext);
                break;
            }
            case Fail: {
                if (data != null) {
                    FaultData faultData = ContentMarshallerHelper.marshalFault(data, null);
                    Content content = TaskModelProvider.getFactory().newContent();
                    ((InternalContent)content).setContent(faultData.getContent());
                    this.persistenceContext.persistContent(content);
                    ((InternalTaskData)task.getTaskData()).setFault(content.getId(), faultData);
                }
                this.taskEventSupport.fireBeforeTaskFailed(task, this.persistenceContext);
                break;
            }
            case Forward: {
                this.taskEventSupport.fireBeforeTaskForwarded(task, this.persistenceContext);
                break;
            }
            case Release: {
                this.taskEventSupport.fireBeforeTaskReleased(task, this.persistenceContext);
                break;
            }
            case Resume: {
                this.taskEventSupport.fireBeforeTaskResumed(task, this.persistenceContext);
                break;
            }
            case Skip: {
                this.taskEventSupport.fireBeforeTaskSkipped(task, this.persistenceContext);
                break;
            }
            case Start: {
                this.taskEventSupport.fireBeforeTaskStarted(task, this.persistenceContext);
                break;
            }
            case Stop: {
                this.taskEventSupport.fireBeforeTaskStopped(task, this.persistenceContext);
                break;
            }
            case Suspend: {
                this.taskEventSupport.fireBeforeTaskSuspended(task, this.persistenceContext);
            }
        }
        this.evalCommand(operation, commands, task, user, targetEntity, groupIds);
        switch (operation) {
            case Activate: {
                this.taskEventSupport.fireAfterTaskActivated(task, this.persistenceContext);
                break;
            }
            case Claim: {
                this.taskEventSupport.fireAfterTaskClaimed(task, this.persistenceContext);
                break;
            }
            case Complete: {
                if (data != null) {
                    this.taskContentService.addContent(taskId, data);
                }
                this.taskEventSupport.fireAfterTaskCompleted(task, this.persistenceContext);
                break;
            }
            case Delegate: {
                this.taskEventSupport.fireAfterTaskDelegated(task, this.persistenceContext);
                ((InternalTaskData)task.getTaskData()).setStatus(Status.Reserved);
            }
            case Exit: {
                this.taskEventSupport.fireAfterTaskExited(task, this.persistenceContext);
                break;
            }
            case Fail: {
                this.taskEventSupport.fireAfterTaskFailed(task, this.persistenceContext);
                break;
            }
            case Forward: {
                this.taskEventSupport.fireAfterTaskForwarded(task, this.persistenceContext);
                break;
            }
            case Release: {
                this.taskEventSupport.fireAfterTaskReleased(task, this.persistenceContext);
                break;
            }
            case Resume: {
                this.taskEventSupport.fireAfterTaskResumed(task, this.persistenceContext);
                break;
            }
            case Start: {
                this.taskEventSupport.fireAfterTaskStarted(task, this.persistenceContext);
                break;
            }
            case Skip: {
                this.taskEventSupport.fireAfterTaskSkipped(task, this.persistenceContext);
                break;
            }
            case Stop: {
                this.taskEventSupport.fireAfterTaskStopped(task, this.persistenceContext);
                break;
            }
            case Suspend: {
                this.taskEventSupport.fireAfterTaskSuspended(task, this.persistenceContext);
            }
        }
    }

    public static Map<Operation, List<OperationCommand>> initMVELOperations() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        InputStream is = null;
        is = MVELLifeCycleManager.class.getResourceAsStream("/operations-dsl.mvel");
        if (is == null) {
            throw new RuntimeException("Unable To initialise TaskService, could not find Operations DSL");
        }
        InputStreamReader reader = new InputStreamReader(is);
        try {
            return (Map)MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable To initialise TaskService, could not load Operations DSL");
        }
    }

    public static String toString(Reader reader) throws IOException {
        int charValue;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public static Object eval(Reader reader) {
        try {
            return MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(Reader reader, Map<String, Object> vars) {
        try {
            return MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(String str, Map<String, Object> vars) {
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addPackageImport("org.kie.internal.task.api.model");
        pconf.addPackageImport("org.jbpm.services.task");
        pconf.addPackageImport("org.jbpm.services.task.impl.model");
        pconf.addPackageImport("org.jbpm.services.task.query");
        pconf.addPackageImport("org.jbpm.services.task.internals.lifecycle");
        pconf.addImport(Status.class);
        pconf.addImport(Allowed.class);
        pconf.addPackageImport("java.util");
        ParserContext context = new ParserContext(pconf);
        Serializable s = MVEL.compileExpression((String)str.trim(), (ParserContext)context);
        if (vars != null) {
            return MVELSafeHelper.getEvaluator().executeExpression((Object)s, vars);
        }
        return MVELSafeHelper.getEvaluator().executeExpression((Object)s);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        User user = this.persistenceContext.findUser(userId);
        if (this.isAllowed(user, null, task.getPeopleAssignments().getBusinessAdministrators())) {
            ((InternalTaskData)task.getTaskData()).assignOwnerAndStatus(potentialOwners);
            if (task.getTaskData().getStatus() == Status.Ready) {
                ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
            }
        } else {
            throw new PermissionDeniedException("User " + userId + " is not allowed to perform Nominate on Task " + taskId);
        }
    }
}

