/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettings {
    private static final Logger log = LoggerFactory.getLogger(MavenSettings.class);
    private static final String CUSTOM_SETTINGS_PROPERTY = "kie.maven.settings.custom";

    public static Settings getSettings() {
        return SettingsHolder.settings;
    }

    private static Settings initSettings() {
        String mavenHome;
        DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        boolean useCustomSettingsLocation = false;
        String customSettings = System.getProperty(CUSTOM_SETTINGS_PROPERTY);
        if (customSettings != null) {
            File customSettingsFile = new File(customSettings);
            if (customSettingsFile.exists()) {
                request.setUserSettingsFile(customSettingsFile);
                useCustomSettingsLocation = true;
            } else {
                log.warn("Cannot find custom maven settings file: " + customSettings);
            }
        }
        String userHome = System.getProperty("user.home");
        if (!useCustomSettingsLocation) {
            if (userHome != null) {
                File userSettingsFile = new File(userHome + "/.m2/settings.xml");
                if (userSettingsFile.exists()) {
                    request.setUserSettingsFile(userSettingsFile);
                }
            } else {
                log.warn("User home is not set");
            }
        }
        if ((mavenHome = System.getenv("M2_HOME")) != null) {
            File globalSettingsFile = new File(mavenHome + "/conf/settings.xml");
            if (globalSettingsFile.exists()) {
                request.setGlobalSettingsFile(globalSettingsFile);
            }
        } else {
            log.warn("Environment variable M2_HOME is not set");
        }
        request.setSystemProperties(System.getProperties());
        Settings settings = null;
        try {
            settings = settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            new RuntimeException(e);
        }
        if (settings.getLocalRepository() == null) {
            if (userHome != null) {
                settings.setLocalRepository(userHome + "/.m2/repository");
            } else {
                log.error("Cannot find maven local repository");
            }
        }
        return settings;
    }

    static /* synthetic */ Settings access$000() {
        return MavenSettings.initSettings();
    }

    private static class SettingsHolder {
        private static final Settings settings = MavenSettings.access$000();

        private SettingsHolder() {
        }
    }
}

