/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.Date;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.jbpm.services.task.wih.NonManagedTaskEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.ContentData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonManagedLocalHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(NonManagedLocalHTWorkItemHandler.class);
    private KieSession ksession;
    private TaskService taskService;
    private TaskLifeCycleEventListener listener;
    private boolean initialized = false;

    public NonManagedLocalHTWorkItemHandler() {
    }

    public NonManagedLocalHTWorkItemHandler(KieSession ksession, TaskService taskService) {
        this.ksession = ksession;
        this.taskService = taskService;
        this.init();
    }

    public void init() {
        if (!this.initialized) {
            this.listener = new NonManagedTaskEventListener(this.ksession, this.taskService);
            if (this.taskService instanceof EventService) {
                ((EventService)this.taskService).registerTaskEventListener((Object)this.listener);
            }
            this.initialized = true;
        }
    }

    public void close() {
        if (this.taskService instanceof EventService) {
            ((EventService)this.taskService).clearTaskEventListeners();
        }
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block6: {
            Task task = this.createTaskBasedOnWorkItemParams(this.ksession, workItem);
            ContentData content = this.createTaskContentBasedOnWorkItemParams(this.ksession, workItem);
            try {
                long taskId = ((InternalTaskService)this.taskService).addTask(task, content);
                if (this.isAutoClaim(workItem, task)) {
                    this.taskService.claim(taskId, (String)workItem.getParameter("SwimlaneActorId"));
                }
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block6;
                StringBuilder logMsg = new StringBuilder();
                logMsg.append(new Date()).append(": Error when creating task on task server for work item id ").append(workItem.getId());
                logMsg.append(". Error reported by task server: ").append(e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.taskService.getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                this.taskService.exit(task.getId().longValue(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public KieSession getKsession() {
        return this.ksession;
    }

    public void setKsession(KieSession ksession) {
        this.ksession = ksession;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }
}

