/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.drl;

import java.util.List;
import org.dmg.pmml.pmml_4_1.descr.Attribute;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.Characteristics;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.drools.scorecards.drl.AbstractDRLEmitter;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;

public class DeclaredTypesDRLEmitter
extends AbstractDRLEmitter {
    @Override
    protected void addDeclaredTypeContents(PMML pmmlDocument, StringBuilder stringBuilder, Scorecard scorecard) {
        Characteristics characteristics = this.getCharacteristicsFromScorecard(scorecard);
        for (Characteristic c : characteristics.getCharacteristics()) {
            String field = ScorecardPMMLUtils.extractFieldNameFromCharacteristic(c);
            String dataType = ScorecardPMMLUtils.getDataType(pmmlDocument, field);
            if ("Text".equalsIgnoreCase(dataType)) {
                dataType = "String";
            } else if ("Number".equalsIgnoreCase(dataType)) {
                dataType = "int";
            } else if ("Boolean".equalsIgnoreCase(dataType)) {
                dataType = "boolean";
            }
            stringBuilder.append("\t").append(field).append(" : ").append(dataType).append("\n");
        }
    }

    @Override
    protected void internalEmitDRL(PMML pmml, List<Rule> ruleList, Package aPackage) {
    }

    @Override
    protected void addLHSConditions(Rule rule, PMML pmmlDocument, Scorecard scorecard, Characteristic c, Attribute scoreAttribute) {
        Condition condition = new Condition();
        StringBuilder stringBuilder = new StringBuilder();
        String var = "$sc";
        String objectClass = scorecard.getModelName().replaceAll(" ", "");
        stringBuilder.append(var).append(" : ").append(objectClass);
        this.createFieldRestriction(pmmlDocument, c, scoreAttribute, stringBuilder);
        condition.setSnippet(stringBuilder.toString());
        rule.addCondition(condition);
    }

    @Override
    protected void addAdditionalReasonCodeConsequence(Rule rule, Scorecard scorecard) {
        Consequence consequence = new Consequence();
        consequence.setSnippet("$sc.setReasonCodes($reasons);");
        rule.addConsequence(consequence);
        consequence = new Consequence();
        consequence.setSnippet("$sc.sortReasonCodes();");
        rule.addConsequence(consequence);
    }

    @Override
    protected void addAdditionalReasonCodeCondition(Rule rule, Scorecard scorecard) {
        this.createEmptyScorecardCondition(rule, scorecard);
    }

    @Override
    protected void addAdditionalSummationCondition(Rule calcTotalRule, Scorecard scorecard) {
        this.createEmptyScorecardCondition(calcTotalRule, scorecard);
    }

    @Override
    protected void addAdditionalSummationConsequence(Rule calcTotalRule, Scorecard scorecard) {
        Consequence consequence = new Consequence();
        if (scorecard.getInitialScore() > 0.0) {
            consequence.setSnippet("$sc.setCalculatedScore(($calculatedScore+$initialScore));");
        } else {
            consequence.setSnippet("$sc.setCalculatedScore($calculatedScore);");
        }
        calcTotalRule.addConsequence(consequence);
    }

    protected void createEmptyScorecardCondition(Rule rule, Scorecard scorecard) {
        String objectClass = scorecard.getModelName().replaceAll(" ", "");
        StringBuilder stringBuilder = new StringBuilder();
        String var = "$sc";
        stringBuilder.append(var).append(" : ").append(objectClass).append("()");
        Condition condition = new Condition();
        condition.setSnippet(stringBuilder.toString());
        rule.addCondition(condition);
    }

    @Override
    protected Condition createInitialRuleCondition(Scorecard scorecard, String objectClass) {
        String var = "$sc";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(var).append(" : ").append(objectClass).append("()");
        Condition condition = new Condition();
        condition.setSnippet(stringBuilder.toString());
        return condition;
    }
}

