/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene.setups;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene40.Lucene40Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.metadata.backend.lucene.setups.BaseLuceneSetup;

public class DirectoryLuceneSetup
extends BaseLuceneSetup {
    public static final String REPOSITORIES_ROOT_DIR = ".index";
    private final IndexWriter writer;
    private final Analyzer analyzer;
    private final Directory directory;
    private final boolean freshIndex;

    public DirectoryLuceneSetup(Directory directory, boolean freshIndex) {
        try {
            this.freshIndex = freshIndex;
            this.directory = (Directory)Preconditions.checkNotNull((String)"directory", (Object)directory);
            this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(Version.LUCENE_40), (Map)new HashMap<String, Analyzer>(){
                {
                    this.put("filename", new FilenameAnalyzer(Version.LUCENE_40));
                }
            });
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_40, this.getAnalyzer());
            Lucene40Codec codec = new Lucene40Codec(){

                public PostingsFormat getPostingsFormatForField(String field) {
                    if (field.equals("id")) {
                        return PostingsFormat.forName((String)"Memory");
                    }
                    return PostingsFormat.forName((String)"Lucene40");
                }
            };
            config.setCodec((Codec)codec);
            this.writer = new IndexWriter(directory, config);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IndexWriter writer() {
        return this.writer;
    }

    @Override
    public IndexSearcher nrtSearcher() {
        try {
            return new SearcherFactory().newSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void nrtRelease(IndexSearcher searcher) {
        try {
            searcher.getIndexReader().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void dispose() {
        try {
            this.writer.commit();
            this.writer.close();
            this.analyzer.close();
            this.directory.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean freshIndex() {
        return this.freshIndex;
    }

    @Override
    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static boolean freshIndex(File file) {
        return !file.exists();
    }

    protected static File defaultFile() {
        String value = System.getProperty("org.uberfire.metadata.index.dir");
        if (value == null || value.trim().isEmpty()) {
            return new File(REPOSITORIES_ROOT_DIR);
        }
        return new File(value.trim(), REPOSITORIES_ROOT_DIR);
    }
}

