/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.kie.services.client.api.command.RemoteConfiguration;

public class RestRequestHelper {
    private ClientRequestFactory requestFactory;
    private static int DEFAULT_TIMEOUT = 5;

    private URL addRestToPath(URL origUrl) {
        StringBuilder urlString = new StringBuilder(origUrl.toExternalForm());
        if (!urlString.toString().endsWith("/")) {
            urlString.append("/");
        }
        urlString.append("rest/");
        URL origPlusRestUrl = RestRequestHelper.convertStringToUrl(urlString.toString());
        return origPlusRestUrl;
    }

    private static URL convertStringToUrl(String urlString) {
        URL realUrl;
        try {
            realUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + urlString + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return realUrl;
    }

    private RestRequestHelper() {
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password, int timeout) {
        RestRequestHelper inst = new RestRequestHelper();
        URL serverPlusRestUrl = inst.addRestToPath(serverPortUrl);
        inst.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout);
        return inst;
    }

    public static RestRequestHelper newInstance(URL serverPortUrl, String username, String password) {
        RestRequestHelper inst = new RestRequestHelper();
        URL serverPlusRestUrl = inst.addRestToPath(serverPortUrl);
        inst.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, DEFAULT_TIMEOUT);
        return inst;
    }

    public ClientRequest createRequest(String restOperationUrl) {
        if (restOperationUrl.startsWith("/")) {
            restOperationUrl = restOperationUrl.substring(1);
        }
        return this.requestFactory.createRelativeRequest(restOperationUrl);
    }

    public static ClientRequestFactory createRequestFactory(String restBaseUrlString, String username, String password, int timeout) {
        URL url = RestRequestHelper.convertStringToUrl(restBaseUrlString);
        return RemoteConfiguration.createAuthenticatingRequestFactory(url, username, password, timeout);
    }

    public static ClientRequestFactory createRequestFactory(String restBaseUrlString, String username, String password) {
        URL url = RestRequestHelper.convertStringToUrl(restBaseUrlString);
        return RemoteConfiguration.createAuthenticatingRequestFactory(url, username, password, DEFAULT_TIMEOUT);
    }

    public static ClientRequestFactory createRequestFactory(URL restBaseUrl, String username, String password) {
        return RemoteConfiguration.createAuthenticatingRequestFactory(restBaseUrl, username, password, DEFAULT_TIMEOUT);
    }
}

