/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.ws.rs.core.Response;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jbpm.services.task.commands.AddTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.CompositeCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeException;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteCommandObject {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteCommandObject.class);
    protected final RemoteConfiguration config;
    protected boolean isTaskService = false;

    AbstractRemoteCommandObject(RemoteConfiguration config) {
        this.config = config;
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public <T> T execute(Command<T> cmd) {
        if (!AcceptedCommands.getSet().contains(cmd.getClass())) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            String methodName = st[2].getMethodName();
            throw new UnsupportedOperationException("The ." + methodName + "(..) method is not supported on the remote api.");
        }
        if (AcceptedCommands.SEND_OBJECT_PARAMETER_COMMANDS.contains(cmd.getClass())) {
            ArrayList<Object> extraClassInstanceList = new ArrayList<Object>();
            this.preprocessCommand(cmd, extraClassInstanceList);
            if (!extraClassInstanceList.isEmpty()) {
                HashSet extraJaxbClasses = new HashSet();
                for (Object e : extraClassInstanceList) {
                    Class<?> jaxbClass = e.getClass();
                    if (jaxbClass.isLocalClass() || jaxbClass.isAnonymousClass()) {
                        throw new SerializationException("Only proper classes are allowed as parameters for the remote API: neither local nor anonymous classes are accepted: " + jaxbClass.getName());
                    }
                    extraJaxbClasses.add(jaxbClass);
                }
                this.config.addJaxbClasses(extraJaxbClasses);
            }
        }
        if (this.config.isRest()) {
            return this.executeRestCommand(cmd);
        }
        return this.executeJmsCommand(cmd);
    }

    private void preprocessCommand(Command cmd, List<Object> extraClassInstanceList) {
        if (cmd instanceof CompleteWorkItemCommand) {
            this.addPossiblyNullObjectMap(((CompleteWorkItemCommand)cmd).getResults(), extraClassInstanceList);
        } else if (cmd instanceof SignalEventCommand) {
            this.addPossiblyNullObject(((SignalEventCommand)cmd).getEvent(), extraClassInstanceList);
        } else if (cmd instanceof StartCorrelatedProcessCommand) {
            this.addPossiblyNullObjectList(((StartCorrelatedProcessCommand)cmd).getData(), extraClassInstanceList);
            this.addPossiblyNullObjectMap(((StartCorrelatedProcessCommand)cmd).getParameters(), extraClassInstanceList);
        } else if (cmd instanceof StartProcessCommand) {
            this.addPossiblyNullObjectList(((StartProcessCommand)cmd).getData(), extraClassInstanceList);
            this.addPossiblyNullObjectMap(((StartProcessCommand)cmd).getParameters(), extraClassInstanceList);
        } else if (cmd instanceof SetGlobalCommand) {
            this.addPossiblyNullObject(((SetGlobalCommand)cmd).getObject(), extraClassInstanceList);
        } else if (cmd instanceof InsertObjectCommand) {
            this.addPossiblyNullObject(((InsertObjectCommand)cmd).getObject(), extraClassInstanceList);
        } else if (cmd instanceof UpdateCommand) {
            this.addPossiblyNullObject(((UpdateCommand)cmd).getObject(), extraClassInstanceList);
        } else if (cmd instanceof AddTaskCommand) {
            this.addPossiblyNullObjectMap(((AddTaskCommand)cmd).getParams(), extraClassInstanceList);
        } else if (cmd instanceof CompleteTaskCommand) {
            this.addPossiblyNullObjectMap(((CompleteTaskCommand)cmd).getData(), extraClassInstanceList);
        } else if (cmd instanceof FailTaskCommand) {
            this.addPossiblyNullObjectMap(((FailTaskCommand)cmd).getData(), extraClassInstanceList);
        } else if (cmd instanceof CompositeCommand) {
            CompositeCommand composite = (CompositeCommand)cmd;
            this.preprocessCommand((Command)composite.getMainCommand(), extraClassInstanceList);
            if (composite.getCommands() != null) {
                for (TaskCommand c : composite.getCommands()) {
                    this.preprocessCommand((Command)c, extraClassInstanceList);
                }
            }
        }
    }

    private void addPossiblyNullObject(Object inputObject, List<Object> objectList) {
        if (inputObject != null) {
            objectList.add(inputObject);
        }
    }

    private void addPossiblyNullObjectList(List<Object> inputList, List<Object> objectList) {
        if (inputList != null && !inputList.isEmpty()) {
            objectList.addAll(objectList);
        }
    }

    private void addPossiblyNullObjectMap(Map<String, Object> inputMap, List<Object> objectList) {
        if (inputMap != null && !inputMap.isEmpty()) {
            objectList.addAll(inputMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeJmsCommand(Command<T> command) {
        JaxbCommandsRequest req = new JaxbCommandsRequest(this.config.getDeploymentId(), command);
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = command instanceof TaskCommand ? this.config.getKsessionQueue() : this.config.getTaskQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            JaxbSerializationProvider serializationProvider;
            BytesMessage msg;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUsername(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to setup a JMS connection.", jmse);
            }
            try {
                msg = session.createBytesMessage();
                serializationProvider = this.config.getJaxbSerializationProvider();
                String xmlStr = serializationProvider.serialize(req);
                msg.writeUTF(xmlStr);
                msg.setJMSCorrelationID(corrId);
                msg.setIntProperty("serialization", this.config.getSerializationType());
                Set<Class<?>> extraJaxbClasses = this.config.getExtraJaxbClasses();
                if (!extraJaxbClasses.isEmpty()) {
                    String extraJaxbClassesPropertyValue = JaxbSerializationProvider.classSetToCommaSeperatedString(extraJaxbClasses);
                    msg.setStringProperty("extraJaxbClasses", extraJaxbClassesPropertyValue);
                    msg.setStringProperty("deploymentId", this.config.getDeploymentId());
                }
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to create and fill a JMS message.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteRuntimeException("Unable to deserialze JMS message.", se.getCause());
            }
            try {
                producer.send((Message)msg);
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive((long)this.config.getQualityOfServiceThresholdMilliSeconds());
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to receive or retrieve the JMS response.", jmse);
            }
            assert (response != null) : "Response is empty.";
            try {
                String xmlStr = ((BytesMessage)response).readUTF();
                cmdResponse = (JaxbCommandsResponse)serializationProvider.deserialize(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteRuntimeException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", se.getCause());
            }
            assert (cmdResponse != null) : "Jaxb Cmd Response was null!";
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    session.close();
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
        List<JaxbCommandResponse<?>> responses = cmdResponse.getResponses();
        if (responses.size() > 0) {
            JaxbCommandResponse<?> response = responses.get(0);
            if (response instanceof JaxbExceptionResponse) {
                JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)response;
                throw new RemoteRuntimeException(exceptionResponse.getMessage());
            }
            return (T)response.getResult();
        }
        assert (responses.size() == 0) : "There should only be 1 response, not " + responses.size() + ", returned by a command!";
        return null;
    }

    private <T> T executeRestCommand(Command<T> command) {
        String requestUrl;
        String deploymentId = this.config.getDeploymentId();
        ClientRequestFactory requestFactory = this.config.getRequestFactory();
        ClientRequest restRequest = this.isTaskService ? requestFactory.createRelativeRequest("/task/execute") : requestFactory.createRelativeRequest("/runtime/" + deploymentId + "/execute");
        JaxbCommandsRequest jaxbRequest = new JaxbCommandsRequest(deploymentId, command);
        String jaxbRequestString = this.config.getJaxbSerializationProvider().serialize(jaxbRequest);
        restRequest.body("application/xml", (Object)jaxbRequestString);
        ClientResponse response = null;
        try {
            requestUrl = restRequest.getUri();
            response = restRequest.post(Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to post request: " + e.getMessage(), e);
        }
        if (response.getResponseStatus() == Response.Status.OK) {
            JaxbCommandsResponse commandResponse = (JaxbCommandsResponse)response.getEntity(JaxbCommandsResponse.class);
            List<JaxbCommandResponse<?>> responses = commandResponse.getResponses();
            if (responses.size() == 0) {
                return null;
            }
            if (responses.size() == 1) {
                JaxbCommandResponse<?> responseObject = responses.get(0);
                if (responseObject instanceof JaxbExceptionResponse) {
                    JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)responseObject;
                    String causeMessage = exceptionResponse.getCauseMessage();
                    throw new RuntimeException(exceptionResponse.getMessage() + (causeMessage == null ? "" : " Caused by: " + causeMessage));
                }
                return (T)responseObject.getResult();
            }
            throw new RuntimeException("Unexpected number of results from " + command.getClass().getSimpleName() + ":" + responses.size() + " results instead of only 1");
        }
        throw new RuntimeException("Error invoking " + command.getClass().getSimpleName() + " via REST (" + requestUrl + "):\n" + (String)response.getEntity(String.class));
    }
}

