/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.kie.api.runtime.manager.Context;
import org.kie.services.client.api.command.RemoteRuntimeException;
import org.kie.services.client.serialization.JaxbSerializationProvider;

public final class RemoteConfiguration {
    public static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    public static final String SESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    public static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    public static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    private final Type type;
    private String deploymentId;
    private String username;
    private String password;
    private Context<?> context;
    private Set<Class<?>> extraJaxbClasses = new HashSet();
    private ClientRequestFactory requestFactory;
    private ConnectionFactory connectionFactory;
    private Queue ksessionQueue;
    private Queue taskQueue;
    private Queue responseQueue;
    private int qualityOfServiceThresholdMilliSeconds = 5000;
    private int jmsSerializationType = 0;
    private static final AtomicInteger idGen = new AtomicInteger(0);

    private RemoteConfiguration() {
        this.type = Type.CONSTRUCTOR;
    }

    public RemoteConfiguration(String deploymentId, URL url) {
        this.type = Type.REST;
        URL realUrl = this.initialize(deploymentId, url);
        try {
            this.requestFactory = new ClientRequestFactory(realUrl.toURI());
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + realUrl.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password) {
        this(deploymentId, url, username, password, 5);
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password, int timeout) {
        this.type = Type.REST;
        URL serverPlusRestUrl = this.initialize(deploymentId, url);
        this.requestFactory = RemoteConfiguration.createAuthenticatingRequestFactory(serverPlusRestUrl, username, password, timeout);
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name may not be empty or null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        this.username = username;
        this.password = password;
    }

    private URL initialize(String deploymentId, URL url) {
        URL serverPlusRestUrl;
        if (deploymentId == null || deploymentId.trim().isEmpty()) {
            throw new IllegalArgumentException("The deployment id may not be empty or null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        this.deploymentId = deploymentId;
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "rest";
        try {
            serverPlusRestUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return serverPlusRestUrl;
    }

    public static ClientRequestFactory createAuthenticatingRequestFactory(URL url, String username, String password, int timeout) {
        BasicHttpContext localContext = new BasicHttpContext();
        DefaultHttpClient preemptiveAuthClient = RemoteConfiguration.createPreemptiveAuthHttpClient(username, password, timeout, localContext);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)preemptiveAuthClient, (HttpContext)localContext);
        try {
            return new ClientRequestFactory((ClientExecutor)clientExecutor, url.toURI());
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is not formatted correctly.", urise);
        }
    }

    private static DefaultHttpClient createPreemptiveAuthHttpClient(String userName, String password, int timeout, BasicHttpContext localContext) {
        BasicHttpParams params = new BasicHttpParams();
        int timeoutMilliSeconds = timeout * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (userName != null && !"".equals(userName)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            BasicScheme basicAuth = new BasicScheme();
            String contextId = UUID.randomUUID().toString();
            localContext.setAttribute(contextId, (Object)basicAuth);
            client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(contextId), 0);
        }
        String hostname = "localhost";
        try {
            hostname = Inet6Address.getLocalHost().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String userAgent = "org.kie.services.client (" + idGen.incrementAndGet() + " / " + hostname + ")";
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)userAgent);
        return client;
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        RemoteConfiguration.checkValidValues(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue);
        this.deploymentId = deploymentId;
        this.connectionFactory = connectionFactory;
        this.ksessionQueue = ksessionQueue;
        this.taskQueue = taskQueue;
        this.responseQueue = responseQueue;
        this.type = Type.JMS;
    }

    private static void checkValidValues(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        if (deploymentId == null || deploymentId.trim().isEmpty()) {
            throw new IllegalArgumentException("The deployment id may not be empty or null.");
        }
        if (connectionFactory == null) {
            throw new IllegalArgumentException("The connection factory argument may not be null.");
        }
        if (ksessionQueue == null) {
            throw new IllegalArgumentException("The ksession queue argument may not be null.");
        }
        if (taskQueue == null) {
            throw new IllegalArgumentException("The task queue argument may not be null.");
        }
        if (responseQueue == null) {
            throw new IllegalArgumentException("The response queue argument may not be null.");
        }
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password) {
        this(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue);
        this.username = username;
        this.password = password;
    }

    public RemoteConfiguration(String deploymentId, InitialContext context) {
        this.deploymentId = deploymentId;
        String prop = CONNECTION_FACTORY_NAME;
        try {
            this.connectionFactory = (ConnectionFactory)context.lookup(prop);
            prop = SESSION_QUEUE_NAME;
            this.ksessionQueue = (Queue)context.lookup(prop);
            prop = TASK_QUEUE_NAME;
            this.taskQueue = (Queue)context.lookup(prop);
            prop = RESPONSE_QUEUE_NAME;
            this.responseQueue = (Queue)context.lookup(prop);
        }
        catch (NamingException ne) {
            throw new RemoteRuntimeException("Unable to retrieve object for " + prop, ne);
        }
        RemoteConfiguration.checkValidValues(deploymentId, this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
        this.type = Type.JMS;
    }

    public RemoteConfiguration(String deploymentId, InitialContext context, String username, String password) {
        this(deploymentId, context);
        this.username = username;
        this.password = password;
    }

    public void setQualityOfServiceThresholdMilliSeconds(int qualityOfServiceThresholdMilliSeconds) {
        if (qualityOfServiceThresholdMilliSeconds < 0) {
            throw new IllegalArgumentException("The QOS threshold limit must be positve.");
        }
        this.qualityOfServiceThresholdMilliSeconds = qualityOfServiceThresholdMilliSeconds;
    }

    public void setSerializationType(int serializationType) {
        this.jmsSerializationType = serializationType;
    }

    public void setContext(Context<?> context) {
        this.context = context;
    }

    String getDeploymentId() {
        assert (this.deploymentId != null) : "deploymentId value should not be null!";
        return this.deploymentId;
    }

    String getUsername() {
        assert (this.username != null) : "username value should not be null!";
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    int getSerializationType() {
        return this.jmsSerializationType;
    }

    boolean isJms() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.JMS;
    }

    boolean isRest() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.REST;
    }

    ClientRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    Context<?> getContext() {
        assert (this.context != null) : "context value should not be null!";
        return this.context;
    }

    ConnectionFactory getConnectionFactory() {
        assert (this.connectionFactory != null) : "connectionFactory value should not be null!";
        return this.connectionFactory;
    }

    Queue getKsessionQueue() {
        assert (this.ksessionQueue != null) : "ksessionQueue value should not be null!";
        return this.ksessionQueue;
    }

    Queue getTaskQueue() {
        assert (this.taskQueue != null) : "taskQueue value should not be null!";
        return this.taskQueue;
    }

    Queue getResponseQueue() {
        assert (this.responseQueue != null) : "responseQueue value should not be null!";
        return this.responseQueue;
    }

    int getQualityOfServiceThresholdMilliSeconds() {
        return this.qualityOfServiceThresholdMilliSeconds;
    }

    public void addJaxbClasses(Set<Class<?>> extraJaxbClassList) {
        this.extraJaxbClasses.addAll(extraJaxbClassList);
    }

    Set<Class<?>> getExtraJaxbClasses() {
        return this.extraJaxbClasses;
    }

    JaxbSerializationProvider getJaxbSerializationProvider() {
        JaxbSerializationProvider provider = new JaxbSerializationProvider(this.extraJaxbClasses);
        return provider;
    }

    private static enum Type {
        REST,
        JMS,
        CONSTRUCTOR;

    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final String contextId;

        public PreemptiveAuth(String contextId) {
            this.contextId = contextId;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute(this.contextId);
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

