/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.deployment;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.scanner.MavenRepository;
import org.kie.services.client.deployment.FluentKieModuleDeploymentHelper;
import org.kie.services.client.deployment.KieModuleDeploymentConfig;
import org.kie.services.client.deployment.SingleKieModuleDeploymentHelper;

final class KieModuleDeploymentHelperImpl
extends FluentKieModuleDeploymentHelper
implements SingleKieModuleDeploymentHelper {
    private KieModuleDeploymentConfig config = new KieModuleDeploymentConfig();

    @Override
    public FluentKieModuleDeploymentHelper setGroupId(String groupId) {
        KieModuleDeploymentHelperImpl.assertNotNull(groupId, "groupId");
        this.config.setGroupId(groupId);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setArtifactId(String artifactId) {
        KieModuleDeploymentHelperImpl.assertNotNull(artifactId, "artifactId");
        this.config.setArtifactId(artifactId);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setVersion(String version) {
        KieModuleDeploymentHelperImpl.assertNotNull(version, "version");
        this.config.setVersion(version);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setKBaseName(String kbaseName) {
        KieModuleDeploymentHelperImpl.assertNotNull(kbaseName, "kbase name");
        this.config.setKbaseName(kbaseName);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setKieSessionname(String ksessionName) {
        KieModuleDeploymentHelperImpl.assertNotNull(ksessionName, "ksession name");
        this.config.setKsessionName(ksessionName);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setResourceFilePaths(List<String> resourceFilePaths) {
        KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePaths, "resourceFilePaths");
        this.config.resourceFilePaths.addAll(resourceFilePaths);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addResourceFilePath(String ... resourceFilePath) {
        KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePath, "resourceFilePath");
        for (int i = 0; i < resourceFilePath.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(resourceFilePath[i], "resourceFilePath[" + i + "]");
            this.config.resourceFilePaths.add(resourceFilePath[i]);
        }
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setClasses(List<Class<?>> classesForKjar) {
        KieModuleDeploymentHelperImpl.assertNotNull(classesForKjar, "classesForKjar");
        this.config.classes.addAll(classesForKjar);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addClass(Class<?> ... classForKjar) {
        KieModuleDeploymentHelperImpl.assertNotNull(classForKjar, "classForKjar");
        for (int i = 0; i < classForKjar.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(classForKjar[i], "classForKjar[" + i + "]");
            this.config.classes.add(classForKjar[i]);
        }
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper setDependencies(List<String> dependencies) {
        KieModuleDeploymentHelperImpl.assertNotNull(dependencies, "dependencies");
        this.config.dependencies.addAll(dependencies);
        return this;
    }

    @Override
    public FluentKieModuleDeploymentHelper addDependencies(String ... dependency) {
        KieModuleDeploymentHelperImpl.assertNotNull(dependency, "dependency");
        for (int i = 0; i < dependency.length; ++i) {
            KieModuleDeploymentHelperImpl.assertNotNull(dependency[i], "dependency[" + i + "]");
            this.config.dependencies.add(dependency[i]);
        }
        return this;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.config.getKieProject();
    }

    @Override
    public FluentKieModuleDeploymentHelper resetHelper() {
        this.config = new KieModuleDeploymentConfig();
        return this;
    }

    @Override
    public KieModule createKieJar() {
        this.config.checkComplete();
        return this.internalCreateKieJar(this.config.getReleaseId(), this.config.getKbaseName(), this.config.getKsessionName(), this.config.resourceFilePaths, this.config.classes, this.config.dependencies);
    }

    @Override
    public void createKieJarAndDeployToMaven() {
        this.config.checkComplete();
        this.internalCreateAndDeployKjarToMaven(this.config.getReleaseId(), this.config.getKbaseName(), this.config.getKsessionName(), this.config.resourceFilePaths, this.config.classes, this.config.dependencies);
    }

    private static void assertNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException("Null " + name + " arguments are not accepted!");
        }
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, null, null);
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> bpmnFilePaths, List<Class<?>> classes) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, bpmnFilePaths, classes, null);
    }

    @Override
    public KieModule createKieJar(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> bpmnFilePaths, List<Class<?>> classes, List<String> dependencies) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        return this.internalCreateKieJar((ReleaseId)releaseId, kbaseName, ksessionName, bpmnFilePaths, classes, dependencies);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, null, null);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classesForKjar) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, classesForKjar, null);
    }

    @Override
    public void createKieJarAndDeployToMaven(String groupId, String artifactId, String version, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classesForKjar, List<String> dependencies) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(groupId, artifactId, version);
        this.internalCreateAndDeployKjarToMaven((ReleaseId)releaseId, kbaseName, ksessionName, resourceFilePaths, classesForKjar, dependencies);
    }

    private synchronized void internalCreateAndDeployKjarToMaven(ReleaseId releaseId, String kbaseName, String ksessionName, List<String> resourceFilePaths, List<Class<?>> classes, List<String> dependencies) {
        InternalKieModule kjar = (InternalKieModule)this.internalCreateKieJar(releaseId, kbaseName, ksessionName, resourceFilePaths, classes, dependencies);
        String pomFileName = MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom";
        File pomFile = new File(System.getProperty("java.io.tmpdir"), pomFileName);
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(this.config.pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write pom.xml to temporary file : " + ioe.getMessage(), ioe);
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kjar, pomFile);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized KieModule internalCreateKieJar(ReleaseId releaseId, String kbaseName, String ksessionName, List<String> bpmnFilePaths, List<Class<?>> classes, List<String> dependencies) {
        void var11_17;
        ReleaseId[] releaseIds = new ReleaseId[]{};
        if (dependencies != null && dependencies.size() > 0) {
            ArrayList<ReleaseIdImpl> depReleaseIds = new ArrayList<ReleaseIdImpl>();
            for (String dep : dependencies) {
                String[] stringArray = dep.split(":");
                if (stringArray.length != 3) {
                    throw new IllegalArgumentException("Dependendency id '" + dep + "' does not conform to the format <groupId>:<artifactId>:<version>");
                }
                depReleaseIds.add(new ReleaseIdImpl(stringArray[0], stringArray[1], stringArray[2]));
            }
            releaseIds = depReleaseIds.toArray(new ReleaseId[depReleaseIds.size()]);
        }
        this.config.pomText = KieModuleDeploymentHelperImpl.getPomText(releaseId, releaseIds);
        KieFileSystem kfs = this.createKieFileSystemWithKProject(kbaseName, ksessionName);
        kfs.writePomXML(this.config.pomText);
        List<KJarResource> resourceFiles = KieModuleDeploymentHelperImpl.loadResources(bpmnFilePaths);
        for (KJarResource kJarResource : resourceFiles) {
            kfs.write("src/main/resources/" + kbaseName + "/" + kJarResource.name, kJarResource.content);
        }
        if (classes != null) {
            for (Class clazz : classes) {
                KieModuleDeploymentHelperImpl.addClass(clazz, kfs);
            }
        }
        KieBuilder kieBuilder = this.config.getKieServicesInstance().newKieBuilder(kfs);
        boolean bl = false;
        for (Message buildMsg : kieBuilder.buildAll().getResults().getMessages()) {
            System.out.println(buildMsg.getPath() + " : " + buildMsg.getText());
            ++var11_17;
        }
        if (var11_17 > 0) {
            throw new RuntimeException("Unable to build KieModule, see the " + (int)var11_17 + " above.");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private KieFileSystem createKieFileSystemWithKProject(String kbaseName, String ksessionName) {
        KieModuleModel kproj = this.config.getKieProject();
        KieFileSystem kfs = this.config.getKieServicesInstance().newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private static String getPomText(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n" + "  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n" + "  <version>" + releaseId.getVersion() + "</version>\n" + "\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<KJarResource> internalLoadResources(String path, boolean fromDir) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        ArrayList<KJarResource> output = new ArrayList<KJarResource>();
        URL url = KieModuleDeploymentHelperImpl.class.getResource(path);
        if (fromDir) {
            if (url == null) {
                File folder = new File(path);
                if (!folder.exists()) throw new IllegalArgumentException("Directory + '" + path + "' does not exist.");
                for (File folderFile : folder.listFiles()) {
                    if (folderFile.isDirectory()) continue;
                    String content = KieModuleDeploymentHelperImpl.convertFileToString(new FileInputStream(folderFile));
                    output.add(new KJarResource(folderFile.getName(), content));
                }
                return output;
            } else if ("file".equals(url.getProtocol())) {
                File folder = new File(url.toURI());
                if (!folder.isDirectory()) throw new IllegalStateException("'" + path + "' is not an existing directory.");
                for (File folderFile : folder.listFiles()) {
                    if (folderFile.getName().endsWith(".class") || folderFile.isDirectory()) continue;
                    String content = KieModuleDeploymentHelperImpl.convertFileToString(new FileInputStream(folderFile));
                    output.add(new KJarResource(folderFile.getName(), content));
                }
                return output;
            } else {
                int jarPathIndex;
                if (!"jar".equals(url.getProtocol())) throw new IllegalArgumentException("Unable to find resource directory '" + path + "'");
                String urlString = url.toExternalForm();
                String resourcePath = urlString.substring((jarPathIndex = urlString.lastIndexOf(".jar!") + 4) + 1);
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                int depth = resourcePath.split(File.separator).length + 1;
                String jarUrlString = urlString.substring("jar:".length(), jarPathIndex);
                url = new URL(jarUrlString);
                ZipInputStream zip = new ZipInputStream(url.openStream());
                ZipEntry ze = zip.getNextEntry();
                while (ze != null) {
                    String name = ze.getName();
                    if (name.startsWith(resourcePath) && !name.endsWith(File.separator) && name.split(File.separator).length == depth) {
                        String shortName = name.substring(name.lastIndexOf("/") + 1);
                        String content = KieModuleDeploymentHelperImpl.convertFileToString(zip);
                        output.add(new KJarResource(shortName, content));
                    }
                    ze = zip.getNextEntry();
                }
            }
            return output;
        } else {
            InputStream is = KieModuleDeploymentHelperImpl.class.getResourceAsStream(path);
            if (is == null) {
                is = new FileInputStream(new File(path));
            }
            String content = KieModuleDeploymentHelperImpl.convertFileToString(is);
            String name = path.substring(path.lastIndexOf("/") + 1);
            output.add(new KJarResource(name, content));
        }
        return output;
    }

    private static KJarResource createKJarResource(File resourceFile) throws Exception {
        FileInputStream in = new FileInputStream(resourceFile);
        String content = KieModuleDeploymentHelperImpl.convertFileToString(in);
        assert (content.length() > 0) : "Resource file '" + resourceFile.getAbsolutePath() + "' is empty.";
        return new KJarResource(resourceFile.getName(), content);
    }

    private static List<KJarResource> loadResources(List<String> resourceFilePaths) {
        ArrayList<KJarResource> kjarResources = new ArrayList<KJarResource>();
        for (String filePath : resourceFilePaths) {
            if (filePath.endsWith("/")) {
                try {
                    kjarResources.addAll(KieModuleDeploymentHelperImpl.internalLoadResources(filePath, true));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load resources from " + filePath + ": " + e.getMessage(), e);
                }
            }
            try {
                kjarResources.addAll(KieModuleDeploymentHelperImpl.internalLoadResources(filePath, false));
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException("No file found at '" + filePath + "' -- if it's a directory, please add a " + File.separator + " to the end of the path.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load resource from '" + filePath + "'", e);
            }
        }
        return kjarResources;
    }

    private static String convertFileToString(InputStream in) {
        InputStreamReader input = new InputStreamReader(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter output = new OutputStreamWriter(baos);
        char[] buffer = new char[4096];
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    private static void addClass(Class<?> userClass, KieFileSystem kfs) {
        String classSimpleName = userClass.getSimpleName();
        URL classFileUrl = userClass.getResource(classSimpleName + ".class");
        if (classFileUrl == null) {
            throw new RuntimeException("Class " + userClass.getCanonicalName() + " can not be found on the classpath.");
        }
        byte[] classByteCode = null;
        if ("file".equalsIgnoreCase(classFileUrl.getProtocol())) {
            File classFile = new File(classFileUrl.getPath());
            if (!classFile.exists()) {
                throw new RuntimeException("Unable to find path for class " + userClass.getCanonicalName() + " that should be here: " + classFileUrl.toExternalForm());
            }
            try {
                classByteCode = KieModuleDeploymentHelperImpl.readStream(new FileInputStream(classFile));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read in " + classFile.getAbsolutePath(), e);
            }
            if (classByteCode.length == 0) {
                throw new RuntimeException("No bytes retrieved from " + classFile.getAbsolutePath());
            }
        } else if ("jar".equalsIgnoreCase(classFileUrl.getProtocol())) {
            String path = classFileUrl.getPath();
            int bangIndex = path.indexOf(33);
            String jarPath = path.substring("file:".length(), bangIndex);
            String classPath = path.substring(bangIndex + 2);
            try {
                ZipFile zip = new ZipFile(new File(jarPath));
                ZipEntry entry = zip.getEntry(classPath);
                InputStream zipStream = zip.getInputStream(entry);
                classByteCode = KieModuleDeploymentHelperImpl.readStream(zipStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read from " + jarPath, e);
            }
        }
        String pkgFolder = userClass.getPackage().toString();
        pkgFolder = pkgFolder.replace("package ", "");
        pkgFolder = pkgFolder.replaceAll(",.+$", "");
        String classFilePath = (pkgFolder = pkgFolder.replaceAll("\\.", File.separator)) + "/" + classSimpleName + ".class";
        if (classFilePath.contains(" ")) {
            throw new RuntimeException("Invalid class name ('" + classFilePath + "'), contact the developers.");
        }
        kfs.write(classFilePath, classByteCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream ios) throws Exception {
        ByteArrayOutputStream baos = null;
        try {
            byte[] buffer = new byte[4096];
            baos = new ByteArrayOutputStream();
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    static class KJarResource {
        public String name;
        public String content;

        public KJarResource(String name, String content) {
            this.content = content;
            this.name = name;
        }
    }
}

