/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;

public class JsonSerializationProvider
implements SerializationProvider {
    public static final int JMS_SERIALIZATION_TYPE = 1;
    private ObjectMapper mapper = new JaxbJacksonObjectMapper();
    private Class<?> outputType = null;

    public JsonSerializationProvider() {
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException jge) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", jge);
        }
        catch (JsonMappingException jme) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", jme);
        }
        catch (IOException ie) {
            throw new SerializationException("Unable to serialize " + object.getClass().getSimpleName() + " instance", ie);
        }
    }

    public void setDeserializeOutputClass(Class<?> type) {
        this.outputType = type;
    }

    @Override
    public Object deserialize(Object jsonStrObject) {
        if (!(jsonStrObject instanceof String)) {
            throw new UnsupportedOperationException(JaxbSerializationProvider.class.getSimpleName() + " can only deserialize Strings");
        }
        String jsonStr = (String)jsonStrObject;
        try {
            return this.mapper.readValue(jsonStr, this.outputType);
        }
        catch (JsonGenerationException jge) {
            throw new SerializationException("Unable to deserialize String " + this.outputType.getClass().getSimpleName() + " instance", jge);
        }
        catch (JsonMappingException jme) {
            throw new SerializationException("Unable to deserialize String " + this.outputType.getClass().getSimpleName() + " instance", jme);
        }
        catch (IOException ie) {
            throw new SerializationException("Unable to deserialize String to " + this.outputType.getClass().getSimpleName() + " instance", ie);
        }
    }

    private static class JaxbJacksonObjectMapper
    extends ObjectMapper {
        public JaxbJacksonObjectMapper() {
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
            this.configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
            this.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
            this.setDeserializationConfig(this.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector));
            this.setSerializationConfig(this.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector));
            this.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        }
    }
}

