/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClockType;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.command.CommandService;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.util.ConfFileUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KeepReferenceOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExectionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.conf.WorkItemHandlerOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.utils.ChainedProperties;

public class SessionConfiguration
implements KieSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private ForceEagerActivationFilter forceEagerActivationFilter;
    private TimedRuleExecutionFilter timedRuleExecutionFilter;
    private ClockType clockType;
    private BeliefSystemType beliefSystemType;
    private QueryListenerOption queryListener;
    private Map<String, WorkItemHandler> workItemHandlers;
    private WorkItemManagerFactory workItemManagerFactory;
    private CommandService commandService;
    private transient ClassLoader classLoader;
    private transient TimerJobFactoryManager timerJobFactoryManager;
    private TimerJobFactoryType timerJobFactoryType;
    private static final SessionConfiguration defaultInstance = new SessionConfiguration();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
        out.writeObject(this.queryListener);
        out.writeObject((Object)this.timerJobFactoryType);
    }

    public static SessionConfiguration getDefaultInstance() {
        return defaultInstance;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
        this.queryListener = (QueryListenerOption)in.readObject();
        this.timerJobFactoryType = (TimerJobFactoryType)((Object)in.readObject());
    }

    public SessionConfiguration(Properties properties) {
        this.init(properties, null);
    }

    public SessionConfiguration() {
        this.init(null, null);
    }

    public SessionConfiguration(ClassLoader ... classLoader) {
        this.init(null, classLoader);
    }

    private void init(Properties properties, ClassLoader ... classLoaders) {
        this.classLoader = ProjectClassLoader.getClassLoader(classLoaders, this.getClass(), false);
        this.immutable = false;
        this.chainedProperties = new ChainedProperties("session.conf", this.classLoader);
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.valueOf(this.chainedProperties.getProperty("drools.keepReference", "true")));
        this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve((String)this.chainedProperties.getProperty("drools.forceEagerActivation", "false")).getFilter());
        this.setTimedRuleExecutionFilter(TimedRuleExectionOption.resolve((String)this.chainedProperties.getProperty("drools.timedRuleExection", "false")).getFilter());
        this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(this.chainedProperties.getProperty("drools.beliefSystem", BeliefSystemType.SIMPLE.getId())));
        this.setClockType(ClockType.resolveClockType(this.chainedProperties.getProperty("drools.clockType", ClockType.REALTIME_CLOCK.getId())));
        this.setQueryListenerClass(this.chainedProperties.getProperty("drools.queryListener", QueryListenerOption.STANDARD.getAsString()));
        this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(this.chainedProperties.getProperty("drools.timerJobFactory", TimerJobFactoryType.DEFUALT.getId())));
    }

    public void addDefaultProperties(Properties properties) {
        Properties defaultProperties = new Properties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (this.chainedProperties.getProperty((String)prop.getKey(), null) != null) continue;
            defaultProperties.put(prop.getKey(), prop.getValue());
        }
        this.chainedProperties.addProperties(defaultProperties);
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
        } else if (name.equals("drools.forceEagerActivation")) {
            this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve((String)(StringUtils.isEmpty(value) ? "false" : value)).getFilter());
        } else if (name.equals("drools.timedRuleExection")) {
            this.setTimedRuleExecutionFilter(TimedRuleExectionOption.resolve((String)(StringUtils.isEmpty(value) ? "false" : value)).getFilter());
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        } else if (name.equals("drools.timerJobFactory")) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(StringUtils.isEmpty(value) ? "default" : value));
        } else if (name.equals("drools.queryListener")) {
            this.setQueryListenerClass(StringUtils.isEmpty(value) ? QueryListenerOption.STANDARD.getAsString() : value);
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.keepReference);
        }
        if (name.equals("drools.clockType")) {
            return this.clockType.toExternalForm();
        }
        if (name.equals("drools.timerJobFactory")) {
            return this.timerJobFactoryType.toExternalForm();
        }
        if (name.equals("drools.queryListener")) {
            return this.queryListener.getAsString();
        }
        return null;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    public void setForceEagerActivationFilter(ForceEagerActivationFilter forceEagerActivationFilter) {
        this.checkCanChange();
        this.forceEagerActivationFilter = forceEagerActivationFilter;
    }

    public ForceEagerActivationFilter getForceEagerActivationFilter() {
        return this.forceEagerActivationFilter;
    }

    public void setTimedRuleExecutionFilter(TimedRuleExecutionFilter timedRuleExecutionFilter) {
        this.checkCanChange();
        this.timedRuleExecutionFilter = timedRuleExecutionFilter;
    }

    public TimedRuleExecutionFilter getTimedRuleExecutionFilter() {
        return this.timedRuleExecutionFilter;
    }

    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType;
    }

    public void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        this.checkCanChange();
        this.beliefSystemType = beliefSystemType;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    public void setClockType(ClockType clockType) {
        this.checkCanChange();
        this.clockType = clockType;
    }

    public TimerJobFactoryManager getTimerJobFactoryManager() {
        if (this.timerJobFactoryManager == null) {
            this.timerJobFactoryManager = this.getTimerJobFactoryType().createInstance();
        }
        return this.timerJobFactoryManager;
    }

    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType;
    }

    private void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        this.checkCanChange();
        this.timerJobFactoryType = timerJobFactoryType;
    }

    private void setQueryListenerClass(String property) {
        this.checkCanChange();
        this.queryListener = QueryListenerOption.determineQueryListenerClassOption((String)property);
    }

    private void setQueryListenerClass(QueryListenerOption option) {
        this.checkCanChange();
        this.queryListener = option;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(new HashMap<String, Object>());
        }
        return this.workItemHandlers;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(params);
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers(Map<String, Object> params) {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.chainedProperties.getProperty("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation, params);
        }
    }

    private void loadWorkItemHandlers(String location, Map<String, Object> params) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)MVELSafeHelper.getEvaluator().eval(content, params);
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.chainedProperties.getProperty("drools.workItemManagerFactory", "org.drools.core.process.instance.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public String getProcessInstanceManagerFactory() {
        return this.chainedProperties.getProperty("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
    }

    public String getSignalManagerFactory() {
        return this.chainedProperties.getProperty("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
    }

    public CommandService getCommandService(KnowledgeBase kbase, Environment environment) {
        if (this.commandService == null) {
            this.initCommandService(kbase, environment);
        }
        return this.commandService;
    }

    private void initCommandService(KnowledgeBase kbase, Environment environment) {
        String className = this.chainedProperties.getProperty("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.commandService = (CommandService)clazz.getConstructor(KnowledgeBase.class, KieSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    public TimerService newTimerService() {
        String className = this.chainedProperties.getProperty("drools.timerService", "org.drools.core.time.impl.JDKTimerService");
        if (className == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                return (TimerService)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate timer service '" + className + "'", e);
            }
        }
        try {
            return (TimerService)MVELSafeHelper.getEvaluator().eval(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Timer service '" + className + "' not found", e);
        }
    }

    public <T extends SingleValueKieSessionOption> T getOption(Class<T> option) {
        if (ClockTypeOption.class.equals(option)) {
            return (T)ClockTypeOption.get((String)this.getClockType().toExternalForm());
        }
        if (KeepReferenceOption.class.equals(option)) {
            return (T)(this.keepReference ? KeepReferenceOption.YES : KeepReferenceOption.NO);
        }
        if (TimerJobFactoryOption.class.equals(option)) {
            return (T)TimerJobFactoryOption.get((String)this.getTimerJobFactoryType().toExternalForm());
        }
        if (QueryListenerOption.class.equals(option)) {
            return (T)this.queryListener;
        }
        return null;
    }

    public <T extends MultiValueKieSessionOption> T getOption(Class<T> option, String key) {
        if (WorkItemHandlerOption.class.equals(option)) {
            return (T)WorkItemHandlerOption.get((String)key, (WorkItemHandler)this.getWorkItemHandlers().get(key));
        }
        return null;
    }

    public <T extends KieSessionOption> void setOption(T option) {
        if (option instanceof ClockTypeOption) {
            this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
        } else if (option instanceof TimerJobFactoryOption) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(((TimerJobFactoryOption)option).getTimerJobType()));
        } else if (option instanceof KeepReferenceOption) {
            this.setKeepReference(((KeepReferenceOption)option).isKeepReference());
        } else if (option instanceof ForceEagerActivationOption) {
            this.setForceEagerActivationFilter(((ForceEagerActivationOption)option).getFilter());
        } else if (option instanceof TimedRuleExectionOption) {
            this.setTimedRuleExecutionFilter(((TimedRuleExectionOption)option).getFilter());
        } else if (option instanceof WorkItemHandlerOption) {
            this.getWorkItemHandlers().put(((WorkItemHandlerOption)option).getName(), ((WorkItemHandlerOption)option).getHandler());
        } else if (option instanceof QueryListenerOption) {
            this.queryListener = (QueryListenerOption)option;
        }
    }

    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener;
    }
}

