/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.xml.MinimalPomParser;
import org.drools.compiler.kproject.xml.PomModel;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.PomParser;
import org.kie.scanner.embedder.EmbeddedPomParser;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

class ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    private final PomParser pomParser;
    private final MavenRepository mavenRepository;

    ArtifactResolver() {
        this.mavenRepository = MavenRepository.getMavenRepository();
        this.pomParser = new EmbeddedPomParser();
    }

    private ArtifactResolver(MavenProject mavenProject) {
        this.mavenRepository = MavenRepository.getMavenRepository(mavenProject);
        this.pomParser = new EmbeddedPomParser(mavenProject);
    }

    private ArtifactResolver(PomParser pomParser) {
        this.mavenRepository = MavenRepository.getMavenRepository();
        this.pomParser = pomParser;
    }

    Artifact resolveArtifact(ReleaseId releaseId) {
        return this.mavenRepository.resolveArtifact(releaseId);
    }

    List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        return this.mavenRepository.getArtifactDependecies(artifactName);
    }

    List<DependencyDescriptor> getPomDirectDependencies() {
        return this.pomParser.getPomDirectDependencies();
    }

    Collection<DependencyDescriptor> getAllDependecies() {
        HashSet<DependencyDescriptor> dependencies = new HashSet<DependencyDescriptor>();
        for (DependencyDescriptor dep : this.getPomDirectDependencies()) {
            dependencies.add(dep);
            dependencies.addAll(this.getArtifactDependecies(dep.toString()));
        }
        return dependencies;
    }

    public static ArtifactResolver getResolverFor(ReleaseId releaseId, boolean allowDefaultPom) {
        ArtifactResolver artifactResolver;
        File pomFile = ArtifactResolver.getPomFileForGAV(releaseId);
        if (pomFile != null && (artifactResolver = ArtifactResolver.getResolverFor(pomFile)) != null) {
            return artifactResolver;
        }
        return allowDefaultPom ? new ArtifactResolver() : null;
    }

    public static ArtifactResolver getResolverFor(URI uri) {
        return ArtifactResolver.getResolverFor(new File(uri));
    }

    public static ArtifactResolver getResolverFor(File pomFile) {
        try {
            return new ArtifactResolver(MavenProjectLoader.parseMavenPom(pomFile));
        }
        catch (RuntimeException e) {
            log.warn("Cannot use native maven pom parser, fall back to the internal one", (Throwable)e);
            InternalPomParser pomParser = ArtifactResolver.createInternalPomParser(pomFile);
            if (pomParser != null) {
                return new ArtifactResolver(pomParser);
            }
            return null;
        }
    }

    public static ArtifactResolver getResolverFor(InputStream pomStream) {
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom(pomStream);
        return new ArtifactResolver(mavenProject);
    }

    private static File getPomFileForGAV(ReleaseId releaseId) {
        String artifactName = releaseId.getGroupId() + ":" + releaseId.getArtifactId() + ":pom:" + releaseId.getVersion();
        Artifact artifact = MavenRepository.getMavenRepository().resolveArtifact(artifactName);
        return artifact != null ? artifact.getFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InternalPomParser createInternalPomParser(File pomFile) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(pomFile);
            InternalPomParser internalPomParser = new InternalPomParser(MinimalPomParser.parse((String)pomFile.getAbsolutePath(), (InputStream)fis));
            return internalPomParser;
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static class InternalPomParser
    implements PomParser {
        private final PomModel pomModel;

        private InternalPomParser(PomModel pomModel) {
            this.pomModel = pomModel;
        }

        @Override
        public List<DependencyDescriptor> getPomDirectDependencies() {
            ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
            for (ReleaseId rId : this.pomModel.getDependencies()) {
                deps.add(new DependencyDescriptor(rId));
            }
            return deps;
        }
    }
}

