/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.Aether;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.embedder.MavenSettings;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.SubArtifact;
import org.sonatype.aether.version.Version;

public class MavenRepository {
    private static MavenRepository defaultMavenRepository;
    private final Aether aether;
    private static final List<RemoteRepository> extraRepositories;

    private MavenRepository(Aether aether) {
        this.aether = aether;
    }

    public static synchronized MavenRepository getMavenRepository() {
        if (defaultMavenRepository == null) {
            Aether defaultAether = Aether.getAether();
            defaultMavenRepository = new MavenRepository(defaultAether);
            MavenRepository.initSettings();
        }
        return defaultMavenRepository;
    }

    private static void initSettings() {
        Settings settings = MavenSettings.getSettings();
        for (Profile profile : settings.getProfiles()) {
            if (!MavenRepository.isProfileActive(settings, profile)) continue;
            for (Repository repository : profile.getRepositories()) {
                MavenRepository.addExtraRepository(MavenRepository.toRemoteRepository(settings, repository));
            }
            for (Repository repository : profile.getPluginRepositories()) {
                MavenRepository.addExtraRepository(MavenRepository.toRemoteRepository(settings, repository));
            }
        }
    }

    private static boolean isProfileActive(Settings settings, Profile profile) {
        return settings.getActiveProfiles().contains(profile.getId()) || profile.getActivation() != null && profile.getActivation().isActiveByDefault();
    }

    private static RemoteRepository toRemoteRepository(Settings settings, Repository repository) {
        RemoteRepository remote = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        MavenRepository.setPolicy(remote, repository.getSnapshots(), true);
        MavenRepository.setPolicy(remote, repository.getReleases(), false);
        Server server = settings.getServer(repository.getId());
        if (server != null) {
            remote.setAuthentication(new Authentication(server.getUsername(), server.getPassword()));
        }
        return remote;
    }

    private static void setPolicy(RemoteRepository remote, RepositoryPolicy policy, boolean snapshot) {
        if (policy != null) {
            remote.setPolicy(snapshot, new org.sonatype.aether.repository.RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()));
        }
    }

    public static void addExtraRepository(RemoteRepository r) {
        extraRepositories.add(r);
    }

    public static List<RemoteRepository> getExtraRepositories() {
        return extraRepositories;
    }

    public static void clearExtraRepositories() {
        extraRepositories.clear();
    }

    public static MavenRepository getMavenRepository(MavenProject mavenProject) {
        return new MavenRepository(new Aether(mavenProject));
    }

    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        CollectResult collectResult;
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        CollectRequest collectRequest = new CollectRequest();
        Dependency root = new Dependency((Artifact)artifact, "");
        collectRequest.setRoot(root);
        for (RemoteRepository repo : this.aether.getRepositories()) {
            collectRequest.addRepository(repo);
        }
        for (RemoteRepository repo : extraRepositories) {
            collectRequest.addRepository(repo);
        }
        try {
            collectResult = this.aether.getSystem().collectDependencies(this.aether.getSession(), collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        CollectDependencyVisitor visitor = new CollectDependencyVisitor();
        collectResult.getRoot().accept((DependencyVisitor)visitor);
        ArrayList<DependencyDescriptor> descriptors = new ArrayList<DependencyDescriptor>();
        for (DependencyNode node : visitor.getDependencies()) {
            if (node.getDependency().equals((Object)root)) continue;
            descriptors.add(new DependencyDescriptor(node.getDependency().getArtifact()));
        }
        return descriptors;
    }

    public Artifact resolveArtifact(ReleaseId releaseId) {
        String artifactName = releaseId.toString();
        if (DependencyDescriptor.isRangedVersion(releaseId.getVersion())) {
            Version v = this.resolveVersion(artifactName);
            if (v == null) {
                return null;
            }
            artifactName = releaseId.getGroupId() + ":" + releaseId.getArtifactId() + ":" + v;
        }
        return this.resolveArtifact(artifactName);
    }

    public Artifact resolveArtifact(String artifactName) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        for (RemoteRepository repo : this.aether.getRepositories()) {
            artifactRequest.addRepository(repo);
        }
        for (RemoteRepository repo : extraRepositories) {
            artifactRequest.addRepository(repo);
        }
        try {
            ArtifactResult artifactResult = this.aether.getSystem().resolveArtifact(this.aether.getSession(), artifactRequest);
            return artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            return null;
        }
    }

    public Version resolveVersion(String artifactName) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        VersionRangeRequest versionRequest = new VersionRangeRequest();
        versionRequest.setArtifact((Artifact)artifact);
        for (RemoteRepository repo : this.aether.getRepositories()) {
            versionRequest.addRepository(repo);
        }
        for (RemoteRepository repo : extraRepositories) {
            versionRequest.addRepository(repo);
        }
        try {
            VersionRangeResult versionRangeResult = this.aether.getSystem().resolveVersionRange(this.aether.getSession(), versionRequest);
            return versionRangeResult.getHighestVersion();
        }
        catch (VersionRangeResolutionException e) {
            return null;
        }
    }

    public void deployArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".jar");
        try {
            FileOutputStream fos = new FileOutputStream(jarFile);
            fos.write(kieModule.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployArtifact(releaseId, jarFile, pomfile);
    }

    public void deployArtifact(ReleaseId releaseId, byte[] jarContent, byte[] pomContent) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".jar");
        try {
            FileOutputStream fos = new FileOutputStream(jarFile);
            fos.write(jarContent);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomContent);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployArtifact(releaseId, jarFile, pomFile);
    }

    public void deployArtifact(ReleaseId releaseId, File jar, File pomfile) {
        DefaultArtifact jarArtifact = new DefaultArtifact(releaseId.getGroupId(), releaseId.getArtifactId(), "jar", releaseId.getVersion());
        jarArtifact = jarArtifact.setFile(jar);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomArtifact).setRepository(this.aether.getLocalRepository());
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void deployPomArtifact(String groupId, String artifactId, String version, File pomfile) {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact((Artifact)pomArtifact).setRepository(this.aether.getLocalRepository());
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFileName(ReleaseId releaseId, String classifier) {
        if (classifier != null) {
            return releaseId.getArtifactId() + "-" + releaseId.getVersion() + "-" + classifier;
        }
        return releaseId.getArtifactId() + "-" + releaseId.getVersion();
    }

    static {
        extraRepositories = new ArrayList<RemoteRepository>();
    }

    private static class CollectDependencyVisitor
    implements DependencyVisitor {
        private final List<DependencyNode> dependencies = new ArrayList<DependencyNode>();

        private CollectDependencyVisitor() {
        }

        public boolean visitEnter(DependencyNode node) {
            this.dependencies.add(node);
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        public List<DependencyNode> getDependencies() {
            return this.dependencies;
        }
    }
}

