/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.internal.command.Context;

@XmlRootElement(name="task-composite-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CompositeCommand<T>
extends TaskCommand<T> {
    private static final long serialVersionUID = -5591247478243819049L;
    @XmlElement
    private TaskCommand<T> mainCommand;
    @XmlElement
    private TaskCommand<?>[] commands;

    public CompositeCommand() {
    }

    public CompositeCommand(TaskCommand<T> mainCommand, TaskCommand<?> ... commands) {
        this.mainCommand = mainCommand;
        this.commands = commands;
    }

    public T execute(Context context) {
        if (this.commands != null) {
            for (TaskCommand<?> cmd : this.commands) {
                cmd.execute(context);
            }
        }
        return (T)this.mainCommand.execute(context);
    }

    public TaskCommand<T> getMainCommand() {
        return this.mainCommand;
    }

    public void setMainCommand(TaskCommand<T> mainCommand) {
        this.mainCommand = mainCommand;
    }

    public TaskCommand<?>[] getCommands() {
        return this.commands;
    }

    public void setCommands(TaskCommand<?>[] commands) {
        this.commands = commands;
    }

    @Override
    public Long getTaskId() {
        if (this.mainCommand != null) {
            return this.mainCommand.getTaskId();
        }
        return this.taskId;
    }
}

