/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASUserGroupCallbackImpl
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(JAASUserGroupCallbackImpl.class);
    protected static final String DEFAULT_PROPERTIES_NAME = "/jbpm.usergroup.callback.properties";
    private ServiceLoader<UserGroupAdapter> ugAdapterServiceLoader = ServiceLoader.load(UserGroupAdapter.class);
    private String rolePrincipleName = null;

    public JAASUserGroupCallbackImpl(boolean activate) {
        this("Roles");
        InputStream in;
        String propertiesLocation = System.getProperty("jbpm.usergroup.callback.properties");
        if (propertiesLocation == null) {
            propertiesLocation = DEFAULT_PROPERTIES_NAME;
        }
        if ((in = this.getClass().getResourceAsStream(propertiesLocation)) != null) {
            Properties config = new Properties();
            try {
                config.load(in);
                this.rolePrincipleName = config.getProperty("jaas.role.principle.name");
            }
            catch (IOException e) {
                logger.error("Error when loading properties for JAAS user group callback", (Throwable)e);
                config = null;
            }
        }
    }

    public JAASUserGroupCallbackImpl(String rolesPrincipleName) {
        this.rolePrincipleName = rolesPrincipleName;
    }

    public String getRolePrincipleName() {
        return this.rolePrincipleName;
    }

    public void setRolePrincipleName(String rolePrincipleName) {
        this.rolePrincipleName = rolePrincipleName;
    }

    public boolean existsUser(String userId) {
        return true;
    }

    public boolean existsGroup(String groupId) {
        return true;
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        ArrayList<String> roles;
        block6: {
            roles = new ArrayList<String>();
            try {
                Subject subject = this.getSubjectFromContainer();
                if (subject != null) {
                    Set<Principal> principals = subject.getPrincipals();
                    if (principals == null) break block6;
                    roles = new ArrayList();
                    for (Principal principal : principals) {
                        if (!(principal instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(principal.getName())) continue;
                        Enumeration groups = ((Group)principal).members();
                        while (groups.hasMoreElements()) {
                            Principal groupPrincipal = (Principal)groups.nextElement();
                            roles.add(groupPrincipal.getName());
                        }
                        break block6;
                    }
                    break block6;
                }
                for (UserGroupAdapter adapter : this.ugAdapterServiceLoader) {
                    List<String> userRoles = adapter.getGroupsForUser(userId);
                    if (userRoles == null) continue;
                    roles.addAll(userRoles);
                }
            }
            catch (Exception e) {
                logger.error("Error when getting user roles, userid:" + userId, (Throwable)e);
            }
        }
        return roles;
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }
}

