/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.services.task.exception.IllegalTaskStateException;
import org.jbpm.services.task.impl.model.AttachmentImpl;
import org.jbpm.services.task.impl.model.CommentImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.CollectionUtils;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.InternalTaskData;

@Embeddable
public class TaskDataImpl
implements InternalTaskData {
    @Enumerated(value=EnumType.STRING)
    private Status status = Status.Created;
    private Status previousStatus = null;
    @ManyToOne(targetEntity=UserImpl.class)
    private User actualOwner;
    @ManyToOne(targetEntity=UserImpl.class)
    private User createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date activationTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expirationTime;
    private boolean skipable;
    private long workItemId = -1L;
    private long processInstanceId = -1L;
    private AccessType documentAccessType;
    private String documentType;
    private long documentContentId = -1L;
    private AccessType outputAccessType;
    private String outputType;
    private long outputContentId = -1L;
    private String faultName;
    private AccessType faultAccessType;
    private String faultType;
    private long faultContentId = -1L;
    private long parentId = -1L;
    private String processId;
    private String deploymentId;
    private int processSessionId;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=CommentImpl.class)
    @JoinColumn(name="TaskData_Comments_Id", nullable=true)
    private List<Comment> comments = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=AttachmentImpl.class)
    @JoinColumn(name="TaskData_Attachments_Id", nullable=true)
    private List<Attachment> attachments = Collections.emptyList();

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.status != null) {
            out.writeBoolean(true);
            out.writeUTF(this.status.toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.previousStatus != null) {
            out.writeBoolean(true);
            out.writeUTF(this.previousStatus.toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.actualOwner != null) {
            out.writeBoolean(true);
            this.actualOwner.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdBy != null) {
            out.writeBoolean(true);
            this.createdBy.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdOn != null) {
            out.writeBoolean(true);
            out.writeLong(this.createdOn.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.activationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.activationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.expirationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.expirationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.skipable);
        if (this.workItemId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.workItemId);
        } else {
            out.writeBoolean(false);
        }
        if (this.processInstanceId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.processInstanceId);
        } else {
            out.writeBoolean(false);
        }
        if (this.documentAccessType != null) {
            out.writeBoolean(true);
            out.writeObject(this.documentAccessType);
        } else {
            out.writeBoolean(false);
        }
        if (this.documentType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.documentType);
        } else {
            out.writeBoolean(false);
        }
        if (this.documentContentId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.documentContentId);
        } else {
            out.writeBoolean(false);
        }
        if (this.outputAccessType != null) {
            out.writeBoolean(true);
            out.writeObject(this.outputAccessType);
        } else {
            out.writeBoolean(false);
        }
        if (this.outputType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.outputType);
        } else {
            out.writeBoolean(false);
        }
        if (this.outputContentId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.outputContentId);
        } else {
            out.writeBoolean(false);
        }
        if (this.faultName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.faultName);
        } else {
            out.writeBoolean(false);
        }
        if (this.faultAccessType != null) {
            out.writeBoolean(true);
            out.writeObject(this.faultAccessType);
        } else {
            out.writeBoolean(false);
        }
        if (this.faultType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.faultType);
        } else {
            out.writeBoolean(false);
        }
        if (this.faultContentId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.faultContentId);
        } else {
            out.writeBoolean(false);
        }
        if (this.parentId != -1L) {
            out.writeBoolean(true);
            out.writeLong(this.parentId);
        } else {
            out.writeBoolean(false);
        }
        if (this.processId != null) {
            out.writeBoolean(true);
            out.writeUTF(this.processId);
        } else {
            out.writeBoolean(false);
        }
        if (this.processSessionId != -1) {
            out.writeBoolean(true);
            out.writeInt(this.processSessionId);
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeCommentList(this.comments, out);
        CollectionUtils.writeAttachmentList(this.attachments, out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.status = Status.valueOf((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.previousStatus = Status.valueOf((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.actualOwner = new UserImpl();
            this.actualOwner.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdBy = new UserImpl();
            this.createdBy.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdOn = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.activationTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.expirationTime = new Date(in.readLong());
        }
        this.skipable = in.readBoolean();
        if (in.readBoolean()) {
            this.workItemId = in.readLong();
        }
        if (in.readBoolean()) {
            this.processInstanceId = in.readLong();
        }
        if (in.readBoolean()) {
            this.documentAccessType = (AccessType)in.readObject();
        }
        if (in.readBoolean()) {
            this.documentType = in.readUTF();
        }
        if (in.readBoolean()) {
            this.documentContentId = in.readLong();
        }
        if (in.readBoolean()) {
            this.outputAccessType = (AccessType)in.readObject();
        }
        if (in.readBoolean()) {
            this.outputType = in.readUTF();
        }
        if (in.readBoolean()) {
            this.outputContentId = in.readLong();
        }
        if (in.readBoolean()) {
            this.faultName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.faultAccessType = (AccessType)in.readObject();
        }
        if (in.readBoolean()) {
            this.faultType = in.readUTF();
        }
        if (in.readBoolean()) {
            this.faultContentId = in.readLong();
        }
        if (in.readBoolean()) {
            this.parentId = in.readLong();
        }
        if (in.readBoolean()) {
            this.processId = in.readUTF();
        }
        if (in.readBoolean()) {
            this.processSessionId = in.readInt();
        }
        this.comments = CollectionUtils.readCommentList(in);
        this.attachments = CollectionUtils.readAttachmentList(in);
    }

    public Status initialize() {
        Date createdOn = this.getCreatedOn();
        if (createdOn == null) {
            createdOn = new Date();
            this.setCreatedOn(createdOn);
        }
        if (this.getActivationTime() == null) {
            this.setActivationTime(createdOn);
        }
        this.setStatus(Status.Created);
        return Status.Created;
    }

    public Status assignOwnerAndStatus(List<OrganizationalEntity> potentialOwners) {
        if (this.getStatus() != Status.Created) {
            throw new IllegalTaskStateException("Can only assign task owner if status is Created!");
        }
        Status assignedStatus = null;
        if (potentialOwners.size() == 1) {
            OrganizationalEntity potentialOwner = potentialOwners.get(0);
            if (potentialOwner instanceof User) {
                this.setActualOwner((User)potentialOwner);
                assignedStatus = Status.Reserved;
            }
            if (potentialOwner instanceof Group) {
                assignedStatus = Status.Ready;
            }
        } else if (potentialOwners.size() > 1) {
            assignedStatus = Status.Ready;
        }
        if (assignedStatus != null) {
            this.setStatus(assignedStatus);
        } else {
            assignedStatus = this.getStatus();
        }
        return assignedStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.previousStatus = this.status;
        this.status = status;
    }

    public Status getPreviousStatus() {
        return this.previousStatus;
    }

    public void setPreviousStatus(Status previousStatus) {
        this.previousStatus = previousStatus;
    }

    public User getActualOwner() {
        return this.actualOwner;
    }

    public void setActualOwner(User actualOwner) {
        this.actualOwner = TaskDataImpl.convertToUserImpl(actualOwner);
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = TaskDataImpl.convertToUserImpl(createdBy);
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(boolean isSkipable) {
        this.skipable = isSkipable;
    }

    public void setWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(int processSessionId) {
        this.processSessionId = processSessionId;
    }

    public void setDocument(long documentID, ContentData documentConentData) {
        this.setDocumentContentId(documentID);
        this.setDocumentAccessType(documentConentData.getAccessType());
        this.setDocumentType(documentConentData.getType());
    }

    public AccessType getDocumentAccessType() {
        return this.documentAccessType;
    }

    public void setDocumentAccessType(AccessType accessType) {
        this.documentAccessType = accessType;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public long getDocumentContentId() {
        return this.documentContentId;
    }

    public void setDocumentContentId(long documentContentId) {
        this.documentContentId = documentContentId;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setOutput(long outputContentId, ContentData outputContentData) {
        this.setOutputContentId(outputContentId);
        this.setOutputAccessType(outputContentData.getAccessType());
        this.setOutputType(outputContentData.getType());
    }

    public AccessType getOutputAccessType() {
        return this.outputAccessType;
    }

    public void setOutputAccessType(AccessType outputAccessType) {
        this.outputAccessType = outputAccessType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public long getOutputContentId() {
        return this.outputContentId;
    }

    public void setOutputContentId(long outputContentId) {
        this.outputContentId = outputContentId;
    }

    public void setFault(long faultContentId, FaultData faultData) {
        this.setFaultContentId(faultContentId);
        this.setFaultAccessType(faultData.getAccessType());
        this.setFaultType(faultData.getType());
        this.setFaultName(faultData.getFaultName());
    }

    public String getFaultName() {
        return this.faultName;
    }

    public void setFaultName(String faultName) {
        this.faultName = faultName;
    }

    public AccessType getFaultAccessType() {
        return this.faultAccessType;
    }

    public void setFaultAccessType(AccessType faultAccessType) {
        this.faultAccessType = faultAccessType;
    }

    public String getFaultType() {
        return this.faultType;
    }

    public void setFaultType(String faultType) {
        this.faultType = faultType;
    }

    public long getFaultContentId() {
        return this.faultContentId;
    }

    public void setFaultContentId(long faultContentId) {
        this.faultContentId = faultContentId;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        if (this.comments == null || this.comments.size() == 0) {
            this.comments = new ArrayList<Comment>();
        }
        this.comments.add((Comment)((CommentImpl)comment));
    }

    public Comment removeComment(long commentId) {
        Comment removedComment = null;
        if (this.comments != null) {
            for (int index = this.comments.size() - 1; index >= 0; --index) {
                Comment currentComment = this.comments.get(index);
                if (currentComment.getId() != commentId) continue;
                removedComment = this.comments.remove(index);
                break;
            }
        }
        return removedComment;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(Attachment attachment) {
        if (this.attachments == null || this.attachments == Collections.emptyList()) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add((Attachment)((AttachmentImpl)attachment));
    }

    public Attachment removeAttachment(long attachmentId) {
        Attachment removedAttachment = null;
        if (this.attachments != null) {
            for (int index = this.attachments.size() - 1; index >= 0; --index) {
                Attachment currentAttachment = this.attachments.get(index);
                if (currentAttachment.getId() != attachmentId) continue;
                removedAttachment = this.attachments.remove(index);
                break;
            }
        }
        return removedAttachment;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.attachments);
        result = 31 * result + CollectionUtils.hashCode(this.comments);
        result = 31 * result + (this.createdOn == null ? 0 : this.createdOn.hashCode());
        result = 31 * result + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        result = 31 * result + (this.skipable ? 1231 : 1237);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.previousStatus == null ? 0 : this.previousStatus.hashCode());
        result = 31 * result + (this.workItemId == -1L ? 0 : (int)this.workItemId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskDataImpl)) {
            return false;
        }
        TaskDataImpl other = (TaskDataImpl)obj;
        if (this.actualOwner == null ? other.actualOwner != null : !this.actualOwner.equals(other.actualOwner)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdOn == null ? other.createdOn != null : this.createdOn.getTime() != other.createdOn.getTime()) {
            return false;
        }
        if (this.expirationTime == null ? other.expirationTime != null : this.expirationTime.getTime() != other.expirationTime.getTime()) {
            return false;
        }
        if (this.skipable != other.skipable) {
            return false;
        }
        if (this.workItemId != other.workItemId) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.previousStatus == null ? other.previousStatus != null : !this.previousStatus.equals((Object)other.previousStatus)) {
            return false;
        }
        if (this.activationTime == null ? other.activationTime != null : this.activationTime.getTime() != other.activationTime.getTime()) {
            return false;
        }
        if (this.workItemId != other.workItemId) {
            return false;
        }
        if (this.documentAccessType == null ? other.documentAccessType != null : !this.documentAccessType.equals((Object)other.documentAccessType)) {
            return false;
        }
        if (this.documentContentId != other.documentContentId) {
            return false;
        }
        if (this.documentType == null ? other.documentType != null : !this.documentType.equals(other.documentType)) {
            return false;
        }
        if (this.parentId != other.parentId) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processSessionId != other.processSessionId) {
            return false;
        }
        if (this.deploymentId == null ? other.deploymentId != null : !this.deploymentId.equals(other.deploymentId)) {
            return false;
        }
        return CollectionUtils.equals(this.attachments, other.attachments) && CollectionUtils.equals(this.comments, other.comments);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    static UserImpl convertToUserImpl(User user) {
        if (user == null) {
            return null;
        }
        if (user instanceof UserImpl) {
            return (UserImpl)user;
        }
        return new UserImpl(user.getId());
    }

    static GroupImpl convertToGroupImpl(GroupImpl group) {
        if (group == null) {
            return null;
        }
        if (group instanceof GroupImpl) {
            return group;
        }
        return new GroupImpl(group.getId());
    }
}

