/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;

@XmlRootElement(name="organizational-entity")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbOrganizationalEntity
implements OrganizationalEntity {
    @XmlElement
    @XmlSchemaType(name="string")
    private String id;
    @XmlElement
    private Type type;

    public JaxbOrganizationalEntity() {
    }

    public JaxbOrganizationalEntity(OrganizationalEntity orgEntity) {
        this.id = orgEntity.getId();
        if (orgEntity instanceof User) {
            this.type = Type.USER;
        } else if (orgEntity instanceof Group) {
            this.type = Type.GROUP;
        } else if (orgEntity instanceof JaxbOrganizationalEntity) {
            this.type = ((JaxbOrganizationalEntity)orgEntity).type;
        } else {
            throw new IllegalArgumentException("Unknown type of organizational entity: " + orgEntity.getClass().getSimpleName());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractJaxbTaskObject.unsupported(OrganizationalEntity.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(OrganizationalEntity.class);
    }

    public static List<JaxbOrganizationalEntity> convertListFromInterfaceToJaxbImpl(List<OrganizationalEntity> jaxbList) {
        ArrayList<JaxbOrganizationalEntity> jaxbOrgEntList = new ArrayList<JaxbOrganizationalEntity>(jaxbList.size());
        if (jaxbList != null) {
            for (OrganizationalEntity jaxb : jaxbList) {
                jaxbOrgEntList.add(new JaxbOrganizationalEntity(jaxb));
            }
        }
        return jaxbOrgEntList;
    }

    public static List<OrganizationalEntity> convertListFromJaxbImplToInterface(List<JaxbOrganizationalEntity> jaxbList) {
        ArrayList<OrganizationalEntity> list = new ArrayList<OrganizationalEntity>(jaxbList.size());
        if (jaxbList != null) {
            for (JaxbOrganizationalEntity jaxb : jaxbList) {
                list.add(jaxb.createImplInstance());
            }
        }
        return list;
    }

    private OrganizationalEntity createImplInstance() {
        switch (this.type) {
            case GROUP: {
                return new AbstractJaxbTaskObject.GetterGroup(this.id);
            }
            case USER: {
                return new AbstractJaxbTaskObject.GetterUser(this.id);
            }
        }
        throw new IllegalStateException("Unknown organizational type: " + (Object)((Object)this.type));
    }

    @XmlEnum
    public static enum Type {
        USER,
        GROUP;

    }
}

