/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.JaxbDeadlines;
import org.jbpm.services.task.impl.model.xml.JaxbI18NText;
import org.jbpm.services.task.impl.model.xml.JaxbPeopleAssignments;
import org.jbpm.services.task.impl.model.xml.JaxbTaskData;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Delegation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbTask
implements InternalTask {
    @XmlElement
    @XmlSchemaType(name="long")
    private Long id;
    @XmlElement
    @XmlSchemaType(name="long")
    private Integer priority;
    @XmlElement(name="task-type")
    @XmlSchemaType(name="int")
    private String taskType;
    @XmlElement(name="name")
    private List<JaxbI18NText> names;
    @XmlElement(name="subject")
    private List<JaxbI18NText> subjects;
    @XmlElement(name="description")
    private List<JaxbI18NText> descriptions;
    @XmlElement(name="people-assignments")
    private JaxbPeopleAssignments peopleAssignments;
    @XmlElement
    private JaxbTaskData taskData;
    @XmlElement
    private JaxbDeadlines deadlines = new JaxbDeadlines();
    @XmlElement(name="form-name")
    @XmlSchemaType(name="String")
    private String formName;

    public JaxbTask() {
    }

    public JaxbTask(Task task) {
        this.initialize(task);
    }

    public void initialize(Task task) {
        if (task == null) {
            return;
        }
        this.id = task.getId();
        this.priority = task.getPriority();
        this.peopleAssignments = new JaxbPeopleAssignments(task.getPeopleAssignments());
        this.names = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getNames());
        this.subjects = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getSubjects());
        this.descriptions = JaxbI18NText.convertListFromInterfaceToJaxbImpl(task.getDescriptions());
        this.taskData = new JaxbTaskData(task.getTaskData());
        this.taskType = task.getTaskType();
        this.formName = ((InternalTask)task).getFormName();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<I18NText> getNames() {
        if (this.names == null) {
            this.names = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.names));
    }

    public void setNames(List<I18NText> names) {
        this.names = JaxbI18NText.convertListFromInterfaceToJaxbImpl(names);
    }

    public List<I18NText> getSubjects() {
        if (this.subjects == null) {
            this.subjects = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.subjects));
    }

    public void setSubjects(List<I18NText> subjects) {
        this.subjects = JaxbI18NText.convertListFromInterfaceToJaxbImpl(subjects);
    }

    public List<I18NText> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = Collections.emptyList();
        }
        return Collections.unmodifiableList(JaxbI18NText.convertListFromJaxbImplToInterface(this.descriptions));
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.descriptions = JaxbI18NText.convertListFromInterfaceToJaxbImpl(descriptions);
    }

    public PeopleAssignments getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public void setPeopleAssignments(PeopleAssignments peopleAssignments) {
        this.peopleAssignments = peopleAssignments instanceof JaxbPeopleAssignments ? (JaxbPeopleAssignments)peopleAssignments : new JaxbPeopleAssignments(peopleAssignments);
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public void setTaskData(TaskData taskData) {
        this.taskData = taskData instanceof JaxbTaskData ? (JaxbTaskData)taskData : new JaxbTaskData(taskData);
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Deadlines getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(Deadlines deadlines) {
    }

    public Task getTask() {
        Task taskImpl = TaskModelProvider.getFactory().newTask();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        for (I18NText n : this.getNames()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setNames(names);
        ArrayList descriptions = new ArrayList();
        for (I18NText n : this.getDescriptions()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setDescriptions(descriptions);
        ArrayList subjects = new ArrayList();
        for (I18NText n : this.getSubjects()) {
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(n.getLanguage());
            ((InternalI18NText)text).setText(n.getText());
            names.add(text);
        }
        ((InternalTask)taskImpl).setSubjects(subjects);
        ((InternalTask)taskImpl).setPriority(this.getPriority());
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(this.getTaskData().getWorkItemId());
        taskData.setProcessInstanceId(this.getTaskData().getProcessInstanceId());
        taskData.setProcessId(this.getTaskData().getProcessId());
        taskData.setProcessSessionId(this.getTaskData().getProcessSessionId());
        taskData.setSkipable(this.getTaskData().isSkipable());
        PeopleAssignments peopleAssignments = TaskModelProvider.getFactory().newPeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getPotentialOwners()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                potentialOwners.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            potentialOwners.add(group);
        }
        ((InternalPeopleAssignments)peopleAssignments).setPotentialOwners(potentialOwners);
        ArrayList<Object> businessAdmins = new ArrayList<Object>();
        for (OrganizationalEntity e : this.getPeopleAssignments().getBusinessAdministrators()) {
            if (e instanceof User) {
                User user = TaskModelProvider.getFactory().newUser();
                ((InternalOrganizationalEntity)user).setId(e.getId());
                businessAdmins.add(user);
                continue;
            }
            if (!(e instanceof Group)) continue;
            Group group = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)group).setId(e.getId());
            businessAdmins.add(group);
        }
        if (this.getPeopleAssignments().getTaskInitiator() != null) {
            User user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(this.getPeopleAssignments().getTaskInitiator().getId());
            ((InternalPeopleAssignments)peopleAssignments).setTaskInitiator(user);
        }
        ((InternalPeopleAssignments)peopleAssignments).setBusinessAdministrators(businessAdmins);
        ((InternalPeopleAssignments)peopleAssignments).setExcludedOwners(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setRecipients(new ArrayList());
        ((InternalPeopleAssignments)peopleAssignments).setTaskStakeholders(new ArrayList());
        ((InternalTask)taskImpl).setPeopleAssignments(peopleAssignments);
        ((InternalTask)taskImpl).setTaskData((TaskData)taskData);
        return taskImpl;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFormName() {
        return this.formName;
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public Boolean isArchived() {
        return (Boolean)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setArchived(Boolean archived) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setVersion(Integer version) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public int getVersion() {
        return (Integer)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public Delegation getDelegation() {
        return (Delegation)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setDelegation(Delegation delegation) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public Short getArchived() {
        return (Short)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return (SubTasksStrategy)AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }
}

