/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.JaxbAttachment;
import org.jbpm.services.task.impl.model.xml.JaxbComment;
import org.jbpm.services.task.impl.model.xml.adapter.StatusXmlAdapter;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;

@XmlRootElement(name="task-data")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={JaxbComment.class, JaxbAttachment.class})
public class JaxbTaskData
extends AbstractJaxbTaskObject<TaskData>
implements TaskData {
    @XmlElement
    @XmlJavaTypeAdapter(value=StatusXmlAdapter.class)
    private Status status;
    @XmlElement(name="previous-status")
    @XmlJavaTypeAdapter(value=StatusXmlAdapter.class)
    private Status previousStatus;
    @XmlElement(name="actual-owner")
    private String actualOwner;
    @XmlElement(name="created-by")
    private String createdBy;
    @XmlElement(name="created-on")
    @XmlSchemaType(name="dateTime")
    private Date createdOn;
    @XmlElement(name="activation-time")
    @XmlSchemaType(name="dateTime")
    private Date activationTime;
    @XmlElement(name="expiration-time")
    @XmlSchemaType(name="dateTime")
    private Date expirationTime;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean skipable;
    @XmlElement(name="work-item-id")
    @XmlSchemaType(name="long")
    private Long workItemId;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlElement(name="document-type")
    @XmlSchemaType(name="String")
    private String documentType;
    @XmlElement(name="document-content-id")
    @XmlSchemaType(name="long")
    private Long documentContentId;
    @XmlElement(name="output-type")
    @XmlSchemaType(name="String")
    private String outputType;
    @XmlElement(name="output-content-id")
    @XmlSchemaType(name="long")
    private Long outputContentId;
    @XmlElement(name="fault-name")
    @XmlSchemaType(name="String")
    private String faultName;
    @XmlElement(name="fault-type")
    @XmlSchemaType(name="String")
    private String faultType;
    @XmlElement(name="fault-content-id")
    @XmlSchemaType(name="long")
    private Long faultContentId;
    @XmlElement(name="parent-id")
    @XmlSchemaType(name="long")
    private Long parentId;
    @XmlElement(name="process-id")
    @XmlSchemaType(name="String")
    private String processId;
    @XmlElement(name="process-session-id")
    @XmlSchemaType(name="int")
    private Integer processSessionId;
    @XmlElement(name="comment")
    private List<JaxbComment> comments;
    @XmlElement(name="attachment")
    private List<JaxbAttachment> attachments;
    @XmlElement(name="deployment-id")
    @XmlSchemaType(name="String")
    private String deploymentId;

    public JaxbTaskData() {
        super(TaskData.class);
    }

    public JaxbTaskData(TaskData taskData) {
        super(taskData, TaskData.class);
        User actualOwnerUser;
        User createdByUser = taskData.getCreatedBy();
        if (createdByUser != null) {
            this.createdBy = createdByUser.getId();
        }
        if ((actualOwnerUser = taskData.getActualOwner()) != null) {
            this.actualOwner = actualOwnerUser.getId();
        }
        ArrayList<JaxbComment> commentList = new ArrayList<JaxbComment>();
        for (Comment comment : taskData.getComments()) {
            commentList.add(new JaxbComment(comment));
        }
        this.comments = commentList;
        ArrayList<JaxbAttachment> attachList = new ArrayList<JaxbAttachment>();
        for (Attachment attach : taskData.getAttachments()) {
            attachList.add(new JaxbAttachment(attach));
        }
        this.attachments = attachList;
    }

    public Status getStatus() {
        return this.status;
    }

    public Status getPreviousStatus() {
        return this.previousStatus;
    }

    public User getActualOwner() {
        return new AbstractJaxbTaskObject.GetterUser(this.actualOwner);
    }

    public User getCreatedBy() {
        return new AbstractJaxbTaskObject.GetterUser(this.createdBy);
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isSkipable() {
        return this.skipable;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public int getProcessSessionId() {
        return this.processSessionId;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public long getDocumentContentId() {
        return this.documentContentId;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public long getOutputContentId() {
        return this.outputContentId;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public String getFaultType() {
        return this.faultType;
    }

    public long getFaultContentId() {
        return this.faultContentId;
    }

    public List<Comment> getComments() {
        ArrayList<JaxbComment> commentList = new ArrayList<JaxbComment>();
        if (this.comments != null) {
            for (JaxbComment jaxbComment : this.comments) {
                commentList.add(jaxbComment);
            }
        }
        return Collections.unmodifiableList(commentList);
    }

    public List<Attachment> getAttachments() {
        ArrayList<JaxbAttachment> attachmentList = new ArrayList<JaxbAttachment>();
        if (this.attachments != null) {
            for (JaxbAttachment jaxbAttachment : this.attachments) {
                attachmentList.add(jaxbAttachment);
            }
        }
        return Collections.unmodifiableList(attachmentList);
    }

    public long getParentId() {
        return this.parentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }
}

