/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jbpm.services.task.impl.model.xml.adapter.StatusXmlAdapter;
import org.jbpm.services.task.impl.model.xml.adapter.SubTasksStrategyXmlAdapter;
import org.jbpm.services.task.impl.model.xml.adapter.UserXmlAdapter;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalTaskSummary;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="task-summary")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={Status.class, SubTasksStrategy.class})
public class TaskSummaryImpl
implements InternalTaskSummary {
    @XmlElement
    @XmlSchemaType(name="long")
    private long id;
    @XmlElement
    @XmlSchemaType(name="string")
    private String name;
    @XmlElement
    @XmlSchemaType(name="string")
    private String subject;
    @XmlElement
    @XmlSchemaType(name="string")
    private String description;
    @XmlElement
    @XmlJavaTypeAdapter(value=StatusXmlAdapter.class, type=Status.class)
    private Status status;
    @XmlElement
    @XmlSchemaType(name="int")
    private int priority;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private boolean skipable;
    @XmlElement(name="actual-owner")
    @XmlJavaTypeAdapter(value=UserXmlAdapter.class, type=User.class)
    private User actualOwner;
    @XmlElement(name="created-by")
    @XmlJavaTypeAdapter(value=UserXmlAdapter.class, type=User.class)
    private User createdBy;
    @XmlElement(name="created-on")
    @XmlSchemaType(name="dateTime")
    private Date createdOn;
    @XmlElement(name="activation-time")
    @XmlSchemaType(name="dateTime")
    private Date activationTime;
    @XmlElement(name="expiration-time")
    @XmlSchemaType(name="dateTime")
    private Date expirationTime;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private long processInstanceId;
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement(name="process-session-id")
    @XmlSchemaType(name="int")
    private int processSessionId;
    @XmlElement(name="sub-task-strategy")
    @XmlJavaTypeAdapter(value=SubTasksStrategyXmlAdapter.class, type=SubTasksStrategy.class)
    private SubTasksStrategy subTaskStrategy;
    @XmlElement(name="parent-id")
    @XmlSchemaType(name="long")
    private long parentId;
    @XmlElement(name="potential-owner")
    private List<String> potentialOwners;

    public TaskSummaryImpl(long id, long processInstanceId, String name, String subject, String description, Status status, int priority, boolean skipable, User actualOwner, User createdBy, Date createdOn, Date activationTime, Date expirationTime, String processId, int processSessionId, SubTasksStrategy subTaskStrategy, long parentId) {
        this.id = id;
        this.processInstanceId = processInstanceId;
        this.name = name;
        this.subject = subject;
        this.description = description;
        this.status = status;
        this.priority = priority;
        this.skipable = skipable;
        this.actualOwner = actualOwner;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.activationTime = activationTime;
        this.expirationTime = expirationTime;
        this.processId = processId;
        this.processSessionId = processSessionId;
        this.subTaskStrategy = subTaskStrategy;
        this.parentId = parentId;
    }

    public TaskSummaryImpl() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.processInstanceId);
        if (this.name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.name);
        } else {
            out.writeBoolean(false);
        }
        if (this.subject != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subject);
        } else {
            out.writeBoolean(false);
        }
        if (this.description != null) {
            out.writeBoolean(true);
            out.writeUTF(this.description);
        } else {
            out.writeBoolean(false);
        }
        if (this.status != null) {
            out.writeBoolean(true);
            out.writeUTF(this.status.toString());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.priority);
        out.writeLong(this.parentId);
        out.writeBoolean(this.skipable);
        if (this.actualOwner != null) {
            out.writeBoolean(true);
            this.actualOwner.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdBy != null) {
            out.writeBoolean(true);
            this.createdBy.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.createdOn != null) {
            out.writeBoolean(true);
            out.writeLong(this.createdOn.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.activationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.activationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.expirationTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.expirationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.processId != null) {
            out.writeBoolean(true);
            out.writeUTF(this.processId);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.processSessionId);
        if (this.subTaskStrategy != null) {
            out.writeBoolean(true);
            out.writeUTF(this.subTaskStrategy.toString());
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.processInstanceId = in.readLong();
        if (in.readBoolean()) {
            this.name = in.readUTF();
        }
        if (in.readBoolean()) {
            this.subject = in.readUTF();
        }
        if (in.readBoolean()) {
            this.description = in.readUTF();
        }
        if (in.readBoolean()) {
            this.status = Status.valueOf((String)in.readUTF());
        }
        this.priority = in.readInt();
        this.parentId = in.readLong();
        this.skipable = in.readBoolean();
        if (in.readBoolean()) {
            this.actualOwner = TaskModelProvider.getFactory().newUser();
            this.actualOwner.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdBy = TaskModelProvider.getFactory().newUser();
            this.createdBy.readExternal(in);
        }
        if (in.readBoolean()) {
            this.createdOn = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.activationTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.expirationTime = new Date(in.readLong());
        }
        if (in.readBoolean()) {
            this.processId = in.readUTF();
        }
        this.processSessionId = in.readInt();
        if (in.readBoolean()) {
            this.subTaskStrategy = SubTasksStrategy.valueOf((String)in.readUTF());
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(boolean skipable) {
        this.skipable = skipable;
    }

    public User getActualOwner() {
        return this.actualOwner;
    }

    public void setActualOwner(User actualOwner) {
        this.actualOwner = actualOwner;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(int processSessionId) {
        this.processSessionId = processSessionId;
    }

    public SubTasksStrategy getSubTaskStrategy() {
        return this.subTaskStrategy;
    }

    public void setSubTaskStrategy(SubTasksStrategy subTaskStrategy) {
        this.subTaskStrategy = subTaskStrategy;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public List<String> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<String> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationTime == null ? 0 : this.activationTime.hashCode());
        result = 31 * result + (this.actualOwner == null ? 0 : this.actualOwner.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.createdOn == null ? 0 : this.createdOn.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.subTaskStrategy == null ? 0 : this.subTaskStrategy.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        result = 31 * result + (this.skipable ? 1231 : 1237);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + this.processSessionId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSummaryImpl)) {
            return false;
        }
        TaskSummaryImpl other = (TaskSummaryImpl)obj;
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.activationTime == null ? other.activationTime != null : this.activationTime.getTime() != other.activationTime.getTime()) {
            return false;
        }
        if (this.actualOwner == null ? other.actualOwner != null : !this.actualOwner.equals(other.actualOwner)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdOn == null ? other.createdOn != null : this.createdOn.getTime() != other.createdOn.getTime()) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expirationTime == null ? other.expirationTime != null : this.expirationTime.getTime() != other.expirationTime.getTime()) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.subTaskStrategy == null ? other.subTaskStrategy != null : !this.subTaskStrategy.equals((Object)other.subTaskStrategy)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.parentId != other.parentId) {
            return false;
        }
        if (this.skipable != other.skipable) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        return this.processSessionId == other.processSessionId;
    }
}

