/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.GroupCommit;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordAssembler;
import org.apache.helix.ZNRecordBucketizer;
import org.apache.helix.ZNRecordUpdater;
import org.apache.helix.controller.restlet.ZNRecordUpdate;
import org.apache.helix.controller.restlet.ZkPropertyTransferClient;
import org.apache.helix.model.LiveInstance;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class ZKHelixDataAccessor
implements HelixDataAccessor,
ControllerChangeListener {
    private static Logger LOG = Logger.getLogger(ZKHelixDataAccessor.class);
    private final BaseDataAccessor<ZNRecord> _baseDataAccessor;
    final InstanceType _instanceType;
    private final String _clusterName;
    private final PropertyKey.Builder _propertyKeyBuilder;
    ZkPropertyTransferClient _zkPropertyTransferClient = null;
    private final GroupCommit _groupCommit = new GroupCommit();
    String _zkPropertyTransferSvcUrl = null;

    public ZKHelixDataAccessor(String clusterName, BaseDataAccessor<ZNRecord> baseDataAccessor) {
        this(clusterName, null, baseDataAccessor);
    }

    public ZKHelixDataAccessor(String clusterName, InstanceType instanceType, BaseDataAccessor<ZNRecord> baseDataAccessor) {
        this._clusterName = clusterName;
        this._instanceType = instanceType;
        this._baseDataAccessor = baseDataAccessor;
        this._propertyKeyBuilder = new PropertyKey.Builder(this._clusterName);
    }

    @Override
    public <T extends HelixProperty> boolean createProperty(PropertyKey key, T value) {
        PropertyType type = key.getType();
        String path = key.getPath();
        int options = this.constructOptions(type);
        boolean success = false;
        switch (type) {
            case STATEMODELDEFS: {
                if (!value.isValid()) break;
                success = this._baseDataAccessor.create(path, value.getRecord(), options);
                break;
            }
            default: {
                success = this._baseDataAccessor.create(path, value.getRecord(), options);
            }
        }
        return success;
    }

    @Override
    public <T extends HelixProperty> boolean setProperty(PropertyKey key, T value) {
        PropertyType type = key.getType();
        if (!value.isValid()) {
            throw new HelixException("The ZNRecord for " + (Object)((Object)type) + " is not valid.");
        }
        String path = key.getPath();
        int options = this.constructOptions(type);
        if (type.usePropertyTransferServer() && this._zkPropertyTransferSvcUrl != null && this._zkPropertyTransferClient != null) {
            ZNRecordUpdate update = new ZNRecordUpdate(path, ZNRecordUpdate.OpCode.SET, value.getRecord());
            this._zkPropertyTransferClient.enqueueZNRecordUpdate(update, this._zkPropertyTransferSvcUrl);
            return true;
        }
        boolean success = false;
        switch (type) {
            case IDEALSTATES: 
            case EXTERNALVIEW: {
                if (value.getBucketSize() > 0) {
                    ZNRecord metaRecord = new ZNRecord(value.getId());
                    metaRecord.setSimpleFields(value.getRecord().getSimpleFields());
                    success = this._baseDataAccessor.set(path, metaRecord, options);
                    if (!success) break;
                    ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(value.getBucketSize());
                    Map<String, ZNRecord> map = bucketizer.bucketize(value.getRecord());
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList<ZNRecord> bucketizedRecords = new ArrayList<ZNRecord>();
                    for (String bucketName : map.keySet()) {
                        paths.add(path + "/" + bucketName);
                        bucketizedRecords.add(map.get(bucketName));
                    }
                    this._baseDataAccessor.setChildren(paths, bucketizedRecords, options);
                    break;
                }
                success = this._baseDataAccessor.set(path, value.getRecord(), options);
                break;
            }
            default: {
                success = this._baseDataAccessor.set(path, value.getRecord(), options);
            }
        }
        return success;
    }

    @Override
    public <T extends HelixProperty> boolean updateProperty(PropertyKey key, T value) {
        PropertyType type = key.getType();
        String path = key.getPath();
        int options = this.constructOptions(type);
        boolean success = false;
        switch (type) {
            case CURRENTSTATES: {
                success = this._groupCommit.commit(this._baseDataAccessor, options, path, value.getRecord());
                break;
            }
            default: {
                if (type.usePropertyTransferServer()) {
                    if (this._zkPropertyTransferSvcUrl != null && this._zkPropertyTransferClient != null) {
                        ZNRecordUpdate update = new ZNRecordUpdate(path, ZNRecordUpdate.OpCode.UPDATE, value.getRecord());
                        this._zkPropertyTransferClient.enqueueZNRecordUpdate(update, this._zkPropertyTransferSvcUrl);
                        return true;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"getPropertyTransferUrl is null, skip updating the value");
                    }
                    return true;
                }
                success = this._baseDataAccessor.update(path, new ZNRecordUpdater(value.getRecord()), options);
            }
        }
        return success;
    }

    @Override
    public <T extends HelixProperty> List<T> getProperty(List<PropertyKey> keys) {
        if (keys == null || keys.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<HelixProperty> childValues = new ArrayList<HelixProperty>();
        ArrayList<String> paths = new ArrayList<String>();
        for (PropertyKey key : keys) {
            paths.add(key.getPath());
        }
        List<ZNRecord> children = this._baseDataAccessor.get(paths, null, 0);
        for (int i = 0; i < keys.size(); ++i) {
            PropertyKey key = keys.get(i);
            ZNRecord record = children.get(i);
            PropertyType type = key.getType();
            String path = key.getPath();
            int options = this.constructOptions(type);
            switch (type) {
                case IDEALSTATES: 
                case EXTERNALVIEW: 
                case CURRENTSTATES: {
                    List<ZNRecord> childRecords;
                    ZNRecord assembledRecord;
                    HelixProperty property;
                    int bucketSize;
                    if (record == null || (bucketSize = (property = new HelixProperty(record)).getBucketSize()) <= 0 || (assembledRecord = new ZNRecordAssembler().assemble(childRecords = this._baseDataAccessor.getChildren(path, null, options))) == null) break;
                    record.getSimpleFields().putAll(assembledRecord.getSimpleFields());
                    record.getListFields().putAll(assembledRecord.getListFields());
                    record.getMapFields().putAll(assembledRecord.getMapFields());
                    break;
                }
            }
            HelixProperty t = HelixProperty.convertToTypedInstance(key.getTypeClass(), record);
            childValues.add(t);
        }
        return childValues;
    }

    @Override
    public <T extends HelixProperty> T getProperty(PropertyKey key) {
        PropertyType type = key.getType();
        String path = key.getPath();
        int options = this.constructOptions(type);
        ZNRecord record = null;
        try {
            Stat stat = new Stat();
            record = this._baseDataAccessor.get(path, stat, options);
            if (record != null) {
                record.setCreationTime(stat.getCtime());
                record.setModifiedTime(stat.getMtime());
            }
        }
        catch (ZkNoNodeException e) {
            // empty catch block
        }
        switch (type) {
            case IDEALSTATES: 
            case EXTERNALVIEW: 
            case CURRENTSTATES: {
                List<ZNRecord> childRecords;
                ZNRecord assembledRecord;
                HelixProperty property;
                int bucketSize;
                if (record == null || (bucketSize = (property = new HelixProperty(record)).getBucketSize()) <= 0 || (assembledRecord = new ZNRecordAssembler().assemble(childRecords = this._baseDataAccessor.getChildren(path, null, options))) == null) break;
                record.getSimpleFields().putAll(assembledRecord.getSimpleFields());
                record.getListFields().putAll(assembledRecord.getListFields());
                record.getMapFields().putAll(assembledRecord.getMapFields());
                break;
            }
        }
        HelixProperty t = HelixProperty.convertToTypedInstance(key.getTypeClass(), record);
        return (T)t;
    }

    @Override
    public boolean removeProperty(PropertyKey key) {
        PropertyType type = key.getType();
        String path = key.getPath();
        int options = this.constructOptions(type);
        return this._baseDataAccessor.remove(path, options);
    }

    @Override
    public List<String> getChildNames(PropertyKey key) {
        int options;
        PropertyType type = key.getType();
        String parentPath = key.getPath();
        List<String> childNames = this._baseDataAccessor.getChildNames(parentPath, options = this.constructOptions(type));
        if (childNames == null) {
            childNames = Collections.emptyList();
        }
        return childNames;
    }

    @Override
    public <T extends HelixProperty> List<T> getChildValues(PropertyKey key) {
        PropertyType type = key.getType();
        String parentPath = key.getPath();
        int options = this.constructOptions(type);
        ArrayList<HelixProperty> childValues = new ArrayList<HelixProperty>();
        List<ZNRecord> children = this._baseDataAccessor.getChildren(parentPath, null, options);
        if (children != null) {
            for (ZNRecord record : children) {
                switch (type) {
                    case IDEALSTATES: 
                    case EXTERNALVIEW: 
                    case CURRENTSTATES: {
                        String childPath;
                        List<ZNRecord> childRecords;
                        ZNRecord assembledRecord;
                        HelixProperty property;
                        int bucketSize;
                        if (record == null || (bucketSize = (property = new HelixProperty(record)).getBucketSize()) <= 0 || (assembledRecord = new ZNRecordAssembler().assemble(childRecords = this._baseDataAccessor.getChildren(childPath = parentPath + "/" + record.getId(), null, options))) == null) break;
                        record.getSimpleFields().putAll(assembledRecord.getSimpleFields());
                        record.getListFields().putAll(assembledRecord.getListFields());
                        record.getMapFields().putAll(assembledRecord.getMapFields());
                        break;
                    }
                }
                if (record == null) continue;
                HelixProperty t = HelixProperty.convertToTypedInstance(key.getTypeClass(), record);
                childValues.add(t);
            }
        }
        return childValues;
    }

    @Override
    public <T extends HelixProperty> Map<String, T> getChildValuesMap(PropertyKey key) {
        PropertyType type = key.getType();
        String parentPath = key.getPath();
        int options = this.constructOptions(type);
        List<T> children = this.getChildValues(key);
        HashMap<String, HelixProperty> childValuesMap = new HashMap<String, HelixProperty>();
        for (HelixProperty t : children) {
            childValuesMap.put(t.getRecord().getId(), t);
        }
        return childValuesMap;
    }

    @Override
    public PropertyKey.Builder keyBuilder() {
        return this._propertyKeyBuilder;
    }

    private int constructOptions(PropertyType type) {
        int options = 0;
        options = type.isPersistent() ? (options |= AccessOption.PERSISTENT) : (options |= AccessOption.EPHEMERAL);
        return options;
    }

    @Override
    public <T extends HelixProperty> boolean[] createChildren(List<PropertyKey> keys, List<T> children) {
        int options = -1;
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<ZNRecord> records = new ArrayList<ZNRecord>();
        for (int i = 0; i < keys.size(); ++i) {
            PropertyKey key = keys.get(i);
            PropertyType type = key.getType();
            String path = key.getPath();
            paths.add(path);
            HelixProperty value = (HelixProperty)children.get(i);
            records.add(value.getRecord());
            options = this.constructOptions(type);
        }
        return this._baseDataAccessor.createChildren(paths, records, options);
    }

    @Override
    public <T extends HelixProperty> boolean[] setChildren(List<PropertyKey> keys, List<T> children) {
        int options = -1;
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<ZNRecord> records = new ArrayList<ZNRecord>();
        ArrayList<Object> bucketizedPaths = new ArrayList<Object>(Collections.nCopies(keys.size(), null));
        ArrayList<Object> bucketizedRecords = new ArrayList<Object>(Collections.nCopies(keys.size(), null));
        block4: for (int i = 0; i < keys.size(); ++i) {
            PropertyKey key = keys.get(i);
            PropertyType type = key.getType();
            String path = key.getPath();
            paths.add(path);
            options = this.constructOptions(type);
            HelixProperty value = (HelixProperty)children.get(i);
            switch (type) {
                case EXTERNALVIEW: {
                    if (value.getBucketSize() == 0) {
                        records.add(value.getRecord());
                        continue block4;
                    }
                    this._baseDataAccessor.remove(path, options);
                    ZNRecord metaRecord = new ZNRecord(value.getId());
                    metaRecord.setSimpleFields(value.getRecord().getSimpleFields());
                    records.add(metaRecord);
                    ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(value.getBucketSize());
                    Map<String, ZNRecord> map = bucketizer.bucketize(value.getRecord());
                    ArrayList<String> childBucketizedPaths = new ArrayList<String>();
                    ArrayList<ZNRecord> childBucketizedRecords = new ArrayList<ZNRecord>();
                    for (String bucketName : map.keySet()) {
                        childBucketizedPaths.add(path + "/" + bucketName);
                        childBucketizedRecords.add(map.get(bucketName));
                    }
                    bucketizedPaths.set(i, childBucketizedPaths);
                    bucketizedRecords.set(i, childBucketizedRecords);
                    continue block4;
                }
                case STATEMODELDEFS: {
                    if (!value.isValid()) continue block4;
                    records.add(value.getRecord());
                    continue block4;
                }
                default: {
                    records.add(value.getRecord());
                }
            }
        }
        boolean[] success = this._baseDataAccessor.setChildren(paths, records, options);
        ArrayList<String> allBucketizedPaths = new ArrayList<String>();
        ArrayList allBucketizedRecords = new ArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            if (!success[i] || bucketizedPaths.get(i) == null) continue;
            allBucketizedPaths.addAll((Collection)bucketizedPaths.get(i));
            allBucketizedRecords.addAll((Collection)bucketizedRecords.get(i));
        }
        this._baseDataAccessor.setChildren(allBucketizedPaths, allBucketizedRecords, options);
        return success;
    }

    @Override
    public BaseDataAccessor<ZNRecord> getBaseDataAccessor() {
        return this._baseDataAccessor;
    }

    @Override
    public <T extends HelixProperty> boolean[] updateChildren(List<String> paths, List<DataUpdater<ZNRecord>> updaters, int options) {
        return this._baseDataAccessor.updateChildren(paths, updaters, options);
    }

    public void shutdown() {
        if (this._zkPropertyTransferClient != null) {
            this._zkPropertyTransferClient.shutdown();
        }
    }

    @Override
    public void onControllerChange(NotificationContext changeContext) {
        LOG.info((Object)"Controller has changed");
        this.refreshZkPropertyTransferUrl();
        if (this._zkPropertyTransferClient == null && this._zkPropertyTransferSvcUrl != null && this._zkPropertyTransferSvcUrl.length() > 0) {
            LOG.info((Object)("Creating ZkPropertyTransferClient as we get url " + this._zkPropertyTransferSvcUrl));
            this._zkPropertyTransferClient = new ZkPropertyTransferClient(2);
        }
    }

    void refreshZkPropertyTransferUrl() {
        try {
            LiveInstance leader = (LiveInstance)this.getProperty(this.keyBuilder().controllerLeader());
            if (leader != null) {
                this._zkPropertyTransferSvcUrl = leader.getWebserviceUrl();
                LOG.info((Object)("_zkPropertyTransferSvcUrl : " + this._zkPropertyTransferSvcUrl + " Controller " + leader.getInstanceName()));
            } else {
                this._zkPropertyTransferSvcUrl = null;
            }
        }
        catch (Exception e) {
            this._zkPropertyTransferSvcUrl = null;
        }
    }
}

