/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.internal.executor.api.ExecutorService;

public class ExecutorServiceFactory {
    private static final String mode = System.getProperty("org.jbpm.cdi.executor.mode", "singleton");
    private static ExecutorService serviceInstance;

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf) {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure(emf);
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure(emf);
    }

    public static synchronized void resetExecutorService(ExecutorService executorService) {
        if (executorService.equals(serviceInstance)) {
            serviceInstance = null;
        }
    }

    private static ExecutorService configure(EntityManagerFactory emf) {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl();
        ExecutorImpl executor = new ExecutorImpl();
        ExecutorRunnable runnable = new ExecutorRunnable();
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        ClassCacheManager classCacheManager = new ClassCacheManager();
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        queryService.setCommandService(commandService);
        executor.setCommandService(commandService);
        adminService.setCommandService(commandService);
        runnable.setCommandService(commandService);
        ExecutorServiceImpl service = new ExecutorServiceImpl(executor);
        service.setQueryService(queryService);
        service.setExecutor(executor);
        service.setAdminService(adminService);
        runnable.setClassCacheManager(classCacheManager);
        runnable.setQueryService(queryService);
        executor.setExecutorRunnable(runnable);
        return service;
    }
}

