/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.persistence.NoResultException;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.Executor;
import org.kie.internal.executor.api.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorImpl
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorImpl.class);
    private ExecutorRunnable runnableTask;
    private TransactionalCommandService commandService;
    private ScheduledFuture<?> handle;
    private int threadPoolSize = Integer.parseInt(System.getProperty("org.kie.executor.pool.size", "1"));
    private int retries = Integer.parseInt(System.getProperty("org.kie.executor.retry.count", "3"));
    private int interval = Integer.parseInt(System.getProperty("org.kie.executor.interval", "3"));
    private ScheduledExecutorService scheduler;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setExecutorRunnable(ExecutorRunnable runnableTask) {
        this.runnableTask = runnableTask;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void init() {
        if (!"true".equalsIgnoreCase(System.getProperty("org.kie.executor.disabled"))) {
            logger.info("Starting Executor Component ...\n \t - Thread Pool Size: {}\n \t - Interval: {} Seconds\n \t - Retries per Request: {}\n", new Object[]{this.threadPoolSize, this.interval, this.retries});
            this.scheduler = Executors.newScheduledThreadPool(this.threadPoolSize);
            this.handle = this.scheduler.scheduleAtFixedRate(this.runnableTask, 2L, this.interval, TimeUnit.SECONDS);
        }
    }

    public void destroy() {
        logger.info(" >>>>> Destroying Executor !!!");
        if (this.handle != null) {
            this.handle.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public Long scheduleRequest(String commandId, CommandContext ctx) {
        return this.scheduleRequest(commandId, new Date(), ctx);
    }

    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        if (ctx == null) {
            throw new IllegalStateException("A Context Must Be Provided! ");
        }
        String businessKey = (String)ctx.getData("businessKey");
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setCommandName(commandId);
        requestInfo.setKey(businessKey);
        requestInfo.setStatus(STATUS.QUEUED);
        requestInfo.setTime(date);
        requestInfo.setMessage("Ready to execute");
        requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
        if (ctx.getData("retries") != null) {
            requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
        } else {
            requestInfo.setRetries(this.retries);
        }
        if (ctx != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(ctx);
                requestInfo.setRequestData(bout.toByteArray());
            }
            catch (IOException e) {
                logger.warn("Error serializing context data", (Throwable)e);
                requestInfo.setRequestData(null);
            }
        }
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{requestInfo}));
        logger.debug("Scheduling request for Command: {} - requestId: {} with {} retries", new Object[]{commandId, requestInfo.getId(), requestInfo.getRetries()});
        return requestInfo.getId();
    }

    public void cancelRequest(Long requestId) {
        logger.debug("Before - Cancelling Request with Id: {}", (Object)requestId);
        this.commandService.execute((Command)new LockAndCancelRequestInfoCommand(requestId));
        logger.debug("After - Cancelling Request with Id: {}", (Object)requestId);
    }

    private class LockAndCancelRequestInfoCommand
    implements GenericCommand<RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        LockAndCancelRequestInfoCommand(Long requestId) {
            this.requestId = requestId;
        }

        public RequestInfo execute(Context context) {
            HashMap<String, Number> params = new HashMap<String, Number>();
            params.put("id", this.requestId);
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (RequestInfo)ctx.queryAndLockWithParametersInTransaction("PendingRequestById", params, true, RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.CANCELLED);
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException e) {
                // empty catch block
            }
            return request;
        }
    }
}

