/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ScpClient;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SftpClient;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.UserAuthAgent;
import org.apache.sshd.client.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.client.auth.UserAuthPassword;
import org.apache.sshd.client.auth.UserAuthPublicKey;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.scp.DefaultScpClient;
import org.apache.sshd.client.sftp.DefaultSftpClient;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.channel.OpenChannelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSessionImpl
extends AbstractSession
implements ClientSession {
    private static final String AUTHENTICATION_SERVICE = "ssh-connection";
    private UserAuth userAuth;
    private volatile AuthFuture authFuture;
    private Map<Object, Object> metadataMap = new HashMap<Object, Object>();

    public ClientSessionImpl(ClientFactoryManager client, IoSession session) throws Exception {
        super(client, session);
        this.log.info("Session created...");
        this.sendClientIdentification();
        this.sendKexInit();
        this.authFuture = new DefaultAuthFuture(this.lock);
    }

    @Override
    public ClientFactoryManager getClientFactoryManager() {
        return (ClientFactoryManager)this.factoryManager;
    }

    public KeyExchange getKex() {
        return this.kex;
    }

    private boolean readyForAuth() {
        while (!this.authFuture.isDone()) {
            this.log.debug("waiting to send authentication");
            try {
                this.authFuture.await();
            }
            catch (InterruptedException e) {
                this.log.debug("Unexpected interrupt", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.authFuture.isSuccess()) {
            this.log.debug("already authenticated");
            throw new IllegalStateException("Already authenticated");
        }
        if (this.authFuture.getException() != null) {
            this.log.debug("probably closed", this.authFuture.getException());
            return false;
        }
        if (!this.authFuture.isFailure()) {
            this.log.debug("unexpected state");
            throw new IllegalStateException("Unexpected authentication state");
        }
        if (this.userAuth != null) {
            this.log.debug("authentication already in progress");
            throw new IllegalStateException("Authentication already in progress?");
        }
        this.log.debug("ready to try authentication with new lock");
        this.authFuture = new DefaultAuthFuture(this.lock);
        return true;
    }

    private void processUserAuth(Buffer buffer) throws IOException {
        this.log.debug("processing {}", (Object)this.userAuth);
        switch (this.userAuth.next(buffer)) {
            case Success: {
                this.log.debug("succeeded with {}", (Object)this.userAuth);
                this.authed = true;
                this.username = this.userAuth.getUsername();
                this.setState(Session.State.Running);
                this.authFuture.setAuthed(true);
                this.startHeartBeat();
                break;
            }
            case Failure: {
                this.log.debug("failed with {}", (Object)this.userAuth);
                this.userAuth = null;
                this.setState(Session.State.WaitForAuth);
                this.authFuture.setAuthed(false);
                break;
            }
            case Continued: {
                this.setState(Session.State.UserAuth);
                this.log.debug("continuing with {}", (Object)this.userAuth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture authAgent(String user) throws IOException {
        this.log.debug("Trying agent authentication");
        if (this.getFactoryManager().getAgentFactory() == null) {
            throw new IllegalStateException("No ssh agent factory has been configured");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.readyForAuth()) {
                this.userAuth = new UserAuthAgent(this, AUTHENTICATION_SERVICE, user);
                this.processUserAuth(null);
            }
            return this.authFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture authPassword(String user, String password) throws IOException {
        this.log.debug("Trying password authentication");
        Object object = this.lock;
        synchronized (object) {
            if (this.readyForAuth()) {
                this.userAuth = new UserAuthPassword(this, AUTHENTICATION_SERVICE, user, password);
                this.processUserAuth(null);
            }
            return this.authFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture authInteractive(String user, String password) throws IOException {
        this.log.debug("Trying keyboard-interactive authentication");
        Object object = this.lock;
        synchronized (object) {
            if (this.readyForAuth()) {
                this.userAuth = new UserAuthKeyboardInteractive(this, AUTHENTICATION_SERVICE, user, password);
                this.processUserAuth(null);
            }
            return this.authFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture authPublicKey(String user, KeyPair key) throws IOException {
        this.log.debug("Trying publickey authentication");
        Object object = this.lock;
        synchronized (object) {
            if (this.readyForAuth()) {
                this.userAuth = new UserAuthPublicKey(this, AUTHENTICATION_SERVICE, user, key);
                this.processUserAuth(null);
            }
            return this.authFuture;
        }
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type " + type);
    }

    @Override
    public ChannelShell createShellChannel() throws IOException {
        ChannelShell channel = new ChannelShell();
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelExec createExecChannel(String command) throws IOException {
        ChannelExec channel = new ChannelExec(command);
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public ScpClient createScpClient() {
        return new DefaultScpClient(this);
    }

    @Override
    public SftpClient createSftpClient() throws IOException {
        return new DefaultSftpClient(this);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        return this.getTcpipForwarder().startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        this.getTcpipForwarder().stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        return this.getTcpipForwarder().startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        this.getTcpipForwarder().stopRemotePortForwarding(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseFuture close(boolean immediately) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.authFuture.isDone()) {
                this.authFuture.setException(new SshException("Session is closed"));
            }
            return super.close(immediately);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessage(Buffer buffer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.doHandleMessage(buffer);
        }
    }

    protected void doHandleMessage(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.debug("Received packet {}", (Object)cmd);
        block0 : switch (cmd) {
            case SSH_MSG_DISCONNECT: {
                int code = buffer.getInt();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
                this.close(true);
                break;
            }
            case SSH_MSG_UNIMPLEMENTED: {
                int code = buffer.getInt();
                this.log.info("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case SSH_MSG_DEBUG: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case SSH_MSG_IGNORE: {
                this.log.info("Received SSH_MSG_IGNORE");
                break;
            }
            default: {
                switch (this.getState()) {
                    case ReceiveKexInit: {
                        if (cmd != SshConstants.Message.SSH_MSG_KEXINIT) {
                            this.log.error("Ignoring command " + (Object)((Object)cmd) + " while waiting for " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXINIT));
                            break block0;
                        }
                        this.log.info("Received SSH_MSG_KEXINIT");
                        this.receiveKexInit(buffer);
                        this.negociate();
                        this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                        this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                        this.setState(Session.State.Kex);
                        break block0;
                    }
                    case Kex: {
                        buffer.rpos(buffer.rpos() - 1);
                        if (!this.kex.next(buffer)) break block0;
                        this.checkHost();
                        this.sendNewKeys();
                        this.setState(Session.State.ReceiveNewKeys);
                        break block0;
                    }
                    case ReceiveNewKeys: {
                        if (cmd != SshConstants.Message.SSH_MSG_NEWKEYS) {
                            this.disconnect(2, "Protocol error: expected packet SSH_MSG_NEWKEYS, got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.info("Received SSH_MSG_NEWKEYS");
                        this.receiveNewKeys(false);
                        this.sendAuthRequest();
                        this.setState(Session.State.AuthRequestSent);
                        break block0;
                    }
                    case AuthRequestSent: {
                        if (cmd != SshConstants.Message.SSH_MSG_SERVICE_ACCEPT) {
                            this.disconnect(2, "Protocol error: expected packet SSH_MSG_SERVICE_ACCEPT, got " + (Object)((Object)cmd));
                            return;
                        }
                        this.authFuture.setAuthed(false);
                        this.setState(Session.State.WaitForAuth);
                        break block0;
                    }
                    case WaitForAuth: {
                        break block0;
                    }
                    case UserAuth: {
                        if (this.userAuth == null) {
                            throw new IllegalStateException("State is userAuth, but no user auth pending!!!");
                        }
                        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_BANNER) {
                            String welcome = buffer.getString();
                            String lang = buffer.getString();
                            this.log.debug("Welcome banner: " + welcome);
                            UserInteraction ui = this.getClientFactoryManager().getUserInteraction();
                            if (ui == null) break block0;
                            ui.welcome(welcome);
                            break block0;
                        }
                        buffer.rpos(buffer.rpos() - 1);
                        this.processUserAuth(buffer);
                        break block0;
                    }
                    case Running: {
                        switch (cmd) {
                            case SSH_MSG_REQUEST_SUCCESS: {
                                this.requestSuccess(buffer);
                                break block0;
                            }
                            case SSH_MSG_REQUEST_FAILURE: {
                                this.requestFailure(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_OPEN: {
                                this.channelOpen(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_OPEN_CONFIRMATION: {
                                this.channelOpenConfirmation(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_OPEN_FAILURE: {
                                this.channelOpenFailure(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_REQUEST: {
                                this.channelRequest(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_DATA: {
                                this.channelData(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_EXTENDED_DATA: {
                                this.channelExtendedData(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_FAILURE: {
                                this.channelFailure(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_WINDOW_ADJUST: {
                                this.channelWindowAdjust(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_EOF: {
                                this.channelEof(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_CLOSE: {
                                this.channelClose(buffer);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Unsupported command: " + (Object)((Object)cmd));
                    }
                    default: {
                        throw new IllegalStateException("Unsupported state: " + (Object)((Object)this.getState()));
                    }
                }
            }
        }
    }

    @Override
    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.closeFuture.isClosed()) {
                        cond |= 2;
                    }
                    if (this.authed) {
                        cond |= 8;
                    }
                    if (this.authFuture.isFailure()) {
                        cond |= 4;
                    }
                    if ((cond & mask) != 0) {
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                            continue block5;
                        }
                        this.lock.wait();
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(Session.State newState) {
        Object object = this.lock;
        synchronized (object) {
            super.setState(newState);
            this.lock.notifyAll();
        }
    }

    protected void startHeartBeat() {
        String intervalStr = this.getClientFactoryManager().getProperties().get("hearbeat-interval");
        try {
            int interval;
            int n = interval = intervalStr != null ? Integer.parseInt(intervalStr) : 0;
            if (interval > 0) {
                this.getClientFactoryManager().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                    public void run() {
                        ClientSessionImpl.this.sendHeartBeat();
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            }
        }
        catch (NumberFormatException e) {
            this.log.warn("Ignoring bad heartbeat interval: {}", (Object)intervalStr);
        }
    }

    protected void sendHeartBeat() {
        try {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_GLOBAL_REQUEST, 0);
            String request = this.getClientFactoryManager().getProperties().get("heartbeat-request");
            if (request == null) {
                request = "keepalive@sshd.apache.org";
            }
            buf.putString(request);
            buf.putBoolean(false);
            this.writePacket(buf);
        }
        catch (IOException e) {
            this.log.info("Error sending keepalive message", (Throwable)e);
        }
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.serverVersion = this.doReadIdentification(buffer);
        if (this.serverVersion == null) {
            return false;
        }
        this.log.info("Server version string: {}", (Object)this.serverVersion);
        if (!this.serverVersion.startsWith("SSH-2.0-") && !this.serverVersion.startsWith("SSH-1.99-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        return true;
    }

    private void sendClientIdentification() {
        this.clientVersion = "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.clientVersion);
    }

    private void sendKexInit() throws Exception {
        this.clientProposal = this.createProposal("ssh-rsa,ssh-dss");
        this.I_C = this.sendKexInit(this.clientProposal);
    }

    private void receiveKexInit(Buffer buffer) throws Exception {
        this.serverProposal = new String[10];
        this.I_S = this.receiveKexInit(buffer, this.serverProposal);
    }

    private void checkHost() throws SshException {
        SocketAddress remoteAddress;
        ServerKeyVerifier serverKeyVerifier = this.getClientFactoryManager().getServerKeyVerifier();
        if (!serverKeyVerifier.verifyServerKey(this, remoteAddress = this.ioSession.getRemoteAddress(), this.kex.getServerKey())) {
            throw new SshException("Server key did not validate");
        }
    }

    private void sendAuthRequest() throws Exception {
        this.log.info("Send SSH_MSG_SERVICE_REQUEST for ssh-userauth");
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_SERVICE_REQUEST, 0);
        buffer.putString("ssh-userauth");
        this.writePacket(buffer);
    }

    private void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        final int id = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        this.log.info("Received SSH_MSG_CHANNEL_OPEN {}", (Object)type);
        if (this.closing) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("SSH server is shutting down: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final Channel channel = (Channel)NamedFactory.Utils.create(this.getFactoryManager().getChannelFactories(), type);
        if (channel == null) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(3L);
            buf.putString("Unsupported channel type: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final int channelId = this.getNextChannelId();
        this.channels.put(channelId, channel);
        channel.init(this, channelId);
        channel.open(id, rwsize, rmpsize, buffer).addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                try {
                    if (future.isOpened()) {
                        Buffer buf = ClientSessionImpl.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_CONFIRMATION, 0);
                        buf.putInt(id);
                        buf.putInt(channelId);
                        buf.putInt(channel.getLocalWindow().getSize());
                        buf.putInt(channel.getLocalWindow().getPacketSize());
                        ClientSessionImpl.this.writePacket(buf);
                    } else if (future.getException() != null) {
                        Buffer buf = ClientSessionImpl.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
                        buf.putInt(id);
                        if (future.getException() instanceof OpenChannelException) {
                            buf.putInt(((OpenChannelException)future.getException()).getReasonCode());
                            buf.putString(future.getException().getMessage());
                        } else {
                            buf.putInt(0L);
                            buf.putString("Error opening channel: " + future.getException().getMessage());
                        }
                        buf.putString("");
                        ClientSessionImpl.this.writePacket(buf);
                    }
                }
                catch (IOException e) {
                    ClientSessionImpl.this.exceptionCaught(e);
                }
            }
        });
    }

    @Override
    public Map<Object, Object> getMetadataMap() {
        return this.metadataMap;
    }
}

