/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIoServiceFactory
implements IoServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactory.class);

    @Override
    public IoConnector createConnector(FactoryManager manager, IoHandler handler) {
        return DefaultIoServiceFactory.newInstance(IoServiceFactory.class).createConnector(manager, handler);
    }

    @Override
    public IoAcceptor createAcceptor(FactoryManager manager, IoHandler handler) {
        return DefaultIoServiceFactory.newInstance(IoServiceFactory.class).createAcceptor(manager, handler);
    }

    private static <T> T newInstance(Class<T> clazz) {
        T t;
        String factory = System.getProperty(clazz.getName());
        if (factory != null) {
            return DefaultIoServiceFactory.newInstance(clazz, factory);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (t = DefaultIoServiceFactory.tryLoad(ServiceLoader.load(clazz, cl))) != null) {
            return t;
        }
        if (cl != DefaultIoServiceFactory.class.getClassLoader() && (t = DefaultIoServiceFactory.tryLoad(ServiceLoader.load(clazz, DefaultIoServiceFactory.class.getClassLoader()))) != null) {
            return t;
        }
        throw new IllegalStateException("Could not find a valid sshd io provider");
    }

    private static <T> T tryLoad(ServiceLoader<T> loader) {
        Iterator<T> it = loader.iterator();
        while (it.hasNext()) {
            try {
                return it.next();
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory from ServiceLoader", t);
            }
        }
        return null;
    }

    private static <T> T newInstance(Class<T> clazz, String factory) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return clazz.cast(cl.loadClass(factory).newInstance());
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        if (cl != DefaultIoServiceFactory.class.getClassLoader()) {
            try {
                return clazz.cast(DefaultIoServiceFactory.class.getClassLoader().loadClass(factory).newInstance());
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + factory);
    }
}

